/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.htl.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.sling.scripting.sightly.compiler.CompilationUnit;

public class ScriptCompilationUnit
implements CompilationUnit {
    private Reader reader;
    private File sourceDirectory;
    private File script;
    private String scriptName;
    private static final int _16K = 16384;

    public ScriptCompilationUnit(File sourceDirectory, File script) throws FileNotFoundException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(script), StandardCharsets.UTF_8), 16384);
        this.sourceDirectory = sourceDirectory;
        this.script = script;
    }

    public String getScriptName() {
        if (this.scriptName == null) {
            this.scriptName = this.script.getAbsolutePath().substring(this.sourceDirectory.getAbsolutePath().length());
        }
        return this.scriptName;
    }

    public Reader getScriptReader() {
        return this.reader;
    }

    public void dispose() {
        IOUtils.closeQuietly((Reader)this.reader);
    }
}

