/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.feature.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.Os;
import org.apache.sling.maven.feature.launcher.Launch;
import org.apache.sling.maven.feature.launcher.ProcessTracker;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo
extends AbstractMojo {
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String JAVA_OPTS = "JAVA_OPTS";
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(required=true, defaultValue="1.1.4")
    private String featureLauncherVersion;
    @Parameter(required=true)
    private List<Launch> launches;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Component
    private ProcessTracker processes;
    @Component
    private ArchiverManager archiverManager;

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File launcher;
            VersionRange beforeAssemblyRange = VersionRange.createFromVersionSpec((String)"(,1.1.26]");
            boolean useAssembly = !beforeAssemblyRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(this.featureLauncherVersion));
            RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
            File workDir = new File(this.outputDirectory, "launchers");
            workDir.mkdirs();
            if (useAssembly) {
                DefaultArtifact launcherAssemblyArtifact = new DefaultArtifact("org.apache.sling:org.apache.sling.feature.launcher:tar.gz:" + this.featureLauncherVersion);
                File assemblyArchive = this.resolver.resolveArtifact(repositorySession, new ArtifactRequest((Artifact)launcherAssemblyArtifact, this.remoteRepos, null)).getArtifact().getFile();
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(assemblyArchive);
                unArchiver.setSourceFile(assemblyArchive);
                unArchiver.setDestFile(workDir);
                unArchiver.extract();
                Path relPath = Paths.get(launcherAssemblyArtifact.getArtifactId() + "-" + launcherAssemblyArtifact.getVersion(), "bin");
                relPath = Os.isFamily((String)"windows") ? relPath.resolve("launcher.bat") : relPath.resolve("launcher");
                launcher = workDir.toPath().resolve(relPath).toFile();
            } else {
                DefaultArtifact launcherArtifact = new DefaultArtifact("org.apache.sling:org.apache.sling.feature.launcher:" + this.featureLauncherVersion);
                launcher = this.resolver.resolveArtifact(repositorySession, new ArtifactRequest((Artifact)launcherArtifact, this.remoteRepos, null)).getArtifact().getFile();
            }
            for (Launch launch : this.launches) {
                if (launch.isSkip()) {
                    this.getLog().info((CharSequence)("Skipping starting launch with id " + launch.getId()));
                    continue;
                }
                launch.validate();
                Artifact artifact = this.toArtifact(launch.getFeature());
                ArtifactResult result = this.resolver.resolveArtifact(repositorySession, new ArtifactRequest(artifact, this.remoteRepos, null));
                File featureFile = result.getArtifact().getFile();
                String javahome = System.getenv(JAVA_HOME);
                if (javahome == null || javahome.isEmpty()) {
                    this.getLog().warn((CharSequence)"The JAVA_HOME env variable was not set, falling back to the java.home system property");
                    javahome = System.getProperty("java.home");
                }
                ArrayList<String> args = new ArrayList<String>();
                if (useAssembly) {
                    void var14_18;
                    String[] vmOptions;
                    HashMap<String, String> newEnv = new HashMap<String, String>(launch.getEnvironmentVariables());
                    newEnv.put(JAVA_HOME, javahome);
                    Object var14_17 = null;
                    for (String vmOption : vmOptions = launch.getLauncherArguments().getVmOptions()) {
                        if (vmOption == null || vmOption.isEmpty()) continue;
                        if (var14_18 == null) {
                            StringBuilder stringBuilder = new StringBuilder();
                        } else {
                            var14_18.append(" ");
                        }
                        var14_18.append(vmOption);
                    }
                    if (var14_18 != null) {
                        if (newEnv.containsKey(JAVA_OPTS)) {
                            var14_18.append(" ").append((String)newEnv.get(JAVA_OPTS));
                        }
                        newEnv.put(JAVA_OPTS, var14_18.toString());
                    }
                    args.add(launcher.getAbsolutePath());
                    launch.setEnvironmentVariables(newEnv);
                } else {
                    String[] vmOptions;
                    args.add(javahome + File.separatorChar + "bin" + File.separatorChar + "java");
                    for (String vmOption : vmOptions = launch.getLauncherArguments().getVmOptions()) {
                        if (vmOption == null || vmOption.isEmpty()) continue;
                        args.add(vmOption);
                    }
                    args.add("-jar");
                    args.add(launcher.getAbsolutePath());
                }
                if (launch.getRepositoryUrls() != null && !launch.getRepositoryUrls().isEmpty()) {
                    args.add("-u");
                    Iterator<Map.Entry<String, String>> joiner = new StringJoiner(",");
                    launch.getRepositoryUrls().forEach(((StringJoiner)((Object)joiner))::add);
                    args.add(((StringJoiner)((Object)joiner)).toString());
                }
                args.add("-f");
                args.add(featureFile.getAbsolutePath());
                args.add("-p");
                args.add(launch.getId());
                for (Map.Entry entry : launch.getLauncherArguments().getFrameworkProperties().entrySet()) {
                    args.add("-D");
                    args.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                for (Map.Entry<String, String> entry : launch.getLauncherArguments().getVariables().entrySet()) {
                    args.add("-V");
                    args.add(entry.getKey() + "=" + entry.getValue());
                }
                ProcessBuilder pb = new ProcessBuilder(args);
                pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
                pb.directory(workDir);
                launch.getEnvironmentVariables().entrySet().forEach(e -> {
                    this.getLog().info((CharSequence)("Setting environment variable '" + (String)e.getKey() + "' to '" + (String)e.getValue() + "'"));
                    pb.environment().put((String)e.getKey(), (String)e.getValue());
                });
                this.getLog().info((CharSequence)("Starting launch with id '" + launch.getId() + "', args=" + args));
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                final Process process = pb.start();
                Thread monitor = new Thread("launch-monitor-" + launch.getId()){

                    @Override
                    public void run() {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                System.out.println(line);
                                if (!line.contains("Framework started")) continue;
                                countDownLatch.countDown();
                                break;
                            }
                        }
                        catch (IOException e) {
                            StartMojo.this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
                        }
                    }
                };
                monitor.start();
                this.getLog().info((CharSequence)("Waiting for " + launch.getId() + " to start"));
                boolean started = countDownLatch.await(launch.getStartTimeoutSeconds(), TimeUnit.SECONDS);
                if (!started) {
                    ProcessTracker.stop(process);
                    throw new MojoExecutionException("Launch " + launch.getId() + " failed to start in " + launch.getStartTimeoutSeconds() + " seconds.");
                }
                this.processes.startTracking(launch.getId(), process);
            }
        }
        catch (IOException | InvalidVersionSpecificationException | NoSuchArchiverException | ArtifactResolutionException e2) {
            throw new MojoExecutionException(e2.getMessage(), (Exception)e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Execution interrupted", (Exception)e3);
        }
    }

    private Artifact toArtifact(Dependency dependency) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
    }
}

