/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.feature.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.feature.launcher.Launch;
import org.apache.sling.maven.feature.launcher.ProcessTracker;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(required=true, defaultValue="1.1.4")
    private String featureLauncherVersion;
    @Parameter(required=true)
    private List<Launch> launches;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Component
    private ProcessTracker processes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DefaultArtifact launcherArtifact = new DefaultArtifact("org.apache.sling:org.apache.sling.feature.launcher:" + this.featureLauncherVersion);
        try {
            RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
            File launcher = this.resolver.resolveArtifact(repositorySession, new ArtifactRequest((Artifact)launcherArtifact, this.remoteRepos, null)).getArtifact().getFile();
            File workDir = new File(this.outputDirectory, "launchers");
            workDir.mkdirs();
            for (Launch launch : this.launches) {
                launch.validate();
                Artifact artifact = this.toArtifact(launch.getFeature());
                ArtifactResult result = this.resolver.resolveArtifact(repositorySession, new ArtifactRequest(artifact, this.remoteRepos, null));
                File featureFile = result.getArtifact().getFile();
                ArrayList<String> args = new ArrayList<String>();
                args.add(System.getenv("JAVA_HOME") + File.separatorChar + "bin" + File.separatorChar + "java");
                args.add("-jar");
                args.add(launcher.getAbsolutePath());
                args.add("-f");
                args.add(featureFile.getAbsolutePath());
                args.add("-p");
                args.add(launch.getId());
                for (Map.Entry<String, String> frameworkProperty : launch.getLauncherArguments().getFrameworkProperties().entrySet()) {
                    args.add("-D");
                    args.add(frameworkProperty.getKey() + "=" + frameworkProperty.getValue());
                }
                ProcessBuilder pb = new ProcessBuilder(args);
                pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
                pb.directory(workDir);
                this.getLog().info((CharSequence)("Starting launch with id " + launch.getId()));
                final CountDownLatch latch = new CountDownLatch(1);
                final Process process = pb.start();
                Thread monitor = new Thread("launch-monitor-" + launch.getId()){

                    @Override
                    public void run() {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                System.out.println(line);
                                if (!line.contains("Framework started")) continue;
                                latch.countDown();
                                break;
                            }
                        }
                        catch (IOException e) {
                            StartMojo.this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
                        }
                    }
                };
                monitor.start();
                this.getLog().info((CharSequence)("Waiting for " + launch.getId() + " to start"));
                boolean started = latch.await(launch.getStartTimeoutSeconds(), TimeUnit.SECONDS);
                if (!started) {
                    ProcessTracker.stop(process);
                    throw new MojoExecutionException("Launch " + launch.getId() + " failed to start in " + launch.getStartTimeoutSeconds() + " seconds.");
                }
                this.processes.startTracking(launch.getId(), process);
            }
        }
        catch (IOException | ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Execution interrupted", (Exception)e);
        }
    }

    private Artifact toArtifact(Dependency dependency) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
    }
}

