/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.sling.testing.clients.SystemPropertiesConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerErrorRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ServerErrorRetryStrategy.class);
    private Collection<Integer> httpRetriesErrorCodes;

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        boolean needsRetry;
        int[] expectedStatus = (int[])context.getAttribute("expected_status");
        boolean bl = needsRetry = executionCount <= SystemPropertiesConfig.getHttpRetries() && this.responseRetryCondition(response, expectedStatus);
        if (SystemPropertiesConfig.isHttpLogRetries() && needsRetry && LOG.isWarnEnabled()) {
            LOG.warn("Request retry condition met: [count={}/{}], [expected-codes={}], [retry-codes={}]", new Object[]{executionCount, SystemPropertiesConfig.getHttpRetries(), expectedStatus, this.httpRetriesErrorCodes});
            LOG.warn("Request: {}", (Object)this.getRequestDetails(context));
            LOG.warn("Response: {}", (Object)this.getResponseDetails(response));
            try {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                LOG.warn("Response Body: {}", (Object)content);
            }
            catch (IOException exc) {
                LOG.warn("Failed to read the response body: {}", (Object)exc.getMessage());
            }
        }
        return needsRetry;
    }

    public long getRetryInterval() {
        return SystemPropertiesConfig.getHttpRetriesDelay();
    }

    private boolean responseRetryCondition(HttpResponse response, int ... expectedStatus) {
        Integer statusCode = response.getStatusLine().getStatusCode();
        Collection<Integer> errorCodes = SystemPropertiesConfig.getHttpRetriesErrorCodes();
        if (expectedStatus != null && expectedStatus.length > 0 && Arrays.stream(expectedStatus).anyMatch(expected -> statusCode == expected)) {
            return false;
        }
        if (errorCodes != null && !errorCodes.isEmpty()) {
            return errorCodes.contains(statusCode);
        }
        return statusCode >= 500 && statusCode < 600;
    }

    private String getRequestDetails(HttpContext context) {
        String details = "Not available";
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequestWrapper wrapper = (HttpRequestWrapper)clientContext.getAttribute("http.request", HttpRequestWrapper.class);
        if (wrapper != null) {
            StringBuilder sb = new StringBuilder(wrapper.getRequestLine().toString());
            sb.append(" [");
            Arrays.stream(wrapper.getAllHeaders()).forEach(header -> sb.append(header.getName()).append(": ").append(header.getValue()).append(", "));
            sb.append("]");
            details = sb.toString();
        }
        return details;
    }

    private String getResponseDetails(HttpResponse response) {
        String details = "Not available";
        if (response != null) {
            StringBuilder sb = new StringBuilder(response.getStatusLine().toString());
            sb.append(" [");
            Arrays.stream(response.getAllHeaders()).forEach(h -> sb.append(h.getName()).append(": ").append(h.getValue()).append(", "));
            sb.append("]");
            details = sb.toString();
        }
        return details;
    }
}

