// Licensed to Apache Software Foundation (ASF) under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Apache Software Foundation (ASF) licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// Code generated by go-bindata. DO NOT EDIT.
// sources:
// fetcher/templates/cluster_role.yaml (1.218kB)
// fetcher/templates/cluster_role_binding.yaml (1.205kB)
// fetcher/templates/configmap.yaml (3.082kB)
// fetcher/templates/deployment.yaml (2.084kB)
// fetcher/templates/service_account.yaml (1.088kB)
// injector/templates/annotations.yaml (3.362kB)
// injector/templates/configmap.yaml (1.2kB)
// injector/templates/javaagent.yaml (1.462kB)
// oapserver/templates/cluster_role.yaml (1.241kB)
// oapserver/templates/cluster_role_binding.yaml (1.207kB)
// oapserver/templates/deployment.yaml (3.937kB)
// oapserver/templates/ingress.yaml (1.672kB)
// oapserver/templates/service.yaml (1.782kB)
// oapserver/templates/service_account.yaml (1.09kB)
// storage/elasticsearch/templates/configmap.yaml (1.822kB)
// storage/elasticsearch/templates/service.yaml (1.322kB)
// storage/elasticsearch/templates/service_account.yaml (1.095kB)
// storage/elasticsearch/templates/statefulset.yaml (6.624kB)
// ui/templates/deployment.yaml (2.604kB)
// ui/templates/ingress.yaml (1.716kB)
// ui/templates/service.yaml (1.681kB)

package repo

import (
	"crypto/sha256"
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _fetcherTemplatesCluster_roleYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

kind: ClusterRole
apiVersion: rbac.authorization.k8s.io/v1
metadata:
  name: swck:fetcher
  labels:
    operator.skywalking.apache.org/application: fetcher
    operator.skywalking.apache.org/component: rbac
rules:
  - apiGroups: [""]
    resources: ["nodes", "nodes/proxy", "endpoints", "services", "pods"]
    verbs: ["get", "watch", "list"]
  - apiGroups: [""]
    resources: ["configmaps"]
    verbs: ["get"]
`)

func fetcherTemplatesCluster_roleYamlBytes() ([]byte, error) {
	return _fetcherTemplatesCluster_roleYaml, nil
}

func fetcherTemplatesCluster_roleYaml() (*asset, error) {
	bytes, err := fetcherTemplatesCluster_roleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "fetcher/templates/cluster_role.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xa8, 0xe2, 0x96, 0xd7, 0x97, 0x52, 0x31, 0x75, 0x66, 0x9b, 0x3, 0x64, 0xd6, 0x68, 0x4f, 0x7, 0xc9, 0x9a, 0xe, 0x86, 0x6c, 0x15, 0x42, 0x64, 0x53, 0x34, 0x3e, 0xe1, 0xdc, 0x62, 0x5f, 0x3e}}
	return a, nil
}

var _fetcherTemplatesCluster_role_bindingYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  name: swck:fetcher
  labels:
    operator.skywalking.apache.org/application: fetcher
    operator.skywalking.apache.org/component: rbac
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: swck:fetcher
subjects:
  - kind: ServiceAccount
    name: {{ .Name }}-fetcher
    namespace: {{ .Namespace }}
`)

func fetcherTemplatesCluster_role_bindingYamlBytes() ([]byte, error) {
	return _fetcherTemplatesCluster_role_bindingYaml, nil
}

func fetcherTemplatesCluster_role_bindingYaml() (*asset, error) {
	bytes, err := fetcherTemplatesCluster_role_bindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "fetcher/templates/cluster_role_binding.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x94, 0xd1, 0x52, 0x1b, 0x44, 0x28, 0xb4, 0x81, 0x6e, 0xdc, 0x93, 0xc8, 0x8, 0xa1, 0x7e, 0x63, 0x23, 0x78, 0xed, 0x66, 0x14, 0x33, 0xc4, 0x21, 0xea, 0x5e, 0x94, 0x3a, 0xed, 0x4a, 0x38, 0x81}}
	return a, nil
}

var _fetcherTemplatesConfigmapYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
{{ $types := .Spec.GetType }}
apiVersion: v1
kind: ConfigMap
metadata:
  name: {{ .Name }}-fetcher
  namespace: {{ .Namespace }}
  labels:
    app: fetcher
    operator.skywalking.apache.org/fetcher-name: {{ .Name }}
    operator.skywalking.apache.org/application: fetcher
    operator.skywalking.apache.org/component: configmap
data:
  collector.yaml: |-
    service:
      extensions: [zpages, health_check]
      pipelines:
        metrics:
          receivers: [prometheus]
          exporters: [logging, opencensus, prometheus]
    extensions:
      zpages:
        endpoint: "localhost:56888"
      health_check: {}
    exporters:
      logging:
      prometheus:
        endpoint: "0.0.0.0:9090"
      opencensus:
        endpoint: {{ .Spec.OAPServerAddress | quote }}
        insecure: true
    receivers:
      {{- if has "prometheus" $types }}
      prometheus:
        config:
          global:
            scrape_interval: 15s
            scrape_timeout: 10s
          scrape_configs:
          - job_name: kubernetes-pods
            kubernetes_sd_configs:
            - role: pod
            relabel_configs:
            - source_labels: []
              target_label: cluster
              replacement: {{ .Spec.ClusterName | quote }}
            - action: keep
              regex: true
              source_labels:
              - __meta_kubernetes_pod_annotation_prometheus_io_scrape
            - action: replace
              regex: (.+)
              source_labels:
              - __meta_kubernetes_pod_annotation_prometheus_io_path
              target_label: __metrics_path__
            - action: replace
              regex: ([^:]+)(?::\d+)?;(\d+)
              replacement: $$1:$$2
              source_labels:
              - __address__
              - __meta_kubernetes_pod_annotation_prometheus_io_port
              target_label: __address__
            - action: labelmap
              regex: __meta_kubernetes_pod_label_(.+)
            - action: replace
              source_labels:
              - __meta_kubernetes_namespace
              target_label: kubernetes_namespace
            - action: replace
              source_labels:
              - __meta_kubernetes_pod_name
              target_label: kubernetes_pod_name
      {{- end }}`)

func fetcherTemplatesConfigmapYamlBytes() ([]byte, error) {
	return _fetcherTemplatesConfigmapYaml, nil
}

func fetcherTemplatesConfigmapYaml() (*asset, error) {
	bytes, err := fetcherTemplatesConfigmapYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "fetcher/templates/configmap.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x78, 0x5c, 0x20, 0x2e, 0x4a, 0xd1, 0xc, 0xe0, 0xc3, 0x13, 0xec, 0x8e, 0x70, 0x6d, 0x50, 0x62, 0x8f, 0x8f, 0x1, 0x3c, 0xc3, 0xcc, 0x91, 0xf2, 0x40, 0xf9, 0x1, 0x21, 0x10, 0xae, 0x76, 0x85}}
	return a, nil
}

var _fetcherTemplatesDeploymentYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: apps/v1
kind: Deployment
metadata:
  name: {{ .Name }}-fetcher
  namespace: {{ .Namespace }}
  labels:
    app: fetcher
    operator.skywalking.apache.org/fetcher-name: {{ .Name }}
    operator.skywalking.apache.org/application: fetcher
    operator.skywalking.apache.org/component: deployment
spec:
  replicas: 1
  selector:
    matchLabels:
      app: fetcher
      operator.skywalking.apache.org/fetcher-name: {{ .Name }}
  template:
    metadata:
      labels:
        app: fetcher
        operator.skywalking.apache.org/fetcher-name: {{ .Name }}
        operator.skywalking.apache.org/application: fetcher
        operator.skywalking.apache.org/component: pod
    spec:
      serviceAccountName: {{ .Name }}-fetcher
      containers:
        - args:
            - --log-level=DEBUG
            - --config=/conf/collector.yaml
          image: otel/opentelemetry-collector:0.18.0
          imagePullPolicy: IfNotPresent
          name: otc-container
          volumeMounts:
            - mountPath: /conf
              name: otc-internal
      volumes:
        - configMap:
            defaultMode: 420
            items:
              - key: collector.yaml
                path: collector.yaml
            name: {{ .Name }}-fetcher
          name: otc-internal
`)

func fetcherTemplatesDeploymentYamlBytes() ([]byte, error) {
	return _fetcherTemplatesDeploymentYaml, nil
}

func fetcherTemplatesDeploymentYaml() (*asset, error) {
	bytes, err := fetcherTemplatesDeploymentYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "fetcher/templates/deployment.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x5d, 0xe2, 0x26, 0x9b, 0x90, 0xa9, 0x58, 0x5b, 0xce, 0xda, 0x61, 0x85, 0x4c, 0x9a, 0xfc, 0x29, 0xab, 0x6f, 0xd6, 0x48, 0x92, 0x24, 0xa5, 0x5a, 0xc6, 0xf6, 0xe, 0x54, 0xe5, 0xaf, 0xca, 0x3a}}
	return a, nil
}

var _fetcherTemplatesService_accountYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: v1
kind: ServiceAccount
metadata:
  name: {{ .Name }}-fetcher
  namespace: {{ .Namespace }}
  labels:
    operator.skywalking.apache.org/fetcher-name: {{ .Name }}
    operator.skywalking.apache.org/application: fetcher
    operator.skywalking.apache.org/component: rbac
`)

func fetcherTemplatesService_accountYamlBytes() ([]byte, error) {
	return _fetcherTemplatesService_accountYaml, nil
}

func fetcherTemplatesService_accountYaml() (*asset, error) {
	bytes, err := fetcherTemplatesService_accountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "fetcher/templates/service_account.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xb, 0x75, 0x7a, 0xa, 0x7f, 0xf7, 0x92, 0x19, 0x6b, 0x9d, 0x83, 0x8f, 0xf3, 0x4, 0x78, 0xe, 0x5a, 0x50, 0xab, 0x85, 0xd7, 0xc8, 0x78, 0xc3, 0x68, 0x53, 0xd3, 0xc6, 0x66, 0x93, 0xf3, 0x5c}}
	return a, nil
}

var _injectorTemplatesAnnotationsYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# name means the reference to configuration used in pod's annotations.
# defaultValue is the default value in agent.config
# vaildateFunc means use which function to validate the value
# Notice , the vaildateFunc must exist in validate.go , 
# if don't have the vaildateFunc , please set nil
# envName is the environment variable in agent.config

annotations:
  # Next is the annotation of the sidecar configuration
  - name: sidecar.skywalking.apache.org/initcontainer.Name
    defaultValue: inject-skywalking-agent
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/initcontainer.Image
    defaultValue: apache/skywalking-java-agent:8.8.0-java8
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/initcontainer.Command
    defaultValue: sh
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/initcontainer.args.Option
    defaultValue: -c
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/initcontainer.args.Command
    defaultValue: "mkdir -p /sky/agent && cp -r /skywalking/agent/* /sky/agent"
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/sidecarVolume.Name
    defaultValue: sky-agent
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/sidecarVolumeMount.MountPath
    defaultValue: /sky/agent
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/configmapVolume.ConfigMap.Name
    defaultValue: skywalking-swck-java-agent-configmap
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/configmapVolume.Name
    defaultValue: java-agent-configmap-volume
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/configmapVolumeMount.MountPath
    defaultValue: /sky/agent/config
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/env.Name
    defaultValue: AGENT_OPTS
    validateFunc: nil
    envName: nil

  - name: sidecar.skywalking.apache.org/env.Value
    defaultValue: -javaagent:/sky/agent/skywalking-agent.jar
    validateFunc: nil
    envName: nil

  # Next is the annotation of the java agent configuration
  - name: agent.skywalking.apache.org/agent.service_name
    defaultValue: Your_ApplicationName
    validateFunc: ValidateServiceName
    envName: SW_AGENT_NAME

  - name: agent.skywalking.apache.org/collector.backend_service
    defaultValue: 127.0.0.1:11800
    validateFunc: ValidateBackendServices
    envName: SW_AGENT_COLLECTOR_BACKEND_SERVICES`)

func injectorTemplatesAnnotationsYamlBytes() ([]byte, error) {
	return _injectorTemplatesAnnotationsYaml, nil
}

func injectorTemplatesAnnotationsYaml() (*asset, error) {
	bytes, err := injectorTemplatesAnnotationsYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "injector/templates/annotations.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd2, 0x9a, 0xe0, 0xe4, 0x15, 0x93, 0xed, 0xf7, 0xf7, 0x7b, 0xff, 0x1a, 0x27, 0x8f, 0x85, 0x54, 0xa1, 0x2d, 0x26, 0x53, 0x89, 0x7b, 0x7d, 0xf4, 0x6c, 0x32, 0xfe, 0xc, 0xbd, 0x76, 0x36, 0x59}}
	return a, nil
}

var _injectorTemplatesConfigmapYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: v1
kind: ConfigMap
metadata:
  name: skywalking-swck-java-agent-configmap 
  namespace: skywalking-swck-system
data:
  agent.config: |
    {{- $anno := getAgentAnnotations }}
    {{- range $anno -}}
    {{- if ne .DefaultValue "nil" }}
    {{parse .Name}}=${ {{- .EnvName}}:{{.DefaultValue -}} }
    {{- else}}
    {{parse .Name}}=${ {{- .EnvName}}:}
    {{- end -}}
    {{- end -}}`)

func injectorTemplatesConfigmapYamlBytes() ([]byte, error) {
	return _injectorTemplatesConfigmapYaml, nil
}

func injectorTemplatesConfigmapYaml() (*asset, error) {
	bytes, err := injectorTemplatesConfigmapYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "injector/templates/configmap.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc6, 0xee, 0xc8, 0x3f, 0x93, 0x98, 0x46, 0x72, 0x7e, 0x19, 0xa, 0x17, 0xc3, 0x8a, 0x76, 0x3f, 0xf5, 0x5f, 0x15, 0x53, 0x27, 0x92, 0xdc, 0xcc, 0x6c, 0x99, 0x70, 0x38, 0x7c, 0x75, 0x4e, 0x25}}
	return a, nil
}

var _injectorTemplatesJavaagentYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

{{- $configuration := config }}
apiVersion: operator.skywalking.apache.org/v1alpha1
kind: JavaAgent
metadata:
  name: {{SelectorName}}-javaagent
  namespace: {{Namespace}}
  ownerReferences:
  - apiVersion: {{ownerReference.APIVersion}}
    blockOwnerDeletion: {{ownerReference.BlockOwnerDeletion}}
    controller: {{ownerReference.Controller}}
    kind: {{ownerReference.Kind}}
    name: {{ownerReference.Name}}
    uid: {{ownerReference.UID}}
spec:
  podSelector: {{PodSelector}}
  serviceName: {{ServiceName}}
  backendService: {{BackendService}}
  agentConfiguration: 
  {{ range $key, $value := $configuration }}
    {{$key}}: {{$value}}
  {{- end -}}`)

func injectorTemplatesJavaagentYamlBytes() ([]byte, error) {
	return _injectorTemplatesJavaagentYaml, nil
}

func injectorTemplatesJavaagentYaml() (*asset, error) {
	bytes, err := injectorTemplatesJavaagentYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "injector/templates/javaagent.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x97, 0x6d, 0x88, 0xd3, 0x8d, 0xaa, 0x80, 0x98, 0xd0, 0x29, 0x76, 0x5e, 0x57, 0x90, 0xdf, 0x8a, 0x29, 0xb5, 0x7d, 0x71, 0x5e, 0xc2, 0xb4, 0xcb, 0xfa, 0x46, 0x29, 0x3c, 0x71, 0xd2, 0x74, 0x32}}
	return a, nil
}

var _oapserverTemplatesCluster_roleYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

kind: ClusterRole
apiVersion: rbac.authorization.k8s.io/v1
metadata:
  name: swck:oapserver
  labels:
    operator.skywalking.apache.org/application: oapserver
    operator.skywalking.apache.org/component: rbac
rules:
  - apiGroups: [""]
    resources: ["pods", "endpoints", "services"]
    verbs: ["get", "watch", "list"]
  - apiGroups: ["extensions"]
    resources: ["deployments", "replicasets"]
    verbs: ["get", "watch", "list"]
`)

func oapserverTemplatesCluster_roleYamlBytes() ([]byte, error) {
	return _oapserverTemplatesCluster_roleYaml, nil
}

func oapserverTemplatesCluster_roleYaml() (*asset, error) {
	bytes, err := oapserverTemplatesCluster_roleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "oapserver/templates/cluster_role.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xb5, 0xde, 0x59, 0x47, 0x2c, 0x69, 0xe9, 0xcd, 0x7e, 0xa7, 0x4, 0xf7, 0xf2, 0xa0, 0x1a, 0x1b, 0xb6, 0xa3, 0x42, 0xb3, 0x20, 0x49, 0x9b, 0x2f, 0x81, 0x87, 0xa0, 0x95, 0x73, 0x49, 0x6a, 0xdb}}
	return a, nil
}

var _oapserverTemplatesCluster_role_bindingYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  name: swck:oapserver
  labels:
    operator.skywalking.apache.org/application: oapserver
    operator.skywalking.apache.org/component: rbac
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: swck:oapserver
subjects:
  - kind: ServiceAccount
    name: {{ .Name }}-oap
    namespace: {{ .Namespace }}
`)

func oapserverTemplatesCluster_role_bindingYamlBytes() ([]byte, error) {
	return _oapserverTemplatesCluster_role_bindingYaml, nil
}

func oapserverTemplatesCluster_role_bindingYaml() (*asset, error) {
	bytes, err := oapserverTemplatesCluster_role_bindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "oapserver/templates/cluster_role_binding.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xf8, 0x15, 0xc5, 0xe0, 0xe7, 0x4e, 0xeb, 0xed, 0x61, 0xda, 0xad, 0x6c, 0x43, 0xf, 0x80, 0x5, 0x4c, 0x47, 0xbc, 0x20, 0xe7, 0xc6, 0xdf, 0x63, 0xcf, 0x9b, 0x54, 0x56, 0x1f, 0x4, 0xbf, 0x1c}}
	return a, nil
}

var _oapserverTemplatesDeploymentYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: apps/v1
kind: Deployment
metadata:
  name: {{ .Name }}-oap
  namespace: {{ .Namespace }}
  labels:
    app: oap
    operator.skywalking.apache.org/oap-server-name: {{ .Name }}
    operator.skywalking.apache.org/application: oapserver
    operator.skywalking.apache.org/component: deployment

spec:
  replicas: {{ .Spec.Instances }}
  minReadySeconds: 5
  selector:
    matchLabels:
      app: oap
      operator.skywalking.apache.org/oap-server-name: {{ .Name }}
  template:
    metadata:
      labels:
        app: oap
        operator.skywalking.apache.org/oap-server-name: {{ .Name }}
        operator.skywalking.apache.org/application: oapserver
        operator.skywalking.apache.org/component: pod
    spec:
      serviceAccountName: {{ .Name }}-oap
      affinity:
        podAntiAffinity:
          preferredDuringSchedulingIgnoredDuringExecution:
            - weight: 1
              podAffinityTerm:
                topologyKey: kubernetes.io/hostname
                labelSelector:
                  matchLabels:
                    app: oap
                    operator.skywalking.apache.org/oap-server-name: {{ .Name }}
      containers:
        - name: oap
          image: {{ .Spec.Image }}
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 11800
              name: grpc
            - containerPort: 12800
              name: rest
            - containerPort: 1234
              name: http-monitoring
          livenessProbe:
            initialDelaySeconds: 10
            timeoutSeconds: 10
            periodSeconds: 30
            failureThreshold: 10
            successThreshold: 1
            exec:
              command:
                - /skywalking/bin/swctl
                - ch
          readinessProbe:
            initialDelaySeconds: 10
            timeoutSeconds: 10
            periodSeconds: 30
            failureThreshold: 10
            successThreshold: 1
            exec:
              command:
                - /skywalking/bin/swctl
                - ch
          {{if .Spec.StorageConfig.Storage.Spec.Security.TLS}}
          volumeMounts:
            - name: cert
              mountPath: /skywalking/p12
          {{end}}
          env:
            - name: JAVA_OPTS
              value: -Xmx2048M
            - name: SW_CLUSTER
              value: kubernetes
            - name: SW_CLUSTER_K8S_NAMESPACE
              value: "{{ .Namespace }}"
            - name: SW_CLUSTER_K8S_LABEL
              value: "app=oap,operator.skywalking.apache.org/oap-server-name={{ .Name }}"
            - name: SKYWALKING_COLLECTOR_UID
              valueFrom:
                fieldRef:
                  fieldPath: metadata.uid
            - name: SW_TELEMETRY
              value: prometheus
            - name: SW_HEALTH_CHECKER
              value: default
          {{range .Spec.Config}}
            - name: {{ .Name }}
              value: {{ .Value }}
          {{end}}
      {{if .Spec.StorageConfig.Storage.Spec.Security.TLS}}
      volumes:
        - name: cert
          secret:
            secretName:  "skywalking-storage"
      {{end}}
`)

func oapserverTemplatesDeploymentYamlBytes() ([]byte, error) {
	return _oapserverTemplatesDeploymentYaml, nil
}

func oapserverTemplatesDeploymentYaml() (*asset, error) {
	bytes, err := oapserverTemplatesDeploymentYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "oapserver/templates/deployment.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xcf, 0x8a, 0xdc, 0x5b, 0xc4, 0x54, 0x0, 0xa7, 0xe0, 0x7d, 0xb1, 0x27, 0x71, 0x22, 0xf5, 0xfd, 0x8a, 0x64, 0x6b, 0xa, 0x70, 0x4b, 0x37, 0x3d, 0x9a, 0x14, 0xa8, 0x3d, 0x29, 0x59, 0xe2, 0xc2}}
	return a, nil
}

var _oapserverTemplatesIngressYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
 
{{- $ingress := .Spec.Service.Ingress }}
{{ if $ingress.Host }}
apiVersion: networking.k8s.io/v1beta1
kind: Ingress
metadata:
  name: {{ .Name }}-ui
  namespace: {{ .Namespace }}
  labels:
    app: ui
    operator.skywalking.apache.org/ui-name: {{ .Name }}
    operator.skywalking.apache.org/application: ui
    operator.skywalking.apache.org/component: deployment
  annotations:
    {{- range $key, $value := $ingress.Annotations }}
    {{ $key }}: {{ $value | quote }}
    {{- end }}
spec:
  rules:
    - host: {{ $ingress.Host }}
      http:
        paths:
          - path: /*
            backend:
              serviceName: {{ .Name }}-oap
              servicePort: 12800
  {{- if $ingress.IngressClassName }}
  ingressClassName: {{ $ingress.IngressClassName }}
  {{end}}
  {{- if $ingress.TLS }}
  tls:
{{ toYAML $ingress.TLS | indent 4 }}
  {{end}}
{{end}}
`)

func oapserverTemplatesIngressYamlBytes() ([]byte, error) {
	return _oapserverTemplatesIngressYaml, nil
}

func oapserverTemplatesIngressYaml() (*asset, error) {
	bytes, err := oapserverTemplatesIngressYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "oapserver/templates/ingress.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x9a, 0x2, 0xeb, 0x33, 0x6f, 0x15, 0x7c, 0x82, 0x23, 0x94, 0xe1, 0x20, 0x4f, 0x3, 0xd7, 0x23, 0xc6, 0xd0, 0x3a, 0xc6, 0x44, 0x3a, 0xc0, 0x8f, 0xeb, 0x47, 0x57, 0x9a, 0x2d, 0x49, 0xea, 0x5a}}
	return a, nil
}

var _oapserverTemplatesServiceYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

{{- $svc := .Spec.Service.Template }}
apiVersion: v1
kind: Service
metadata:
  name: {{ .Name }}-oap
  namespace: {{ .Namespace }}
  labels:
    app: oap
    operator.skywalking.apache.org/oap-server-name: {{ .Name }}
    operator.skywalking.apache.org/application: oapserver
    operator.skywalking.apache.org/component: service
spec:
  type: {{ $svc.Type }}
  ports:
  - port: 12800
    name: rest
  - port: 11800
    name: grpc
  - port: 1234
    name: http-monitoring
  {{- if $svc.ExternalIPs }}
  externalIPs:
    {{- range $value := $svc.ExternalIPs }}
    - {{ $value | quote }}
    {{- end }}
  {{- end }}
  {{- if $svc.LoadBalancerIP }}
  loadBalancerIP: {{ $svc.LoadBalancerIP }}
  {{- end }}
  {{- if $svc.LoadBalancerSourceRanges }}
  loadBalancerSourceRanges:
    {{- range $value := $svc.LoadBalancerSourceRanges }}
    - {{ $value | quote }}
    {{- end }}
  {{- end }}
  selector:
    app: oap
    operator.skywalking.apache.org/oap-server-name: {{ .Name }}

`)

func oapserverTemplatesServiceYamlBytes() ([]byte, error) {
	return _oapserverTemplatesServiceYaml, nil
}

func oapserverTemplatesServiceYaml() (*asset, error) {
	bytes, err := oapserverTemplatesServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "oapserver/templates/service.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x3a, 0x76, 0x46, 0xaa, 0x13, 0x1b, 0x93, 0x29, 0x97, 0xcd, 0xa3, 0x61, 0xf2, 0x8f, 0x2d, 0xf, 0xcd, 0x88, 0xf6, 0xd, 0x32, 0xae, 0x16, 0x3e, 0x55, 0x33, 0x43, 0xe9, 0x16, 0xd0, 0xe2, 0xe0}}
	return a, nil
}

var _oapserverTemplatesService_accountYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: v1
kind: ServiceAccount
metadata:
  name: {{ .Name }}-oap
  namespace: {{ .Namespace }}
  labels:
    operator.skywalking.apache.org/oap-server-name: {{ .Name }}
    operator.skywalking.apache.org/application: oapserver
    operator.skywalking.apache.org/component: rbac

`)

func oapserverTemplatesService_accountYamlBytes() ([]byte, error) {
	return _oapserverTemplatesService_accountYaml, nil
}

func oapserverTemplatesService_accountYaml() (*asset, error) {
	bytes, err := oapserverTemplatesService_accountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "oapserver/templates/service_account.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x35, 0x3b, 0x36, 0x6, 0xcc, 0x9, 0x84, 0x7d, 0x62, 0x48, 0x31, 0xcf, 0x17, 0xec, 0xd1, 0xdd, 0x83, 0x0, 0x86, 0x6a, 0x50, 0xd5, 0xb6, 0x4a, 0x23, 0xdc, 0xea, 0xd, 0x80, 0x87, 0x2, 0x24}}
	return a, nil
}

var _storageElasticsearchTemplatesConfigmapYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: v1
kind: ConfigMap
metadata:
  name: {{ .Name }}-config
  namespace: {{ .Namespace }}
data:
  elasticsearch.yml: |
      network.host: 0.0.0.0
      {{ if .Spec.Security.User.SecretName }}
      xpack.security.enabled: true
      xpack.security.transport.ssl.enabled: true
      xpack.security.transport.ssl.verification_mode: certificate
      xpack.security.transport.ssl.keystore.path: storage.p12
      xpack.security.transport.ssl.keystore.password: skywalking
      xpack.security.transport.ssl.truststore.path: storage.p12
      xpack.security.transport.ssl.truststore.password: skywalking
      {{end}}
      {{ if .Spec.Security.TLS }}
      xpack.security.http.ssl.enabled: true
      xpack.security.http.ssl.verification_mode: certificate
      xpack.security.http.ssl.keystore.path: storage.p12
      xpack.security.http.ssl.keystore.password: skywalking
      xpack.security.http.ssl.truststore.path: storage.p12
      xpack.security.http.ssl.truststore.password: skywalking
      {{end}}


`)

func storageElasticsearchTemplatesConfigmapYamlBytes() ([]byte, error) {
	return _storageElasticsearchTemplatesConfigmapYaml, nil
}

func storageElasticsearchTemplatesConfigmapYaml() (*asset, error) {
	bytes, err := storageElasticsearchTemplatesConfigmapYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "storage/elasticsearch/templates/configmap.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x23, 0x88, 0x69, 0x87, 0xef, 0x9a, 0xcc, 0xe6, 0x9b, 0x4e, 0x2b, 0xcc, 0x55, 0x75, 0x78, 0x9d, 0x59, 0x5f, 0x6b, 0xc0, 0x27, 0xa0, 0x8, 0x10, 0xff, 0xb8, 0x38, 0xba, 0xcf, 0xed, 0x1d, 0x9d}}
	return a, nil
}

var _storageElasticsearchTemplatesServiceYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

kind: Service
apiVersion: v1
metadata:
  name:  {{ .Spec.ServiceName }}
  namespace: {{ .Namespace }}
  labels:
    app: es
    operator.skywalking.apache.org/es-name: {{ .Name }}
    operator.skywalking.apache.org/application: elasticsearch
    operator.skywalking.apache.org/component: service
spec:
  clusterIP: None
  selector:
    app: es
    operator.skywalking.apache.org/es-name: {{ .Name }}
  publishNotReadyAddresses: true
  ports:
    - name: http
      port: 9200
    - name: transport
      port: 9300

`)

func storageElasticsearchTemplatesServiceYamlBytes() ([]byte, error) {
	return _storageElasticsearchTemplatesServiceYaml, nil
}

func storageElasticsearchTemplatesServiceYaml() (*asset, error) {
	bytes, err := storageElasticsearchTemplatesServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "storage/elasticsearch/templates/service.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x73, 0xfc, 0xe1, 0x33, 0x2e, 0xc2, 0x4, 0x23, 0x44, 0x26, 0xe5, 0x85, 0x9d, 0x58, 0xe7, 0xe5, 0x2a, 0xee, 0x7e, 0x6c, 0x39, 0xbf, 0x31, 0x4a, 0x49, 0xb9, 0xf7, 0x6b, 0xa8, 0x38, 0x79, 0x82}}
	return a, nil
}

var _storageElasticsearchTemplatesService_accountYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: v1
kind: ServiceAccount
metadata:
  name: {{ .Name }}-elasticsearch
  namespace: {{ .Namespace }}
  labels:
    operator.skywalking.apache.org/es-name: {{ .Name }}
    operator.skywalking.apache.org/application: elasticsearch
    operator.skywalking.apache.org/component: rbac
`)

func storageElasticsearchTemplatesService_accountYamlBytes() ([]byte, error) {
	return _storageElasticsearchTemplatesService_accountYaml, nil
}

func storageElasticsearchTemplatesService_accountYaml() (*asset, error) {
	bytes, err := storageElasticsearchTemplatesService_accountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "storage/elasticsearch/templates/service_account.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe6, 0xe2, 0x5d, 0x98, 0xe2, 0xbb, 0x1, 0xf0, 0x92, 0x2e, 0x76, 0x6f, 0xc2, 0x7d, 0x95, 0x7, 0xd4, 0x74, 0xa7, 0x40, 0x55, 0x1f, 0x9f, 0xf9, 0x25, 0x92, 0x9f, 0xea, 0x13, 0x49, 0xca, 0x43}}
	return a, nil
}

var _storageElasticsearchTemplatesStatefulsetYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: apps/v1
kind: StatefulSet
metadata:
  name: {{ .Name }}-elasticsearch
  namespace: {{ .Namespace }}
  labels:
    app: es
    operator.skywalking.apache.org/es-name: {{ .Name }}
    operator.skywalking.apache.org/application: elasticsearch
    operator.skywalking.apache.org/component: statefulset
spec:
  serviceName:  {{ .Spec.ServiceName }}
  replicas: {{ .Spec.Instances }}
  selector:
    matchLabels:
      app: es
      operator.skywalking.apache.org/es-name: {{ .Name }}
  podManagementPolicy: Parallel
  updateStrategy:
    type: RollingUpdate
  template:
    metadata:
      labels:
        app: es
        operator.skywalking.apache.org/es-name: {{ .Name }}
        operator.skywalking.apache.org/application: elasticsearch
        operator.skywalking.apache.org/component: statefulset
    spec:
      serviceAccountName: {{ .Name }}-elasticsearch
      affinity:
        podAntiAffinity:
          requiredDuringSchedulingIgnoredDuringExecution:
              - labelSelector:
                matchExpressions:
                  - key: app
                    operator: In
                    values:
                      - "es"
                topologyKey: kubernetes.io/hostname
      initContainers:
        - name: configure-sysctl
          securityContext:
            runAsUser: 0
            privileged: true
          image: "{{ .Spec.Image }}"
          imagePullPolicy: IfNotPresent
          command: [ "sysctl", "-w", "vm.max_map_count=262144" ]
      containers:
        - name: elasticsearch
          image: {{ .Spec.Image }}
          resources:
            limits:
              cpu: {{ .Spec.ResourceCnfig.Limit }}
            requests:
              cpu: {{ .Spec.ResourceCnfig.Requests }}
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 9200
              name: http
              protocol: TCP
            - containerPort: 9300
              name: transport
              protocol: TCP
          volumeMounts:
            - name: config
              mountPath: /usr/share/elasticsearch/config/elasticsearch.yml
              subPath: elasticsearch.yml
            {{ if .Spec.Security.User.SecretName }}
            - name: cert
              mountPath: "/usr/share/elasticsearch/config/storage.p12"
              subPath: storage.p12
            {{end}}
          env:
            - name: cluster.name
              value: "{{ .Name }}-skywalking-es"
            - name: node.name
              valueFrom:
                fieldRef:
                  fieldPath: metadata.name
            - name: thread_pool.write.queue_size
              value: "1000"
            {{ range .Spec.Config }}
            - name: {{ .Name }}
              value: {{ .Value }}
            {{end}}
          readinessProbe:
            exec:
              command:
                - sh
                - -c
                - |
                  #!/usr/bin/env bash -e
                  # Exit if ELASTIC_PASSWORD in unset
                  if [ -z "${ELASTIC_PASSWORD}" ]; then
                    echo "ELASTIC_PASSWORD variable is missing, exiting"
                    exit 1
                  fi
                  # If the node is starting up wait for the cluster to be ready (request params: "wait_for_status=green&timeout=1s" )
                  # Once it has started only check that the node itself is responding
                  START_FILE=/tmp/.es_start_file
                  http () {
                    local path="${1}"
                    local args="${2}"
                    set -- -XGET -s
                    if [ "$args" != "" ]; then
                      set -- "$@" $args
                    fi
                    set -- "$@" -u "elastic:${ELASTIC_PASSWORD}"
                    curl --output /dev/null -k "$@" "{{ getProtocol .Spec.Security.TLS }}://127.0.0.1:9200${path}"
                  }
                  if [ -f "${START_FILE}" ]; then
                    echo 'Elasticsearch is already running, lets check the node is healthy'
                    HTTP_CODE=$(http "/" "-w %{http_code}")
                    RC=$?
                    if [[ ${RC} -ne 0 ]]; then
                      echo "curl --output /dev/null -k -XGET -s -w '%{http_code}' \${BASIC_AUTH} {{ getProtocol .Spec.Security.TLS }}://127.0.0.1:9200/ failed with RC ${RC}"
                      exit ${RC}
                    fi
                    # ready if HTTP code 200
                    if [[ ${HTTP_CODE} == "200" ]]; then
                      exit 0
                    else
                      echo "curl --output /dev/null -k -XGET -s -w '%{http_code}' \${BASIC_AUTH} {{ getProtocol .Spec.Security.TLS }}://127.0.0.1:9200/ failed with HTTP code ${HTTP_CODE}"
                      exit 1
                    fi
                  else
                    echo 'Waiting for elasticsearch cluster to become ready (request params: "wait_for_status=green&timeout=1s" )'
                    if http "/_cluster/health?wait_for_status=green&timeout=1s" "--fail" ; then
                      touch ${START_FILE}
                      exit 0
                    else
                      echo 'Cluster is not yet ready (request params: "wait_for_status=green&timeout=1s" )'
                      exit 1
                    fi
                  fi
            failureThreshold: 10
            initialDelaySeconds: 10
            periodSeconds: 12
            successThreshold: 1
            timeoutSeconds: 12
      volumes:
        - name: config
          configMap:
            name: {{ .Name }}-config
            items:
                - key: elasticsearch.yml
                  path: elasticsearch.yml
        {{ if .Spec.Security.User.SecretName }}
        - name: cert
          secret:
            secretName:  "skywalking-storage"
        {{end}}`)

func storageElasticsearchTemplatesStatefulsetYamlBytes() ([]byte, error) {
	return _storageElasticsearchTemplatesStatefulsetYaml, nil
}

func storageElasticsearchTemplatesStatefulsetYaml() (*asset, error) {
	bytes, err := storageElasticsearchTemplatesStatefulsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "storage/elasticsearch/templates/statefulset.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x7f, 0x54, 0x31, 0xb6, 0xbf, 0xaf, 0xb2, 0x47, 0xea, 0xb2, 0x4f, 0x5, 0x54, 0xd6, 0x55, 0xa2, 0x68, 0x47, 0xb2, 0x78, 0x3a, 0xf3, 0x9, 0xf4, 0x56, 0x12, 0xd4, 0x99, 0xcf, 0x23, 0x5e, 0xe7}}
	return a, nil
}

var _uiTemplatesDeploymentYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

apiVersion: apps/v1
kind: Deployment
metadata:
  name: {{ .Name }}-ui
  namespace: {{ .Namespace }}
  labels:
    app: ui
    operator.skywalking.apache.org/ui-name: {{ .Name }}
    operator.skywalking.apache.org/application: ui
    operator.skywalking.apache.org/component: deployment
spec:
  replicas: {{ .Spec.Instances }}
  minReadySeconds: 5
  selector:
    matchLabels:
      app: ui
      operator.skywalking.apache.org/ui-name: {{ .Name }}
  template:
    metadata:
      labels:
        app: ui
        operator.skywalking.apache.org/ui-name: {{ .Name }}
        operator.skywalking.apache.org/application: ui
        operator.skywalking.apache.org/component: deployment
    spec:
      affinity:
        podAntiAffinity:
          preferredDuringSchedulingIgnoredDuringExecution:
            - weight: 1
              podAffinityTerm:
                topologyKey: kubernetes.io/hostname
                labelSelector:
                  matchLabels:
                    app: ui
                    operator.skywalking.apache.org/ui-name: {{ .Name }}
      containers:
      - name: ui
        image: {{ .Spec.Image }}
        imagePullPolicy: IfNotPresent
        ports:
        - containerPort: 8080
          name: page
        livenessProbe:
          initialDelaySeconds: 10
          timeoutSeconds: 10
          periodSeconds: 30
          failureThreshold: 3
          successThreshold: 1
          httpGet:
            path: /
            port: 8080
        readinessProbe:
          initialDelaySeconds: 10
          timeoutSeconds: 10
          periodSeconds: 30
          failureThreshold: 3
          successThreshold: 1
          httpGet:
            path: /
            port: 8080
        env:
          - name: SW_OAP_ADDRESS
            value: {{ .Spec.OAPServerAddress }}
`)

func uiTemplatesDeploymentYamlBytes() ([]byte, error) {
	return _uiTemplatesDeploymentYaml, nil
}

func uiTemplatesDeploymentYaml() (*asset, error) {
	bytes, err := uiTemplatesDeploymentYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "ui/templates/deployment.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x19, 0x7d, 0xe7, 0x88, 0xad, 0x5b, 0x81, 0x96, 0xe0, 0xbd, 0x6c, 0xfe, 0x62, 0x8, 0x9f, 0x7b, 0xca, 0x2, 0x25, 0x75, 0x8c, 0x4, 0xee, 0xd4, 0xb9, 0xbf, 0xee, 0x8f, 0x2d, 0xa8, 0x5d, 0xb9}}
	return a, nil
}

var _uiTemplatesIngressYaml = []byte(`# Licensed to Apache Software Foundation (ASF) under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Apache Software Foundation (ASF) licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
 
{{- $ingress := .Spec.Service.Ingress }}
{{ if $ingress.Host }}
apiVersion: networking.k8s.io/v1
kind: Ingress
metadata:
  name: {{ .Name }}-ui
  namespace: {{ .Namespace }}
  labels:
    app: ui
    operator.skywalking.apache.org/ui-name: {{ .Name }}
    operator.skywalking.apache.org/application: ui
    operator.skywalking.apache.org/component: deployment
  annotations:
    {{- range $key, $value := $ingress.Annotations }}
    {{ $key }}: {{ $value | quote }}
    {{- end }}
spec:
  rules:
    - host: {{ $ingress.Host }}
      http:
        paths:
        - backend:
            service:
              name: {{ .Name }}-ui
              port:
                number: 80
          path: /
          pathType: Prefix
  {{- if $ingress.IngressClassName }}
  ingressClassName: {{ $ingress.IngressClassName }}
  {{end}}
  {{- if $ingress.TLS }}
  tls:
{{ toYAML $ingress.TLS | indent 4 }}
  {{end}}
{{end}}
`)

func uiTemplatesIngressYamlBytes() ([]byte, error) {
	return _uiTemplatesIngressYaml, nil
}

func uiTemplatesIngressYaml() (*asset, error) {
	bytes, err := uiTemplatesIngressYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "ui/templates/ingress.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xa7, 0x22, 0xaf, 0xa7, 0x77, 0x36, 0x3a, 0x57, 0x1c, 0x52, 0x67, 0x42, 0xa0, 0x4a, 0xcf, 0xf7, 0xe9, 0x91, 0x75, 0x45, 0xdf, 0xdc, 0xa3, 0x68, 0x5c, 0x79, 0xc0, 0xbe, 0xf8, 0xb1, 0x61, 0x5e}}
	return a, nil
}

var _uiTemplatesServiceYaml = []byte(`# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
{{- $svc := .Spec.Service.Template }}
apiVersion: v1
kind: Service
metadata:
  name: {{ .Name }}-ui
  namespace: {{ .Namespace }}
  labels:
    app: ui
    operator.skywalking.apache.org/ui-name: {{ .Name }}
    operator.skywalking.apache.org/application: ui
    operator.skywalking.apache.org/component: service
spec:
  type: {{ $svc.Type }}
  ports:
    - port: 80
      targetPort: 8080
      name: page
  {{- if $svc.ExternalIPs }}
  externalIPs:
    {{- range $value := $svc.ExternalIPs }}
    - {{ $value | quote }}
    {{- end }}
  {{- end }}
  {{- if $svc.LoadBalancerIP }}
  loadBalancerIP: {{ $svc.LoadBalancerIP }}
  {{- end }}
  {{- if $svc.LoadBalancerSourceRanges }}
  loadBalancerSourceRanges:
    {{- range $value := $svc.LoadBalancerSourceRanges }}
    - {{ $value | quote}}
    {{- end }}
  {{- end }}
  selector:
    app: ui
    operator.skywalking.apache.org/ui-name: {{ .Name }}
`)

func uiTemplatesServiceYamlBytes() ([]byte, error) {
	return _uiTemplatesServiceYaml, nil
}

func uiTemplatesServiceYaml() (*asset, error) {
	bytes, err := uiTemplatesServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "ui/templates/service.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x25, 0xdf, 0xf0, 0x9e, 0x39, 0xbe, 0x97, 0x7e, 0x89, 0xb8, 0xc7, 0xa8, 0xc7, 0x13, 0x20, 0x9c, 0x33, 0x24, 0xb7, 0xa7, 0x83, 0x42, 0xf3, 0xdc, 0xd6, 0x4a, 0x53, 0x16, 0x48, 0x83, 0x36, 0x9e}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"fetcher/templates/cluster_role.yaml":                  fetcherTemplatesCluster_roleYaml,
	"fetcher/templates/cluster_role_binding.yaml":          fetcherTemplatesCluster_role_bindingYaml,
	"fetcher/templates/configmap.yaml":                     fetcherTemplatesConfigmapYaml,
	"fetcher/templates/deployment.yaml":                    fetcherTemplatesDeploymentYaml,
	"fetcher/templates/service_account.yaml":               fetcherTemplatesService_accountYaml,
	"injector/templates/annotations.yaml":                  injectorTemplatesAnnotationsYaml,
	"injector/templates/configmap.yaml":                    injectorTemplatesConfigmapYaml,
	"injector/templates/javaagent.yaml":                    injectorTemplatesJavaagentYaml,
	"oapserver/templates/cluster_role.yaml":                oapserverTemplatesCluster_roleYaml,
	"oapserver/templates/cluster_role_binding.yaml":        oapserverTemplatesCluster_role_bindingYaml,
	"oapserver/templates/deployment.yaml":                  oapserverTemplatesDeploymentYaml,
	"oapserver/templates/ingress.yaml":                     oapserverTemplatesIngressYaml,
	"oapserver/templates/service.yaml":                     oapserverTemplatesServiceYaml,
	"oapserver/templates/service_account.yaml":             oapserverTemplatesService_accountYaml,
	"storage/elasticsearch/templates/configmap.yaml":       storageElasticsearchTemplatesConfigmapYaml,
	"storage/elasticsearch/templates/service.yaml":         storageElasticsearchTemplatesServiceYaml,
	"storage/elasticsearch/templates/service_account.yaml": storageElasticsearchTemplatesService_accountYaml,
	"storage/elasticsearch/templates/statefulset.yaml":     storageElasticsearchTemplatesStatefulsetYaml,
	"ui/templates/deployment.yaml":                         uiTemplatesDeploymentYaml,
	"ui/templates/ingress.yaml":                            uiTemplatesIngressYaml,
	"ui/templates/service.yaml":                            uiTemplatesServiceYaml,
}

// AssetDebug is true if the assets were built with the debug flag enabled.
const AssetDebug = false

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"fetcher": &bintree{nil, map[string]*bintree{
		"templates": &bintree{nil, map[string]*bintree{
			"cluster_role.yaml":         &bintree{fetcherTemplatesCluster_roleYaml, map[string]*bintree{}},
			"cluster_role_binding.yaml": &bintree{fetcherTemplatesCluster_role_bindingYaml, map[string]*bintree{}},
			"configmap.yaml":            &bintree{fetcherTemplatesConfigmapYaml, map[string]*bintree{}},
			"deployment.yaml":           &bintree{fetcherTemplatesDeploymentYaml, map[string]*bintree{}},
			"service_account.yaml":      &bintree{fetcherTemplatesService_accountYaml, map[string]*bintree{}},
		}},
	}},
	"injector": &bintree{nil, map[string]*bintree{
		"templates": &bintree{nil, map[string]*bintree{
			"annotations.yaml": &bintree{injectorTemplatesAnnotationsYaml, map[string]*bintree{}},
			"configmap.yaml":   &bintree{injectorTemplatesConfigmapYaml, map[string]*bintree{}},
			"javaagent.yaml":   &bintree{injectorTemplatesJavaagentYaml, map[string]*bintree{}},
		}},
	}},
	"oapserver": &bintree{nil, map[string]*bintree{
		"templates": &bintree{nil, map[string]*bintree{
			"cluster_role.yaml":         &bintree{oapserverTemplatesCluster_roleYaml, map[string]*bintree{}},
			"cluster_role_binding.yaml": &bintree{oapserverTemplatesCluster_role_bindingYaml, map[string]*bintree{}},
			"deployment.yaml":           &bintree{oapserverTemplatesDeploymentYaml, map[string]*bintree{}},
			"ingress.yaml":              &bintree{oapserverTemplatesIngressYaml, map[string]*bintree{}},
			"service.yaml":              &bintree{oapserverTemplatesServiceYaml, map[string]*bintree{}},
			"service_account.yaml":      &bintree{oapserverTemplatesService_accountYaml, map[string]*bintree{}},
		}},
	}},
	"storage": &bintree{nil, map[string]*bintree{
		"elasticsearch": &bintree{nil, map[string]*bintree{
			"templates": &bintree{nil, map[string]*bintree{
				"configmap.yaml":       &bintree{storageElasticsearchTemplatesConfigmapYaml, map[string]*bintree{}},
				"service.yaml":         &bintree{storageElasticsearchTemplatesServiceYaml, map[string]*bintree{}},
				"service_account.yaml": &bintree{storageElasticsearchTemplatesService_accountYaml, map[string]*bintree{}},
				"statefulset.yaml":     &bintree{storageElasticsearchTemplatesStatefulsetYaml, map[string]*bintree{}},
			}},
		}},
	}},
	"ui": &bintree{nil, map[string]*bintree{
		"templates": &bintree{nil, map[string]*bintree{
			"deployment.yaml": &bintree{uiTemplatesDeploymentYaml, map[string]*bintree{}},
			"ingress.yaml":    &bintree{uiTemplatesIngressYaml, map[string]*bintree{}},
			"service.yaml":    &bintree{uiTemplatesServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
