# Fetcher/prometheus-metrics-fetcher
## Description
This is a fetcher for Skywalking prometheus metrics format, which will translate Prometheus metrics to Skywalking meter system.
## Support Forwarders
 - [native-meter-grpc-forwarder](forwarder_native-meter-grpc-forwarder.md)
## DefaultConfig
```yaml
# scrape_configs is the scrape configuration of prometheus 
# which is fully compatible with prometheus scrap.
scrape_configs:
# job_name will be used as the label in prometheus, 
# and in skywalking meterdata will be used as the service name.
# Set the scrape interval through scrape_interval
# static_configs is the service list of metrics server
- job_name: 'prometheus'
  metrics_path: '/metrics'
  scrape_interval: 10s
  static_configs:
    - targets:
      - "127.0.0.1:9100"
# In K8S, service discovery needs to be used to obtain the metrics server list.
# Configure and select related pods through kubernetes_sd_configs.selectors
# Because K8S resource permissions are involved, K8S serviceaccount needs to be configured
# tls_config is the certificate assigned by K8S to satellite, and generally does not need to be changed.
- job_name: 'prometheus-k8s'
  metrics_path: '/metrics'
  scrape_interval: 10s
  tls_config:
    ca_file: /var/run/secrets/kubernetes.io/serviceaccount/ca.crt
  bearer_token_file: /var/run/secrets/kubernetes.io/serviceaccount/token
  kubernetes_sd_configs:
  - role: pod
    selectors:
    - role: pod
      label: "app=prometheus"
```
## Configuration
|Name|Type|Description|
|----|----|-----------|
| scrape_configs | []*prometheus.scrapeConfig | config is the top level configuratScrapeConfigsMapion of prometheus |

