/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.so11y;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.agent.core.meter.Counter;
import org.apache.skywalking.apm.agent.core.meter.Histogram;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;

public class AgentSo11y {
    private static final Map<String, Counter> ERROR_COUNTER_CACHE = new ConcurrentHashMap<String, Counter>();
    private static final List<Double> TIME_COST_HISTOGRAM_STEPS = Arrays.asList(1000.0, 10000.0, 50000.0, 100000.0, 300000.0, 500000.0, 1000000.0, 5000000.0, 1.0E7, 2.0E7, 5.0E7, 1.0E8);
    private static Counter PROPAGATED_CONTEXT_COUNTER;
    private static Counter SAMPLER_CONTEXT_COUNTER;
    private static Counter FINISH_CONTEXT_COUNTER;
    private static Counter PROPAGATED_IGNORE_CONTEXT_COUNTER;
    private static Counter SAMPLER_IGNORE_CONTEXT_COUNTER;
    private static Counter FINISH_IGNORE_CONTEXT_COUNTER;
    private static Counter LEAKED_CONTEXT_COUNTER;
    private static Counter LEAKED_IGNORE_CONTEXT_COUNTER;
    private static Histogram INTERCEPTOR_TIME_COST;

    public static void measureTracingContextCreation(boolean forceSampling, boolean ignoredTracingContext) {
        if (forceSampling) {
            if (ignoredTracingContext) {
                if (PROPAGATED_IGNORE_CONTEXT_COUNTER == null) {
                    PROPAGATED_IGNORE_CONTEXT_COUNTER = (Counter)((Counter.Builder)MeterFactory.counter("created_ignored_context_counter").tag("created_by", "propagated")).build();
                }
                PROPAGATED_IGNORE_CONTEXT_COUNTER.increment(1.0);
            } else {
                if (PROPAGATED_CONTEXT_COUNTER == null) {
                    PROPAGATED_CONTEXT_COUNTER = (Counter)((Counter.Builder)MeterFactory.counter("created_tracing_context_counter").tag("created_by", "propagated")).build();
                }
                PROPAGATED_CONTEXT_COUNTER.increment(1.0);
            }
        } else if (ignoredTracingContext) {
            if (SAMPLER_IGNORE_CONTEXT_COUNTER == null) {
                SAMPLER_IGNORE_CONTEXT_COUNTER = (Counter)((Counter.Builder)MeterFactory.counter("created_ignored_context_counter").tag("created_by", "sampler")).build();
            }
            SAMPLER_IGNORE_CONTEXT_COUNTER.increment(1.0);
        } else {
            if (SAMPLER_CONTEXT_COUNTER == null) {
                SAMPLER_CONTEXT_COUNTER = (Counter)((Counter.Builder)MeterFactory.counter("created_tracing_context_counter").tag("created_by", "sampler")).build();
            }
            SAMPLER_CONTEXT_COUNTER.increment(1.0);
        }
    }

    public static void measureTracingContextCompletion(boolean ignoredTracingContext) {
        if (ignoredTracingContext) {
            if (FINISH_IGNORE_CONTEXT_COUNTER == null) {
                FINISH_IGNORE_CONTEXT_COUNTER = (Counter)MeterFactory.counter("finished_ignored_context_counter").build();
            }
            FINISH_IGNORE_CONTEXT_COUNTER.increment(1.0);
        } else {
            if (FINISH_CONTEXT_COUNTER == null) {
                FINISH_CONTEXT_COUNTER = (Counter)MeterFactory.counter("finished_tracing_context_counter").build();
            }
            FINISH_CONTEXT_COUNTER.increment(1.0);
        }
    }

    public static void measureLeakedTracingContext(boolean ignoredTracingContext) {
        if (ignoredTracingContext) {
            if (LEAKED_IGNORE_CONTEXT_COUNTER == null) {
                LEAKED_IGNORE_CONTEXT_COUNTER = (Counter)((Counter.Builder)MeterFactory.counter("possible_leaked_context_counter").tag("source", "ignore")).build();
            }
            LEAKED_IGNORE_CONTEXT_COUNTER.increment(1.0);
        } else {
            if (LEAKED_CONTEXT_COUNTER == null) {
                LEAKED_CONTEXT_COUNTER = (Counter)((Counter.Builder)MeterFactory.counter("possible_leaked_context_counter").tag("source", "tracing")).build();
            }
            LEAKED_CONTEXT_COUNTER.increment(1.0);
        }
    }

    public static void durationOfInterceptor(double timeCostInNanos) {
        if (INTERCEPTOR_TIME_COST == null) {
            INTERCEPTOR_TIME_COST = (Histogram)MeterFactory.histogram("tracing_context_performance").steps(TIME_COST_HISTOGRAM_STEPS).build();
        }
        INTERCEPTOR_TIME_COST.addValue(timeCostInNanos);
    }

    public static void errorOfPlugin(String pluginName, String interType) {
        Counter counter = ERROR_COUNTER_CACHE.computeIfAbsent(pluginName + interType, key -> (Counter)((Counter.Builder)((Counter.Builder)MeterFactory.counter("interceptor_error_counter").tag("plugin_name", pluginName)).tag("inter_type", interType)).build());
        counter.increment(1.0);
    }
}

