/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.profile;

import java.util.List;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadSnapshot;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadStack;

public class TracingThreadSnapshot {
    private final String taskId;
    private final String traceSegmentId;
    private final int sequence;
    private final long time;
    private final List<String> stackList;

    public TracingThreadSnapshot(String taskId, String traceSegmentId, int sequence, long time, List<String> stackList) {
        this.taskId = taskId;
        this.traceSegmentId = traceSegmentId;
        this.sequence = sequence;
        this.time = time;
        this.stackList = stackList;
    }

    public ThreadSnapshot transform() {
        ThreadSnapshot.Builder builder = ThreadSnapshot.newBuilder();
        builder.setTaskId(this.taskId);
        builder.setTraceSegmentId(this.traceSegmentId);
        builder.setTime(this.time);
        builder.setSequence(this.sequence);
        ThreadStack.Builder stackBuilder = ThreadStack.newBuilder();
        for (String codeSign : this.stackList) {
            stackBuilder.addCodeSignatures(codeSign);
        }
        builder.setStack(stackBuilder);
        return builder.build();
    }
}

