# Table of Agent Configuration Properties

This is the properties list supported in `agent/config/agent.config`.

| property key                                                    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | **System Environment Variable**                                  | Default                                                                                                                                                                                                                                                                                                                                                                                                                                              |
|-----------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `agent.service_name`                                            | The service name to represent a logic group providing the same capabilities/logic. Suggestion: set a unique name for every logic service group, service instance nodes share the same code, Max length is 50(UTF-8 char). Optional, once `service_name` follows `<group name>::<logic name>` format, OAP server assigns the group name to the service metadata.                                                                                                                                                                                        | SW_AGENT_NAME                                                    | `Your_ApplicationName`                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `agent.namespace`                                               | Namespace represents a subnet, such as kubernetes namespace, or 172.10.*.*                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | SW_AGENT_NAMESPACE                                               | Not set                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.cluster`                                                 | Cluster defines the physical cluster in a data center or same network segment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_AGENT_CLUSTER                                                 | Not set                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.sample_n_per_3_secs`                                     | Negative or zero means off, by default.SAMPLE_N_PER_3_SECS means sampling N TraceSegment in 3 seconds tops.                                                                                                                                                                                                                                                                                                                                                                                                                                            | SW_AGENT_SAMPLE                                                  | Not set                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.authentication`                                          | Authentication active is based on backend setting, see application.yml for more details.For most scenarios, this needs backend extensions, only basic match auth provided in default implementation.                                                                                                                                                                                                                                                                                                                                                   | SW_AGENT_AUTHENTICATION                                          | Not set                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.trace_segment_ref_limit_per_span`                        | The max number of TraceSegmentRef in a single span to keep memory cost estimatable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | SW_TRACE_SEGMENT_LIMIT                                           | 500                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `agent.span_limit_per_segment`                                  | The max number of spans in a single segment. Through this config item, SkyWalking keep your application memory cost estimated.                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_AGENT_SPAN_LIMIT                                              | 300                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `agent.ignore_suffix`                                           | If the operation name of the first span is included in this set, this segment should be ignored.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | SW_AGENT_IGNORE_SUFFIX                                           | Not set                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.is_open_debugging_class`                                 | If true, skywalking agent will save all instrumented classes files in `/debugging` folder. SkyWalking team may ask for these files in order to resolve compatible problem.                                                                                                                                                                                                                                                                                                                                                                             | SW_AGENT_OPEN_DEBUG                                              | Not set                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.instance_name`                                           | Instance name is the identity of an instance, should be unique in the service. If empty, SkyWalking agent will generate an 32-bit uuid. Default, use `UUID`@`hostname` as the instance name. Max length is 50(UTF-8 char)                                                                                                                                                                                                                                                                                                                              | SW_AGENT_INSTANCE_NAME                                           | `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `agent.instance_properties_json={"key":"value"}`                | Add service instance custom properties in json format.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | SW_INSTANCE_PROPERTIES_JSON                                      | Not set                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.cause_exception_depth`                                   | How depth the agent goes, when log all cause exceptions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | SW_AGENT_CAUSE_EXCEPTION_DEPTH                                   | `5`                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `agent.force_reconnection_period `                              | Force reconnection period of grpc, based on grpc_channel_check_interval.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | SW_AGENT_FORCE_RECONNECTION_PERIOD                               | `1`                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `agent.operation_name_threshold `                               | The operationName max length, setting this value > 190 is not recommended.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | SW_AGENT_OPERATION_NAME_THRESHOLD                                | `150`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `agent.keep_tracing`                                            | Keep tracing even the backend is not available if this value is `true`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | SW_AGENT_KEEP_TRACING                                            | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.force_tls`                                               | Force open TLS for gRPC channel if this value is `true`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | SW_AGENT_FORCE_TLS                                               | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.ssl_trusted_ca_path`                                     | gRPC SSL trusted ca file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | SW_AGENT_SSL_TRUSTED_CA_PATH                                     | `/ca/ca.crt`                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `agent.ssl_key_path`                                            | The private key file. Enable mTLS when ssl_key_path and ssl_cert_chain_path exist.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | SW_AGENT_SSL_KEY_PATH                                            | `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `agent.ssl_cert_chain_path`                                     | The certificate file. Enable mTLS when ssl_key_path and ssl_cert_chain_path exist.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | SW_AGENT_SSL_CERT_CHAIN_PATH                                     | `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `agent.enable`                                                  | Enable the agent kernel services and instrumentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | SW_AGENT_ENABLE                                                  | `true`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `osinfo.ipv4_list_size`                                         | Limit the length of the ipv4 list size.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | SW_AGENT_OSINFO_IPV4_LIST_SIZE                                   | `10`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `collector.grpc_channel_check_interval`                         | grpc channel status check interval.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | SW_AGENT_COLLECTOR_GRPC_CHANNEL_CHECK_INTERVAL                   | `30`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `collector.heartbeat_period`                                    | agent heartbeat report period. Unit, second.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | SW_AGENT_COLLECTOR_HEARTBEAT_PERIOD                              | `30`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `collector.properties_report_period_factor`                     | The agent sends the instance properties to the backend every `collector.heartbeat_period * collector.properties_report_period_factor` seconds                                                                                                                                                                                                                                                                                                                                                                                                          | SW_AGENT_COLLECTOR_PROPERTIES_REPORT_PERIOD_FACTOR               | `10`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `collector.backend_service`                                     | Collector SkyWalking trace receiver service addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | SW_AGENT_COLLECTOR_BACKEND_SERVICES                              | `127.0.0.1:11800`                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `collector.grpc_upstream_timeout`                               | How long grpc client will timeout in sending data to upstream. Unit is second.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_AGENT_COLLECTOR_GRPC_UPSTREAM_TIMEOUT                         | `30` seconds                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `collector.get_profile_task_interval`                           | Sniffer get profile task list interval.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | SW_AGENT_COLLECTOR_GET_PROFILE_TASK_INTERVAL                     | `20`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `collector.get_agent_dynamic_config_interval`                   | Sniffer get agent dynamic config interval                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | SW_AGENT_COLLECTOR_GET_AGENT_DYNAMIC_CONFIG_INTERVAL             | `20`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `collector.is_resolve_dns_periodically`                         | If true, skywalking agent will enable periodically resolving DNS to update receiver service addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | SW_AGENT_COLLECTOR_IS_RESOLVE_DNS_PERIODICALLY                   | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `logging.level`                                                 | Log level: TRACE, DEBUG, INFO, WARN, ERROR, OFF. Default is info.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | SW_LOGGING_LEVEL                                                 | `INFO`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `logging.file_name`                                             | Log file name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_LOGGING_FILE_NAME                                             | `skywalking-api.log`                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `logging.output`                                                | Log output. Default is FILE. Use CONSOLE means output to stdout.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | SW_LOGGING_OUTPUT                                                | `FILE`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `logging.dir`                                                   | Log files directory. Default is blank string, means, use "{theSkywalkingAgentJarDir}/logs  " to output logs. {theSkywalkingAgentJarDir} is the directory where the skywalking agent jar file is located                                                                                                                                                                                                                                                                                                                                                | SW_LOGGING_DIR                                                   | `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `logging.resolver`                                              | Logger resolver: `PATTERN` or `JSON`. The default is `PATTERN`, which uses `logging.pattern` to print traditional text logs. `JSON` resolver prints logs in JSON format.                                                                                                                                                                                                                                                                                                                                                                               | SW_LOGGING_RESOLVER                                              | `PATTERN`                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `logging.pattern `                                              | Logging format. There are all conversion specifiers: <br>&nbsp;&nbsp;* `%level` means log level. <br>&nbsp;&nbsp;*  `%timestamp` means now of time with format `yyyy-MM-dd HH:mm:ss:SSS`.<br>&nbsp;&nbsp;*   `%thread` means name of current thread.<br>&nbsp;&nbsp;*   `%msg` means some message which user logged. <br>&nbsp;&nbsp;*  `%class` means SimpleName of TargetClass. <br>&nbsp;&nbsp;*  `%throwable` means a throwable which user called. <br>&nbsp;&nbsp;*  `%agent_name` means `agent.service_name`. Only apply to the `PatternLogger`. | SW_LOGGING_PATTERN                                               | `%level %timestamp %thread %class : %msg %throwable`                                                                                                                                                                                                                                                                                                                                                                                                 |
| `logging.max_file_size`                                         | The max size of log file. If the size is bigger than this, archive the current file, and write into a new file.                                                                                                                                                                                                                                                                                                                                                                                                                                        | SW_LOGGING_MAX_FILE_SIZE                                         | `300 * 1024 * 1024`                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `logging.max_history_files`                                     | The max history log files. When rollover happened, if log files exceed this number,then the oldest file will be delete. Negative or zero means off, by default.                                                                                                                                                                                                                                                                                                                                                                                        | SW_LOGGING_MAX_HISTORY_FILES                                     | `-1`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `statuscheck.ignored_exceptions`                                | Listed exceptions would not be treated as an error. Because in some codes, the exception is being used as a way of controlling business flow.                                                                                                                                                                                                                                                                                                                                                                                                          | SW_STATUSCHECK_IGNORED_EXCEPTIONS                                | `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `statuscheck.max_recursive_depth`                               | The max recursive depth when checking the exception traced by the agent. Typically, we don't recommend setting this more than 10, which could cause a performance issue. Negative value and 0 would be ignored, which means all exceptions would make the span tagged in error status.                                                                                                                                                                                                                                                                 | SW_STATUSCHECK_MAX_RECURSIVE_DEPTH                               | `1`                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `correlation.element_max_number`                                | Max element count in the correlation context.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | SW_CORRELATION_ELEMENT_MAX_NUMBER                                | 3                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `correlation.value_max_length`                                  | Max value length of each element.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | SW_CORRELATION_VALUE_MAX_LENGTH                                  | `128`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `correlation.auto_tag_keys`                                     | Tag the span by the key/value in the correlation context, when the keys listed here exist.                                                                                                                                                                                                                                                                                                                                                                                                                                                             | SW_CORRELATION_AUTO_TAG_KEYS                                     | `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `jvm.buffer_size`                                               | The buffer size of collected JVM info.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | SW_JVM_BUFFER_SIZE                                               | `60 * 10`                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `jvm.metrics_collect_period`                                    | The period in seconds of JVM metrics collection.  Unit is second.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | SW_JVM_METRICS_COLLECT_PERIOD                                    | `1`                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `buffer.channel_size`                                           | The buffer channel size.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | SW_BUFFER_CHANNEL_SIZE                                           | `5`                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `buffer.buffer_size`                                            | The buffer size.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | SW_BUFFER_BUFFER_SIZE                                            | `300`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `profile.active`                                                | If true, skywalking agent will enable profile when user create a new profile task. Otherwise disable profile.                                                                                                                                                                                                                                                                                                                                                                                                                                          | SW_AGENT_PROFILE_ACTIVE                                          | `true`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `profile.max_parallel`                                          | Parallel monitor segment count                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_AGENT_PROFILE_MAX_PARALLEL                                    | `5`                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `profile.max_accept_sub_parallel`                               | Max monitoring sub-tasks count of one single endpoint access                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | SW_AGENT_PROFILE_MAX_ACCEPT_SUB_PARALLEL                         | `5`                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `profile.duration`                                              | Max monitor segment time(minutes), if current segment monitor time out of limit, then stop it.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_AGENT_PROFILE_DURATION                                        | `10`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `profile.dump_max_stack_depth`                                  | Max dump thread stack depth                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | SW_AGENT_PROFILE_DUMP_MAX_STACK_DEPTH                            | `500`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `profile.snapshot_transport_buffer_size`                        | Snapshot transport to backend buffer size                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | SW_AGENT_PROFILE_SNAPSHOT_TRANSPORT_BUFFER_SIZE                  | `4500`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `meter.active`                                                  | If true, the agent collects and reports metrics to the backend.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | SW_METER_ACTIVE                                                  | `true`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `meter.report_interval`                                         | Report meters interval. The unit is second                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | SW_METER_REPORT_INTERVAL                                         | `20`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `meter.max_meter_size`                                          | Max size of the meter pool                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | SW_METER_MAX_METER_SIZE                                          | `500`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `log.max_message_size`                                          | The max size of message to send to server.Default is 10 MB.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | SW_GRPC_LOG_MAX_MESSAGE_SIZE                                     | `10485760`                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `plugin.mount`                                                  | Mount the specific folders of the plugins. Plugins in mounted folders would work.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | SW_MOUNT_FOLDERS                                                 | `plugins,activations`                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.peer_max_length `                                       | Peer maximum description limit.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | SW_PLUGIN_PEER_MAX_LENGTH                                        | `200`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.exclude_plugins `                                       | Exclude some plugins define in plugins dir,Multiple plugins are separated by comma.Plugin names is defined in [Agent plugin list](Plugin-list.md)                                                                                                                                                                                                                                                                                                                                                                                                      | SW_EXCLUDE_PLUGINS                                               | `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `plugin.mongodb.trace_param`                                    | If true, trace all the parameters in MongoDB access, default is false. Only trace the operation, not include parameters.                                                                                                                                                                                                                                                                                                                                                                                                                               | SW_PLUGIN_MONGODB_TRACE_PARAM                                    | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.mongodb.filter_length_limit`                            | If set to positive number, the `WriteRequest.params` would be truncated to this length, otherwise it would be completely saved, which may cause performance problem.                                                                                                                                                                                                                                                                                                                                                                                   | SW_PLUGIN_MONGODB_FILTER_LENGTH_LIMIT                            | `256`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.elasticsearch.trace_dsl`                                | If true, trace all the DSL(Domain Specific Language) in ElasticSearch access, default is false.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | SW_PLUGIN_ELASTICSEARCH_TRACE_DSL                                | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.springmvc.use_qualified_name_as_endpoint_name`          | If true, the fully qualified method name will be used as the endpoint name instead of the request URL, default is false.                                                                                                                                                                                                                                                                                                                                                                                                                               | SW_PLUGIN_SPRINGMVC_USE_QUALIFIED_NAME_AS_ENDPOINT_NAME          | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.toolkit.use_qualified_name_as_operation_name`           | If true, the fully qualified method name will be used as the operation name instead of the given operation name, default is false.                                                                                                                                                                                                                                                                                                                                                                                                                     | SW_PLUGIN_TOOLKIT_USE_QUALIFIED_NAME_AS_OPERATION_NAME           | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.jdbc.trace_sql_parameters`                              | If set to true, the parameters of the sql (typically `java.sql.PreparedStatement`) would be collected.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | SW_JDBC_TRACE_SQL_PARAMETERS                                     | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.jdbc.sql_parameters_max_length`                         | If set to positive number, the `db.sql.parameters` would be truncated to this length, otherwise it would be completely saved, which may cause performance problem.                                                                                                                                                                                                                                                                                                                                                                                     | SW_PLUGIN_JDBC_SQL_PARAMETERS_MAX_LENGTH                         | `512`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.jdbc.sql_body_max_length`                               | If set to positive number, the `db.statement` would be truncated to this length, otherwise it would be completely saved, which may cause performance problem.                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_JDBC_SQL_BODY_MAX_LENGTH                               | `2048`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.solrj.trace_statement`                                  | If true, trace all the query parameters(include deleteByIds and deleteByQuery) in Solr query request, default is false.                                                                                                                                                                                                                                                                                                                                                                                                                                | SW_PLUGIN_SOLRJ_TRACE_STATEMENT                                  | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.solrj.trace_ops_params`                                 | If true, trace all the operation parameters in Solr request, default is false.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_SOLRJ_TRACE_OPS_PARAMS                                 | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.light4j.trace_handler_chain`                            | If true, trace all middleware/business handlers that are part of the Light4J handler chain for a request.                                                                                                                                                                                                                                                                                                                                                                                                                                              | SW_PLUGIN_LIGHT4J_TRACE_HANDLER_CHAIN                            | false                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.springtransaction.simplify_transaction_definition_name` | If true, the transaction definition name will be simplified.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | SW_PLUGIN_SPRINGTRANSACTION_SIMPLIFY_TRANSACTION_DEFINITION_NAME | false                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.jdkthreading.threading_class_prefixes`                  | Threading classes (`java.lang.Runnable` and `java.util.concurrent.Callable`) and their subclasses, including anonymous inner classes whose name match any one of the `THREADING_CLASS_PREFIXES` (splitted by `,`) will be instrumented, make sure to only specify as narrow prefixes as what you're expecting to instrument, (`java.` and `javax.` will be ignored due to safety issues)                                                                                                                                                               | SW_PLUGIN_JDKTHREADING_THREADING_CLASS_PREFIXES                  | Not set                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.tomcat.collect_http_params`                             | This config item controls that whether the Tomcat plugin should collect the parameters of the request. Also, activate implicitly in the profiled trace.                                                                                                                                                                                                                                                                                                                                                                                                | SW_PLUGIN_TOMCAT_COLLECT_HTTP_PARAMS                             | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.springmvc.collect_http_params`                          | This config item controls that whether the SpringMVC plugin should collect the parameters of the request, when your Spring application is based on Tomcat, consider only setting either `plugin.tomcat.collect_http_params` or `plugin.springmvc.collect_http_params`. Also, activate implicitly in the profiled trace.                                                                                                                                                                                                                                | SW_PLUGIN_SPRINGMVC_COLLECT_HTTP_PARAMS                          | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.httpclient.collect_http_params`                         | This config item controls that whether the HttpClient plugin should collect the parameters of the request                                                                                                                                                                                                                                                                                                                                                                                                                                              | SW_PLUGIN_HTTPCLIENT_COLLECT_HTTP_PARAMS                         | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.http.http_params_length_threshold`                      | When `COLLECT_HTTP_PARAMS` is enabled, how many characters to keep and send to the OAP backend, use negative values to keep and send the complete parameters, NB. this config item is added for the sake of performance.                                                                                                                                                                                                                                                                                                                               | SW_PLUGIN_HTTP_HTTP_PARAMS_LENGTH_THRESHOLD                      | `1024`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.http.http_headers_length_threshold`                     | When `include_http_headers` declares header names, this threshold controls the length limitation of all header values. use negative values to keep and send the complete headers. Note. this config item is added for the sake of performance.                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_HTTP_HTTP_HEADERS_LENGTH_THRESHOLD                     | `2048`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.http.include_http_headers`                              | Set the header names, which should be collected by the plugin. Header name must follow `javax.servlet.http` definition. Multiple names should be split by comma.                                                                                                                                                                                                                                                                                                                                                                                       | SW_PLUGIN_HTTP_INCLUDE_HTTP_HEADERS                              | ``(No header would be collected)                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `plugin.feign.collect_request_body`                             | This config item controls that whether the Feign plugin should collect the http body of the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | SW_PLUGIN_FEIGN_COLLECT_REQUEST_BODY                             | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.feign.filter_length_limit`                              | When `COLLECT_REQUEST_BODY` is enabled, how many characters to keep and send to the OAP backend, use negative values to keep and send the complete body.                                                                                                                                                                                                                                                                                                                                                                                               | SW_PLUGIN_FEIGN_FILTER_LENGTH_LIMIT                              | `1024`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.feign.supported_content_types_prefix`                   | When `COLLECT_REQUEST_BODY` is enabled and content-type start with SUPPORTED_CONTENT_TYPES_PREFIX, collect the body of the request , multiple paths should be separated by `,`                                                                                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_FEIGN_SUPPORTED_CONTENT_TYPES_PREFIX                   | `application/json,text/`                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `plugin.influxdb.trace_influxql`                                | If true, trace all the influxql(query and write) in InfluxDB access, default is true.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | SW_PLUGIN_INFLUXDB_TRACE_INFLUXQL                                | `true`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.dubbo.collect_consumer_arguments`                       | Apache Dubbo consumer collect `arguments` in RPC call, use `Object#toString` to collect `arguments`.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | SW_PLUGIN_DUBBO_COLLECT_CONSUMER_ARGUMENTS                       | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.dubbo.consumer_arguments_length_threshold`              | When `plugin.dubbo.collect_consumer_arguments` is `true`, Arguments of length from the front will to the OAP backend                                                                                                                                                                                                                                                                                                                                                                                                                                   | SW_PLUGIN_DUBBO_CONSUMER_ARGUMENTS_LENGTH_THRESHOLD              | `256`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.dubbo.collect_provider_arguments`                       | Apache Dubbo provider collect `arguments` in RPC call, use `Object#toString` to collect `arguments`.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | SW_PLUGIN_DUBBO_COLLECT_PROVIDER_ARGUMENTS                       | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.dubbo.provider_arguments_length_threshold`              | When `plugin.dubbo.collect_provider_arguments` is `true`, Arguments of length from the front will to the OAP backend                                                                                                                                                                                                                                                                                                                                                                                                                                   | SW_PLUGIN_DUBBO_PROVIDER_ARGUMENTS_LENGTH_THRESHOLD              | `256`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.kafka.bootstrap_servers`                                | A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_KAFKA_BOOTSTRAP_SERVERS                                       | `localhost:9092`                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `plugin.kafka.get_topic_timeout`                                | Timeout period of reading topics from the Kafka server, the unit is second.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | SW_GET_TOPIC_TIMEOUT                                             | `10`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `plugin.kafka.producer_config`                                  | Kafka producer configuration. Read [producer configure](http://kafka.apache.org/24/documentation.html#producerconfigs) to get more details. Check [Kafka report doc](advanced-reporters.md#kafka-reporter) for more details and examples.                                                                                                                                                                                                                                                                                                              | SW_PLUGIN_KAFKA_PRODUCER_CONFIG                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `plugin.kafka.producer_config_json`                             | Configure Kafka Producer configuration in JSON format. Notice it will be overridden by `plugin.kafka.producer_config[key]`, if the key duplication.                                                                                                                                                                                                                                                                                                                                                                                                    | SW_PLUGIN_KAFKA_PRODUCER_CONFIG_JSON                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `plugin.kafka.topic_meter`                                      | Specify which Kafka topic name for Meter System data to report to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | SW_PLUGIN_KAFKA_TOPIC_METER                                      | `skywalking-meters`                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `plugin.kafka.topic_metrics`                                    | Specify which Kafka topic name for JVM metrics data to report to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | SW_PLUGIN_KAFKA_TOPIC_METRICS                                    | `skywalking-metrics`                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `plugin.kafka.topic_segment`                                    | Specify which Kafka topic name for traces data to report to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | SW_PLUGIN_KAFKA_TOPIC_SEGMENT                                    | `skywalking-segments`                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.kafka.topic_profiling`                                  | Specify which Kafka topic name for Thread Profiling snapshot to report to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | SW_PLUGIN_KAFKA_TOPIC_PROFILINGS                                 | `skywalking-profilings`                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.kafka.topic_management`                                 | Specify which Kafka topic name for the register or heartbeat data of Service Instance to report to.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | SW_PLUGIN_KAFKA_TOPIC_MANAGEMENT                                 | `skywalking-managements`                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `plugin.kafka.topic_logging`                                    | Specify which Kafka topic name for the logging data to report to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | SW_PLUGIN_KAFKA_TOPIC_LOGGING                                    | `skywalking-logging`                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `plugin.kafka.namespace`                                        | isolate multi OAP server when using same Kafka cluster (final topic name will append namespace before Kafka topics with `-` ).                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_KAFKA_NAMESPACE                                               | ``                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `plugin.kafka.decode_class`                                     | Specify which class to decode encoded configuration of kafka.You can set encoded information in `plugin.kafka.producer_config_json` or `plugin.kafka.producer_config` if you need.                                                                                                                                                                                                                                                                                                                                                                     | SW_KAFKA_DECODE_CLASS                                            | ``                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `plugin.springannotation.classname_match_regex`                 | Match spring beans with regular expression for the class name. Multiple expressions could be separated by a comma. This only works when `Spring annotation plugin` has been activated.                                                                                                                                                                                                                                                                                                                                                                 | SW_SPRINGANNOTATION_CLASSNAME_MATCH_REGEX                        | `All the spring beans tagged with @Bean,@Service,@Dao, or @Repository.`                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.toolkit.log.transmit_formatted`                         | Whether or not to transmit logged data as formatted or un-formatted.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | SW_PLUGIN_TOOLKIT_LOG_TRANSMIT_FORMATTED                         | `true`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.lettuce.trace_redis_parameters`                         | If set to true, the parameters of Redis commands would be collected by Lettuce agent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | SW_PLUGIN_LETTUCE_TRACE_REDIS_PARAMETERS                         | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.lettuce.redis_parameter_max_length`                     | If set to positive number and `plugin.lettuce.trace_redis_parameters` is set to `true`, Redis command parameters would be collected and truncated to this length.                                                                                                                                                                                                                                                                                                                                                                                      | SW_PLUGIN_LETTUCE_REDIS_PARAMETER_MAX_LENGTH                     | `128`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.lettuce.operation_mapping_write`                        | Specify which command should be converted to `write` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_LETTUCE_OPERATION_MAPPING_WRITE                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `plugin.lettuce.operation_mapping_read  `                       | Specify which command should be converted to `read` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_LETTUCE_OPERATION_MAPPING_READ                         | Referenc [Lettuce-5.x-plugin](https://github.com/apache/skywalking-java/blob/main/apm-sniffer/apm-sdk-plugin/lettuce-5.x-plugin/src/main/java/org/apache/skywalking/apm/plugin/lettuce/v5/LettucePluginConfig.java)                                                                                                                                                                                                                                  |
| `plugin.jedis.trace_redis_parameters`                           | If set to true, the parameters of Redis commands would be collected by Jedis agent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | SW_PLUGIN_JEDIS_TRACE_REDIS_PARAMETERS                           | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.jedis.redis_parameter_max_length`                       | If set to positive number and `plugin.jedis.trace_redis_parameters` is set to `true`, Redis command parameters would be collected and truncated to this length.                                                                                                                                                                                                                                                                                                                                                                                        | SW_PLUGIN_JEDIS_REDIS_PARAMETER_MAX_LENGTH                       | `128`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.jedis.operation_mapping_write`                          | Specify which command should be converted to `write` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_JEDIS_OPERATION_MAPPING_WRITE                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `plugin.jedis.operation_mapping_read  `                         | Specify which command should be converted to `read` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_JEDIS_OPERATION_MAPPING_READ                           | Referenc [Jedis-4.x-plugin](https://github.com/apache/skywalking-java/blob/main/apm-sniffer/apm-sdk-plugin/jedis-plugins/jedis-4.x-plugin/src/main/java/org/apache/skywalking/apm/plugin/jedis/v4/JedisPluginConfig.java)   [jedis-2.x-3.x-plugin](https://github.com/apache/skywalking-java/blob/main/apm-sniffer/apm-sdk-plugin/jedis-plugins/jedis-2.x-3.x-plugin/src/main/java/org/apache/skywalking/apm/plugin/jedis/v3/JedisPluginConfig.java) |
| `plugin.redisson.trace_redis_parameters`                        | If set to true, the parameters of Redis commands would be collected by Redisson agent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | SW_PLUGIN_REDISSON_TRACE_REDIS_PARAMETERS                        | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.redisson.redis_parameter_max_length`                    | If set to positive number and `plugin.redisson.trace_redis_parameters` is set to `true`, Redis command parameters would be collected and truncated to this length.                                                                                                                                                                                                                                                                                                                                                                                     | SW_PLUGIN_REDISSON_REDIS_PARAMETER_MAX_LENGTH                    | `128`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.redisson.operation_mapping_write`                       | Specify which command should be converted to `write` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_REDISSON_OPERATION_MAPPING_WRITE                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `plugin.redisson.operation_mapping_read  `                      | Specify which command should be converted to `read` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_REDISSON_OPERATION_MAPPING_READ                        | Referenc [Redisson-3.x-plugin](https://github.com/apache/skywalking-java/blob/main/apm-sniffer/apm-sdk-plugin/redisson-3.x-plugin/src/main/java/org/apache/skywalking/apm/plugin/redisson/v3/RedissonPluginConfig.java)                                                                                                                                                                                                                              |
| `plugin.neo4j.trace_cypher_parameters`                          | If set to true, the parameters of the cypher would be collected.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | SW_PLUGIN_NEO4J_TRACE_CYPHER_PARAMETERS                          | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.neo4j.cypher_parameters_max_length`                     | If set to positive number, the `db.cypher.parameters` would be truncated to this length, otherwise it would be completely saved, which may cause performance problem.                                                                                                                                                                                                                                                                                                                                                                                  | SW_PLUGIN_NEO4J_CYPHER_PARAMETERS_MAX_LENGTH                     | `512`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.neo4j.cypher_body_max_length`                           | If set to positive number, the `db.statement` would be truncated to this length, otherwise it would be completely saved, which may cause performance problem.                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_NEO4J_CYPHER_BODY_MAX_LENGTH                           | `2048`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.cpupolicy.sample_cpu_usage_percent_limit`               | If set to a positive number and activate `trace sampler CPU policy plugin`, the trace would not be collected when agent process CPU usage percent is greater than `plugin.cpupolicy.sample_cpu_usage_percent_limit`.                                                                                                                                                                                                                                                                                                                                   | SW_SAMPLE_CPU_USAGE_PERCENT_LIMIT                                | `-1`                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `plugin.micronauthttpclient.collect_http_params`                | This config item controls that whether the Micronaut http client plugin should collect the parameters of the request. Also, activate implicitly in the profiled trace.                                                                                                                                                                                                                                                                                                                                                                                 | SW_PLUGIN_MICRONAUTHTTPCLIENT_COLLECT_HTTP_PARAMS                | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.micronauthttpserver.collect_http_params`                | This config item controls that whether the Micronaut http server plugin should collect the parameters of the request. Also, activate implicitly in the profiled trace.                                                                                                                                                                                                                                                                                                                                                                                 | SW_PLUGIN_MICRONAUTHTTPSERVER_COLLECT_HTTP_PARAMS                | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.memcached.operation_mapping_write`                      | Specify which command should be converted to `write` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_MEMCACHED_OPERATION_MAPPING_WRITE                      | `get,gets,getAndTouch,getKeys,getKeysWithExpiryCheck,getKeysNoDuplicateCheck`                                                                                                                                                                                                                                                                                                                                                                        |
| `plugin.memcached.operation_mapping_read`                       | Specify which command should be converted to `read` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_MEMCACHED_OPERATION_MAPPING_READ                       | `set,add,replace,append,prepend,cas,delete,touch,incr,decr`                                                                                                                                                                                                                                                                                                                                                                                          |
| `plugin.ehcache.operation_mapping_write`                        | Specify which command should be converted to `write` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_EHCACHE_OPERATION_MAPPING_WRITE                        | `get,getAll,getQuiet,getKeys,getKeysWithExpiryCheck,getKeysNoDuplicateCheck,releaseRead,tryRead,getWithLoader,getAll,loadAll,getAllWithLoader`                                                                                                                                                                                                                                                                                                       |
| `plugin.ehcache.operation_mapping_read`                         | Specify which command should be converted to `read` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_EHCACHE_OPERATION_MAPPING_READ                         | `tryRemoveImmediately,remove,removeAndReturnElement,removeAll,removeQuiet,removeWithWriter,put,putAll,replace,removeQuiet,removeWithWriter,removeElement,removeAll,putWithWriter,putQuiet,putIfAbsent,putIfAbsent`                                                                                                                                                                                                                                   |
| `plugin.guavacache.operation_mapping_write`                     | Specify which command should be converted to `write` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | SW_PLUGIN_GUAVACACHE_OPERATION_MAPPING_WRITE                     | `getIfPresent,get,getAllPresent,size`                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.guavacache.operation_mapping_read`                      | Specify which command should be converted to `read` operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_GUAVACACHE_OPERATION_MAPPING_READ                      | `put,putAll,invalidate,invalidateAll,invalidateAll,cleanUp`         
| `plugin.nettyhttp.collect_request_body`                             | This config item controls that whether the Netty-http plugin should collect the http body of the request.                                                                                                                                                                                                                                                                                                                                                                                                                                              | SW_PLUGIN_NETTY_HTTP_COLLECT_REQUEST_BODY                        | `false`                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `plugin.nettyhttp.filter_length_limit`                              | When `COLLECT_REQUEST_BODY` is enabled, how many characters to keep and send to the OAP backend, use negative values to keep and send the complete body.                                                                                                                                                                                                                                                                                                                                                                                     | SW_PLUGIN_NETTY_HTTP_FILTER_LENGTH_LIMIT                         | `1024`                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.nettyhttp.supported_content_types_prefix`                   | When `COLLECT_REQUEST_BODY` is enabled and content-type start with `HTTP_SUPPORTED_CONTENT_TYPES_PREFIX`, collect the body of the request , multiple paths should be separated by `,`                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_NETTY_HTTP_SUPPORTED_CONTENT_TYPES_PREFIX              | `application/json,text/`                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `plugin.rocketmqclient.collect_message_keys`                    | If set to true, the keys of messages would be collected by the plugin for RocketMQ Java client.
| `plugin.rocketmqclient.collect_message_tags`                    | If set to true, the tags of messages would be collected by the plugin for RocketMQ Java client.
| `plugin.solon.http_params_length_threshold`                     | Define the max length of collected HTTP parameters. The default value(=0) means not collecting.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | SW_PLUGIN_SOLON_HTTP_PARAMS_LENGTH_THRESHOLD                     | `0`                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `plugin.solon.include_http_headers`                             | It controls what header data should be collected, values must be in lower case, if empty, no header data will be collected. default is empty.                                                                                                                                                                                                                                                                                                                                                                                                          | SW_PLUGIN_SOLON_INCLUDE_HTTP_HEADERS                             | ``(No header would be collected)                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `plugin.solon.http_body_length_threshold`                       | Define the max length of collected HTTP body. The default value(=0) means not collecting.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | SW_PLUGIN_SOLON_HTTP_BODY_LENGTH_THRESHOLD                       | `0`                                                                                                                                                                                                                                                                                                                                                                                                                                                |


# Reset Collection/Map type configurations as empty collection.

* Collection type config, e.g. using ` plugin.kafka.topics=`
  to override default `plugin.kafka.topics=a,b,c,d`
* Map type config, e.g. using `plugin.kafka.producer_config[]=` to override
  default `plugin.kafka.producer_config[key]=value`

# Dynamic Configurations

All configurations above are static, if you need to change some agent settings at runtime, please
read [CDS - Configuration Discovery Service document](configuration-discovery.md) for more details.
