/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.undertow.v2x.handler;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class TracingHandler
implements HttpHandler {
    private final String template;
    private final HttpHandler next;

    public TracingHandler(HttpHandler handler) {
        this(null, handler);
    }

    public TracingHandler(String template, HttpHandler handler) {
        this.next = handler;
        this.template = template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderMap headers = exchange.getRequestHeaders();
        ContextCarrier carrier = new ContextCarrier();
        CarrierItem items = carrier.items();
        while (items.hasNext()) {
            items = items.next();
            items.setHeadValue(headers.getFirst(items.getHeadKey()));
        }
        String operationName = null == this.template ? exchange.getRequestPath() : this.template;
        final AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)carrier);
        Tags.URL.set(span, exchange.getRequestURL());
        Tags.HTTP.METHOD.set(span, exchange.getRequestMethod().toString());
        span.setComponent((Component)ComponentsDefine.UNDERTOW);
        SpanLayer.asHttp((AbstractSpan)span);
        try {
            span.prepareForAsync();
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                public void exchangeEvent(HttpServerExchange httpServerExchange, ExchangeCompletionListener.NextListener nextListener) {
                    nextListener.proceed();
                    if (httpServerExchange.getStatusCode() >= 400) {
                        span.errorOccurred();
                        Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(httpServerExchange.getStatusCode()));
                    }
                    span.asyncFinish();
                }
            });
        }
        catch (Throwable e) {
            ContextManager.activeSpan().log(e);
        }
        try {
            this.next.handleRequest(exchange);
        }
        catch (Throwable e) {
            span.log(e);
        }
        finally {
            ContextManager.stopSpan((AbstractSpan)span);
            ContextManager.getRuntimeContext().remove((Object)"SW_FORWARD_REQUEST_FLAG");
        }
    }
}

