/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.pulsar.common;

import java.lang.reflect.Method;
import org.apache.pulsar.client.api.Message;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.pulsar.common.ConsumerEnhanceRequiredInfo;
import org.apache.skywalking.apm.plugin.pulsar.common.MessageEnhanceRequiredInfo;

public class PulsarConsumerInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String OPERATE_NAME_PREFIX = "Pulsar/";
    public static final String CONSUMER_OPERATE_NAME = "/Consumer/";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (allArguments[0] != null) {
            ConsumerEnhanceRequiredInfo requiredInfo = (ConsumerEnhanceRequiredInfo)objInst.getSkyWalkingDynamicField();
            Message msg = (Message)allArguments[0];
            ContextCarrier carrier = new ContextCarrier();
            CarrierItem next = carrier.items();
            while (next.hasNext()) {
                next = next.next();
                next.setHeadValue(msg.getProperty(next.getHeadKey()));
            }
            AbstractSpan activeSpan = ContextManager.createEntrySpan((String)(OPERATE_NAME_PREFIX + requiredInfo.getTopic() + CONSUMER_OPERATE_NAME + requiredInfo.getSubscriptionName()), (ContextCarrier)carrier);
            activeSpan.setComponent((Component)ComponentsDefine.PULSAR_CONSUMER);
            SpanLayer.asMQ((AbstractSpan)activeSpan);
            Tags.MQ_BROKER.set(activeSpan, requiredInfo.getServiceUrl());
            Tags.MQ_TOPIC.set(activeSpan, requiredInfo.getTopic());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (allArguments[0] != null) {
            ConsumerEnhanceRequiredInfo requiredInfo = (ConsumerEnhanceRequiredInfo)objInst.getSkyWalkingDynamicField();
            EnhancedInstance msg = (EnhancedInstance)allArguments[0];
            MessageEnhanceRequiredInfo messageEnhanceRequiredInfo = (MessageEnhanceRequiredInfo)msg.getSkyWalkingDynamicField();
            if (messageEnhanceRequiredInfo == null) {
                messageEnhanceRequiredInfo = new MessageEnhanceRequiredInfo();
                msg.setSkyWalkingDynamicField((Object)messageEnhanceRequiredInfo);
            }
            messageEnhanceRequiredInfo.setTopic(requiredInfo.getTopic());
            messageEnhanceRequiredInfo.setContextSnapshot(ContextManager.capture());
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (allArguments[0] != null) {
            ContextManager.activeSpan().log(t);
        }
    }
}

