/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.pulsar;

import java.lang.reflect.Method;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.pulsar.ProducerEnhanceRequiredInfo;
import org.apache.skywalking.apm.plugin.pulsar.SendCallbackEnhanceRequiredInfo;

public class PulsarProducerInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String OPERATE_NAME_PREFIX = "Pulsar/";
    public static final String PRODUCER_OPERATE_NAME_SUFFIX = "/Producer";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (allArguments[0] != null) {
            ContextSnapshot snapshot;
            EnhancedInstance callbackInstance;
            ProducerEnhanceRequiredInfo requiredInfo = (ProducerEnhanceRequiredInfo)objInst.getSkyWalkingDynamicField();
            ContextCarrier contextCarrier = new ContextCarrier();
            String topicName = requiredInfo.getTopic();
            AbstractSpan activeSpan = ContextManager.createExitSpan((String)(OPERATE_NAME_PREFIX + topicName + PRODUCER_OPERATE_NAME_SUFFIX), (ContextCarrier)contextCarrier, (String)requiredInfo.getServiceUrl());
            Tags.MQ_BROKER.set(activeSpan, requiredInfo.getServiceUrl());
            Tags.MQ_TOPIC.set(activeSpan, topicName);
            contextCarrier.extensionInjector().injectSendingTimestamp();
            SpanLayer.asMQ((AbstractSpan)activeSpan);
            activeSpan.setComponent((Component)ComponentsDefine.PULSAR_PRODUCER);
            CarrierItem next = contextCarrier.items();
            MessageImpl msg = (MessageImpl)allArguments[0];
            while (next.hasNext()) {
                next = next.next();
                msg.getMessageBuilder().addProperties(PulsarApi.KeyValue.newBuilder().setKey(next.getHeadKey()).setValue(next.getHeadValue()));
            }
            if (allArguments.length > 1 && (callbackInstance = (EnhancedInstance)allArguments[1]) != null && null != (snapshot = ContextManager.capture())) {
                SendCallbackEnhanceRequiredInfo callbackRequiredInfo = new SendCallbackEnhanceRequiredInfo();
                callbackRequiredInfo.setTopic(topicName);
                callbackRequiredInfo.setContextSnapshot(snapshot);
                callbackInstance.setSkyWalkingDynamicField((Object)callbackRequiredInfo);
            }
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (allArguments[0] != null) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (allArguments[0] != null) {
            ContextManager.activeSpan().log(t);
        }
    }
}

