/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.ApiVersion;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Utils;

public class NodeApiVersions {
    private final Map<ApiKeys, ApiVersion> supportedVersions = new EnumMap<ApiKeys, ApiVersion>(ApiKeys.class);
    private final List<ApiVersion> unknownApis = new ArrayList<ApiVersion>();

    public static NodeApiVersions create() {
        return NodeApiVersions.create(Collections.emptyList());
    }

    public static NodeApiVersions create(Collection<ApiVersion> overrides) {
        LinkedList<ApiVersion> apiVersions = new LinkedList<ApiVersion>(overrides);
        for (ApiKeys apiKey : ApiKeys.values()) {
            boolean exists = false;
            for (ApiVersion apiVersion : apiVersions) {
                if (apiVersion.apiKey != apiKey.id) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            apiVersions.add(new ApiVersion(apiKey));
        }
        return new NodeApiVersions(apiVersions);
    }

    public static NodeApiVersions create(short apiKey, short minVersion, short maxVersion) {
        return NodeApiVersions.create(Collections.singleton(new ApiVersion(apiKey, minVersion, maxVersion)));
    }

    public NodeApiVersions(ApiVersionsResponseData.ApiVersionsResponseKeyCollection nodeApiVersions) {
        for (ApiVersionsResponseData.ApiVersionsResponseKey nodeApiVersion : nodeApiVersions) {
            if (ApiKeys.hasId(nodeApiVersion.apiKey())) {
                ApiKeys nodeApiKey = ApiKeys.forId(nodeApiVersion.apiKey());
                this.supportedVersions.put(nodeApiKey, new ApiVersion(nodeApiVersion));
                continue;
            }
            this.unknownApis.add(new ApiVersion(nodeApiVersion));
        }
    }

    public NodeApiVersions(Collection<ApiVersion> nodeApiVersions) {
        for (ApiVersion nodeApiVersion : nodeApiVersions) {
            if (ApiKeys.hasId(nodeApiVersion.apiKey)) {
                ApiKeys nodeApiKey = ApiKeys.forId(nodeApiVersion.apiKey);
                this.supportedVersions.put(nodeApiKey, nodeApiVersion);
                continue;
            }
            this.unknownApis.add(nodeApiVersion);
        }
    }

    public short latestUsableVersion(ApiKeys apiKey) {
        return this.latestUsableVersion(apiKey, apiKey.oldestVersion(), apiKey.latestVersion());
    }

    public short latestUsableVersion(ApiKeys apiKey, short oldestAllowedVersion, short latestAllowedVersion) {
        ApiVersion usableVersion = this.supportedVersions.get((Object)apiKey);
        if (usableVersion == null) {
            throw new UnsupportedVersionException("The broker does not support " + (Object)((Object)apiKey));
        }
        return this.latestUsableVersion(apiKey, usableVersion, oldestAllowedVersion, latestAllowedVersion);
    }

    private short latestUsableVersion(ApiKeys apiKey, ApiVersion supportedVersions, short minAllowedVersion, short maxAllowedVersion) {
        short maxVersion;
        short minVersion = (short)Math.max(minAllowedVersion, supportedVersions.minVersion);
        if (minVersion > (maxVersion = (short)Math.min(maxAllowedVersion, supportedVersions.maxVersion))) {
            throw new UnsupportedVersionException("The broker does not support " + (Object)((Object)apiKey) + " with version in range [" + minAllowedVersion + "," + maxAllowedVersion + "]. The supported range is [" + supportedVersions.minVersion + "," + supportedVersions.maxVersion + "].");
        }
        return maxVersion;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean lineBreaks) {
        TreeMap<Short, String> apiKeysText = new TreeMap<Short, String>();
        for (ApiVersion supportedVersion : this.supportedVersions.values()) {
            apiKeysText.put(supportedVersion.apiKey, this.apiVersionToText(supportedVersion));
        }
        for (ApiVersion apiVersion : this.unknownApis) {
            apiKeysText.put(apiVersion.apiKey, this.apiVersionToText(apiVersion));
        }
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKeysText.containsKey(apiKey.id)) continue;
            StringBuilder bld = new StringBuilder();
            bld.append(apiKey.name).append("(").append(apiKey.id).append("): ").append("UNSUPPORTED");
            apiKeysText.put(apiKey.id, bld.toString());
        }
        String separator = lineBreaks ? ",\n\t" : ", ";
        StringBuilder bld = new StringBuilder();
        bld.append("(");
        if (lineBreaks) {
            bld.append("\n\t");
        }
        bld.append(Utils.join(apiKeysText.values(), separator));
        if (lineBreaks) {
            bld.append("\n");
        }
        bld.append(")");
        return bld.toString();
    }

    private String apiVersionToText(ApiVersion apiVersion) {
        StringBuilder bld = new StringBuilder();
        ApiKeys apiKey = null;
        if (ApiKeys.hasId(apiVersion.apiKey)) {
            apiKey = ApiKeys.forId(apiVersion.apiKey);
            bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
        } else {
            bld.append("UNKNOWN(").append(apiVersion.apiKey).append("): ");
        }
        if (apiVersion.minVersion == apiVersion.maxVersion) {
            bld.append(apiVersion.minVersion);
        } else {
            bld.append(apiVersion.minVersion).append(" to ").append(apiVersion.maxVersion);
        }
        if (apiKey != null) {
            ApiVersion supportedVersion = this.supportedVersions.get((Object)apiKey);
            if (apiKey.latestVersion() < supportedVersion.minVersion) {
                bld.append(" [unusable: node too new]");
            } else if (supportedVersion.maxVersion < apiKey.oldestVersion()) {
                bld.append(" [unusable: node too old]");
            } else {
                short latestUsableVersion = Utils.min(apiKey.latestVersion(), supportedVersion.maxVersion);
                bld.append(" [usable: ").append(latestUsableVersion).append("]");
            }
        }
        return bld.toString();
    }

    public ApiVersion apiVersion(ApiKeys apiKey) {
        return this.supportedVersions.get((Object)apiKey);
    }
}

