/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.http.HttpClientResponse;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.vertx3.HttpClientRequestImplInterceptor;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class HttpClientRequestImplHandleResponseInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (VertxContext.VERTX_VERSION < 38.0 || allArguments.length == 2) {
            HttpClientRequestImplInterceptor.HttpClientRequestContext requestContext = (HttpClientRequestImplInterceptor.HttpClientRequestContext)objInst.getSkyWalkingDynamicField();
            if (!requestContext.usingWebClient) {
                VertxContext context = requestContext.vertxContext;
                Tags.HTTP_RESPONSE_STATUS_CODE.set(context.getSpan(), Integer.valueOf(((HttpClientResponse)allArguments[0]).statusCode()));
                context.getSpan().asyncFinish();
                AbstractSpan span = ContextManager.createLocalSpan((String)("#" + context.getSpan().getOperationName()));
                span.setComponent((Component)ComponentsDefine.VERTX);
                SpanLayer.asHttp((AbstractSpan)span);
                ContextManager.continued((ContextSnapshot)context.getContextSnapshot());
            }
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (VertxContext.VERTX_VERSION < 38.0 || allArguments.length == 2) {
            HttpClientRequestImplInterceptor.HttpClientRequestContext requestContext = (HttpClientRequestImplInterceptor.HttpClientRequestContext)objInst.getSkyWalkingDynamicField();
            if (!requestContext.usingWebClient) {
                ContextManager.stopSpan();
            }
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

