/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.jvm.gc.GCMetricAccessor;
import org.apache.skywalking.apm.network.language.agent.v3.GC;
import org.apache.skywalking.apm.network.language.agent.v3.GCPhase;

public abstract class GCModule
implements GCMetricAccessor {
    private List<GarbageCollectorMXBean> beans;
    private long lastOGCCount = 0L;
    private long lastYGCCount = 0L;
    private long lastOGCCollectionTime = 0L;
    private long lastYGCCollectionTime = 0L;
    private long lastNormalGCCount = 0L;
    private long lastNormalGCTime = 0L;

    public GCModule(List<GarbageCollectorMXBean> beans) {
        this.beans = beans;
    }

    @Override
    public List<GC> getGCList() {
        LinkedList<GC> gcList = new LinkedList<GC>();
        for (GarbageCollectorMXBean bean : this.beans) {
            long time;
            long collectionCount;
            GCPhase phase;
            String name = bean.getName();
            long gcCount = 0L;
            long gcTime = 0L;
            if (name.equals(this.getNewGCName())) {
                phase = GCPhase.NEW;
                collectionCount = bean.getCollectionCount();
                gcCount = collectionCount - this.lastYGCCount;
                this.lastYGCCount = collectionCount;
                time = bean.getCollectionTime();
                gcTime = time - this.lastYGCCollectionTime;
                this.lastYGCCollectionTime = time;
            } else if (name.equals(this.getOldGCName())) {
                phase = GCPhase.OLD;
                collectionCount = bean.getCollectionCount();
                gcCount = collectionCount - this.lastOGCCount;
                this.lastOGCCount = collectionCount;
                time = bean.getCollectionTime();
                gcTime = time - this.lastOGCCollectionTime;
                this.lastOGCCollectionTime = time;
            } else {
                if (!name.equals(this.getNormalGCName())) continue;
                phase = GCPhase.NORMAL;
                collectionCount = bean.getCollectionCount();
                gcCount = collectionCount - this.lastNormalGCCount;
                this.lastNormalGCCount = collectionCount;
                time = bean.getCollectionTime();
                gcTime = time - this.lastNormalGCTime;
                this.lastNormalGCTime = time;
            }
            gcList.add(GC.newBuilder().setPhase(phase).setCount(gcCount).setTime(gcTime).build());
        }
        return gcList;
    }

    protected abstract String getOldGCName();

    protected abstract String getNewGCName();

    protected abstract String getNormalGCName();
}

