/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.netty.buffer.ByteBuf;
import io.vertx.core.http.HttpServerResponse;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class HttpServerResponseImplInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        objInst.setSkyWalkingDynamicField(((EnhancedInstance)allArguments[1]).getSkyWalkingDynamicField());
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (VertxContext.VERTX_VERSION < 36.0 && allArguments[0] instanceof ByteBuf || VertxContext.VERTX_VERSION >= 36.0 && VertxContext.VERTX_VERSION <= 37.0 || allArguments.length == 2) {
            VertxContext context = (VertxContext)objInst.getSkyWalkingDynamicField();
            Tags.HTTP_RESPONSE_STATUS_CODE.set(context.getSpan(), Integer.valueOf(((HttpServerResponse)objInst).getStatusCode()));
            context.getSpan().asyncFinish();
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

