/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import java.util.ArrayList;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;
import org.apache.skywalking.apm.util.StringUtil;

public class OracleURLParser
extends AbstractURLParser {
    private static final String DB_TYPE = "Oracle";
    private static final int DEFAULT_PORT = 1521;
    public static final String SERVICE_NAME_FLAG = "@//";
    public static final String TNSNAME_URL_FLAG = "DESCRIPTION";

    public OracleURLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.isServiceNameURL() ? this.url.indexOf(SERVICE_NAME_FLAG) + 3 : this.url.indexOf("@") + 1;
        String urlTrimmed = this.url.substring(hostLabelStartIndex);
        int hostLabelEndIndex = urlTrimmed.contains("/") ? hostLabelStartIndex + urlTrimmed.indexOf("/") : this.url.lastIndexOf(":");
        return new URLLocation(hostLabelStartIndex, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int hostLabelStartIndex;
        int hostLabelEndIndex = this.url.length();
        if (this.isServiceNameURL()) {
            hostLabelStartIndex = this.url.lastIndexOf("/") + 1;
        } else if (this.isTNSNameURL()) {
            hostLabelStartIndex = this.url.indexOf("=", this.url.indexOf("SERVICE_NAME")) + 1;
            hostLabelEndIndex = this.url.indexOf(")", hostLabelStartIndex);
        } else {
            hostLabelStartIndex = this.url.lastIndexOf(":") + 1;
        }
        return new URLLocation(hostLabelStartIndex, hostLabelEndIndex);
    }

    private boolean isServiceNameURL() {
        return this.url.contains(SERVICE_NAME_FLAG);
    }

    private boolean isTNSNameURL() {
        return this.url.contains(TNSNAME_URL_FLAG);
    }

    @Override
    public ConnectionInfo parse() {
        if (this.isTNSNameURL()) {
            return this.tnsNameURLParse();
        }
        return this.commonsURLParse();
    }

    private ConnectionInfo commonsURLParse() {
        String host = this.fetchDatabaseHostsFromURL();
        String[] hostSegment = this.splitDatabaseAddress(host);
        String databaseName = this.fetchDatabaseNameFromURL();
        if (hostSegment.length == 1) {
            return new ConnectionInfo(ComponentsDefine.OJDBC, DB_TYPE, host, 1521, databaseName);
        }
        return new ConnectionInfo(ComponentsDefine.OJDBC, DB_TYPE, hostSegment[0], Integer.valueOf(hostSegment[1]), databaseName);
    }

    private ConnectionInfo tnsNameURLParse() {
        String host = this.parseDatabaseHostsFromURL();
        String databaseName = this.fetchDatabaseNameFromURL();
        return new ConnectionInfo(ComponentsDefine.OJDBC, DB_TYPE, host, databaseName);
    }

    private String parseDatabaseHostsFromURL() {
        int hostStartIndex;
        int beginIndex = this.url.indexOf(TNSNAME_URL_FLAG);
        ArrayList<String> hosts = new ArrayList<String>();
        while ((hostStartIndex = this.url.indexOf("HOST", beginIndex)) != -1) {
            int equalStartIndex = this.url.indexOf("=", hostStartIndex);
            int hostEndIndex = this.url.indexOf(")", hostStartIndex);
            String host = this.url.substring(equalStartIndex + 1, hostEndIndex);
            int port = 1521;
            int portStartIndex = this.url.indexOf("PORT", hostEndIndex);
            int portEndIndex = this.url.length();
            if (portStartIndex != -1) {
                int portEqualStartIndex = this.url.indexOf("=", portStartIndex);
                portEndIndex = this.url.indexOf(")", portEqualStartIndex);
                port = Integer.parseInt(this.url.substring(portEqualStartIndex + 1, portEndIndex).trim());
            }
            hosts.add(host.trim() + ":" + port);
            beginIndex = portEndIndex;
        }
        return StringUtil.join((char)',', (String[])hosts.toArray(new String[0]));
    }

    private String[] splitDatabaseAddress(String address) {
        String[] hostSegment = address.split(":");
        if (hostSegment.length == 1 && super.fetchDatabaseNameFromURL().contains("/")) {
            String[] portAndDatabaseName = super.fetchDatabaseNameFromURL().split("/");
            return new String[]{hostSegment[0], portAndDatabaseName[0]};
        }
        return hostSegment;
    }

    @Override
    protected String fetchDatabaseNameFromURL() {
        String databaseName = super.fetchDatabaseNameFromURL();
        if (databaseName.contains("/")) {
            String[] portAndDatabaseName = databaseName.split("/");
            return portAndDatabaseName[1];
        }
        return databaseName;
    }
}

