/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.commons.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.RuntimeContext;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.util.CollectionUtil;
import org.apache.skywalking.apm.agent.core.util.MethodUtil;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.EnhanceRequireObjectCache;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.RequestUtil;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.SpringMVCPluginConfig;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.exception.IllegalMethodStackDepthException;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.exception.ServletResponseNotFoundException;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.interceptor.StackDepth;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;

public abstract class AbstractMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final ILog LOGGER = LogManager.getLogger(AbstractMethodInterceptor.class);
    private static boolean IS_SERVLET_GET_STATUS_METHOD_EXIST;
    private static boolean IS_JAKARTA_SERVLET_GET_STATUS_METHOD_EXIST;
    private static final String SERVLET_RESPONSE_CLASS = "javax.servlet.http.HttpServletResponse";
    private static final String JAKARTA_SERVLET_RESPONSE_CLASS = "jakarta.servlet.http.HttpServletResponse";
    private static final String GET_STATUS_METHOD = "getStatus";
    private static boolean IN_SERVLET_CONTAINER;
    private static boolean IS_JAVAX;
    private static boolean IS_JAKARTA;

    public abstract String getRequestURL(Method var1);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Boolean forwardRequestFlag = (Boolean)ContextManager.getRuntimeContext().get((Object)"SW_FORWARD_REQUEST_FLAG");
        if (forwardRequestFlag != null && forwardRequestFlag.booleanValue()) {
            return;
        }
        Object request = ContextManager.getRuntimeContext().get((Object)"SW_REQUEST");
        if (request != null) {
            StackDepth stackDepth = (StackDepth)ContextManager.getRuntimeContext().get((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH");
            if (stackDepth == null) {
                ContextCarrier contextCarrier = new ContextCarrier();
                if (IN_SERVLET_CONTAINER && IS_JAVAX && javax.servlet.http.HttpServletRequest.class.isAssignableFrom(request.getClass())) {
                    javax.servlet.http.HttpServletRequest httpServletRequest = (javax.servlet.http.HttpServletRequest)request;
                    CarrierItem next = contextCarrier.items();
                    while (next.hasNext()) {
                        next = next.next();
                        next.setHeadValue(httpServletRequest.getHeader(next.getHeadKey()));
                    }
                    String operationName = this.buildOperationName(method, httpServletRequest.getMethod(), (EnhanceRequireObjectCache)objInst.getSkyWalkingDynamicField());
                    AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
                    Tags.URL.set(span, httpServletRequest.getRequestURL().toString());
                    Tags.HTTP.METHOD.set(span, httpServletRequest.getMethod());
                    span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
                    SpanLayer.asHttp((AbstractSpan)span);
                    if (SpringMVCPluginConfig.Plugin.SpringMVC.COLLECT_HTTP_PARAMS) {
                        RequestUtil.collectHttpParam(httpServletRequest, span);
                    }
                    if (!CollectionUtil.isEmpty(SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS)) {
                        RequestUtil.collectHttpHeaders(httpServletRequest, span);
                    }
                } else if (IN_SERVLET_CONTAINER && IS_JAKARTA && HttpServletRequest.class.isAssignableFrom(request.getClass())) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                    CarrierItem next = contextCarrier.items();
                    while (next.hasNext()) {
                        next = next.next();
                        next.setHeadValue(httpServletRequest.getHeader(next.getHeadKey()));
                    }
                    String operationName = this.buildOperationName(method, httpServletRequest.getMethod(), (EnhanceRequireObjectCache)objInst.getSkyWalkingDynamicField());
                    AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
                    Tags.URL.set(span, httpServletRequest.getRequestURL().toString());
                    Tags.HTTP.METHOD.set(span, httpServletRequest.getMethod());
                    span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
                    SpanLayer.asHttp((AbstractSpan)span);
                    if (SpringMVCPluginConfig.Plugin.SpringMVC.COLLECT_HTTP_PARAMS) {
                        RequestUtil.collectHttpParam(httpServletRequest, span);
                    }
                    if (!CollectionUtil.isEmpty(SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS)) {
                        RequestUtil.collectHttpHeaders(httpServletRequest, span);
                    }
                } else if (ServerHttpRequest.class.isAssignableFrom(request.getClass())) {
                    ServerHttpRequest serverHttpRequest = (ServerHttpRequest)request;
                    CarrierItem next = contextCarrier.items();
                    while (next.hasNext()) {
                        next = next.next();
                        next.setHeadValue(serverHttpRequest.getHeaders().getFirst(next.getHeadKey()));
                    }
                    String operationName = this.buildOperationName(method, serverHttpRequest.getMethodValue(), (EnhanceRequireObjectCache)objInst.getSkyWalkingDynamicField());
                    AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
                    Tags.URL.set(span, serverHttpRequest.getURI().toString());
                    Tags.HTTP.METHOD.set(span, serverHttpRequest.getMethodValue());
                    span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
                    SpanLayer.asHttp((AbstractSpan)span);
                    if (SpringMVCPluginConfig.Plugin.SpringMVC.COLLECT_HTTP_PARAMS) {
                        RequestUtil.collectHttpParam(serverHttpRequest, span);
                    }
                    if (!CollectionUtil.isEmpty(SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS)) {
                        RequestUtil.collectHttpHeaders(serverHttpRequest, span);
                    }
                } else {
                    throw new IllegalStateException("this line should not be reached");
                }
                stackDepth = new StackDepth();
                ContextManager.getRuntimeContext().put((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH", (Object)stackDepth);
            } else {
                AbstractSpan span = ContextManager.createLocalSpan((String)this.buildOperationName(objInst, method));
                span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
            }
            stackDepth.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        RuntimeContext runtimeContext = ContextManager.getRuntimeContext();
        Boolean forwardRequestFlag = (Boolean)runtimeContext.get((Object)"SW_FORWARD_REQUEST_FLAG");
        if (forwardRequestFlag != null && forwardRequestFlag.booleanValue()) {
            return ret;
        }
        Object request = runtimeContext.get((Object)"SW_REQUEST");
        if (request != null) {
            try {
                StackDepth stackDepth = (StackDepth)runtimeContext.get((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH");
                if (stackDepth == null) {
                    throw new IllegalMethodStackDepthException();
                }
                stackDepth.decrement();
                AbstractSpan span = ContextManager.activeSpan();
                if (stackDepth.depth() == 0) {
                    Object response = runtimeContext.get((Object)"SW_RESPONSE");
                    if (response == null) {
                        throw new ServletResponseNotFoundException();
                    }
                    Integer statusCode = null;
                    if (IS_SERVLET_GET_STATUS_METHOD_EXIST && HttpServletResponse.class.isAssignableFrom(response.getClass())) {
                        statusCode = ((HttpServletResponse)response).getStatus();
                    } else if (IS_JAKARTA_SERVLET_GET_STATUS_METHOD_EXIST && jakarta.servlet.http.HttpServletResponse.class.isAssignableFrom(response.getClass())) {
                        statusCode = ((jakarta.servlet.http.HttpServletResponse)response).getStatus();
                    } else if (ServerHttpResponse.class.isAssignableFrom(response.getClass())) {
                        Object context;
                        if (IS_SERVLET_GET_STATUS_METHOD_EXIST || IS_JAKARTA_SERVLET_GET_STATUS_METHOD_EXIST) {
                            statusCode = ((ServerHttpResponse)response).getRawStatusCode();
                        }
                        if ((context = runtimeContext.get((Object)"SW_REACTIVE_RESPONSE_ASYNC_SPAN")) != null) {
                            ((AbstractSpan[])context)[0] = span.prepareForAsync();
                        }
                    }
                    if (statusCode != null) {
                        Tags.HTTP_RESPONSE_STATUS_CODE.set(span, statusCode);
                        if (statusCode >= 400) {
                            span.errorOccurred();
                        }
                    }
                    runtimeContext.remove((Object)"SW_REACTIVE_RESPONSE_ASYNC_SPAN");
                    runtimeContext.remove((Object)"SW_REQUEST");
                    runtimeContext.remove((Object)"SW_RESPONSE");
                    runtimeContext.remove((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH");
                }
                if (!SpringMVCPluginConfig.Plugin.SpringMVC.COLLECT_HTTP_PARAMS && span.isProfiling()) {
                    if (IS_JAVAX && javax.servlet.http.HttpServletRequest.class.isAssignableFrom(request.getClass())) {
                        RequestUtil.collectHttpParam((javax.servlet.http.HttpServletRequest)request, span);
                    } else if (IS_JAKARTA && HttpServletRequest.class.isAssignableFrom(request.getClass())) {
                        RequestUtil.collectHttpParam((HttpServletRequest)request, span);
                    } else if (ServerHttpRequest.class.isAssignableFrom(request.getClass())) {
                        RequestUtil.collectHttpParam((ServerHttpRequest)request, span);
                    }
                }
            }
            finally {
                ContextManager.stopSpan();
            }
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private String buildOperationName(Object invoker, Method method) {
        StringBuilder operationName = new StringBuilder(invoker.getClass().getName()).append(".").append(method.getName()).append("(");
        for (Class<?> type : method.getParameterTypes()) {
            operationName.append(type.getName()).append(",");
        }
        if (method.getParameterTypes().length > 0) {
            operationName = operationName.deleteCharAt(operationName.length() - 1);
        }
        return operationName.append(")").toString();
    }

    private String buildOperationName(Method method, String httpMethod, EnhanceRequireObjectCache pathMappingCache) {
        String operationName;
        if (SpringMVCPluginConfig.Plugin.SpringMVC.USE_QUALIFIED_NAME_AS_ENDPOINT_NAME) {
            operationName = MethodUtil.generateOperationName((Method)method);
        } else {
            String requestURL = pathMappingCache.findPathMapping(method);
            if (requestURL == null) {
                requestURL = this.getRequestURL(method);
                pathMappingCache.addPathMapping(method, requestURL);
                requestURL = pathMappingCache.findPathMapping(method);
            }
            operationName = String.join((CharSequence)":", httpMethod, requestURL);
        }
        return operationName;
    }

    static {
        IS_JAVAX = false;
        IS_JAKARTA = false;
        IS_SERVLET_GET_STATUS_METHOD_EXIST = MethodUtil.isMethodExist((ClassLoader)AbstractMethodInterceptor.class.getClassLoader(), (String)SERVLET_RESPONSE_CLASS, (String)GET_STATUS_METHOD, (String[])new String[0]);
        IS_JAKARTA_SERVLET_GET_STATUS_METHOD_EXIST = MethodUtil.isMethodExist((ClassLoader)AbstractMethodInterceptor.class.getClassLoader(), (String)JAKARTA_SERVLET_RESPONSE_CLASS, (String)GET_STATUS_METHOD, (String[])new String[0]);
        try {
            Class.forName(SERVLET_RESPONSE_CLASS, true, AbstractMethodInterceptor.class.getClassLoader());
            IN_SERVLET_CONTAINER = true;
            IS_JAVAX = true;
        }
        catch (Exception ignore) {
            try {
                Class.forName(JAKARTA_SERVLET_RESPONSE_CLASS, true, AbstractMethodInterceptor.class.getClassLoader());
                IN_SERVLET_CONTAINER = true;
                IS_JAKARTA = true;
            }
            catch (Exception ignore2) {
                IN_SERVLET_CONTAINER = false;
            }
        }
    }
}

