/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.micrometer;

import io.micrometer.observation.Observation;
import io.micrometer.observation.transport.SenderContext;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.toolkit.activation.micrometer.SpanHelper;
import org.apache.skywalking.apm.toolkit.activation.micrometer.TaggingHelper;
import org.apache.skywalking.apm.util.StringUtil;

public class MicrometerSenderTracingHandlerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String methodName = method.getName();
        if ("onStart".equals(methodName)) {
            SenderContext context = (SenderContext)allArguments[0];
            ContextCarrier contextCarrier = new ContextCarrier();
            AbstractSpan span = ContextManager.createExitSpan((String)MicrometerSenderTracingHandlerInterceptor.getOperationName(context), (ContextCarrier)contextCarrier, (String)SpanHelper.tryToGetPeer(context.getRemoteServiceAddress(), context.getAllKeyValues()));
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                context.getSetter().set(context.getCarrier(), next.getHeadKey(), next.getHeadValue());
            }
            span.setComponent((Component)ComponentsDefine.MICROMETER);
        } else if ("onStop".equals(methodName)) {
            SenderContext context = (SenderContext)allArguments[0];
            SpanLayer spanLayer = TaggingHelper.toLayer(context.getAllKeyValues());
            AbstractSpan abstractSpan = ContextManager.activeSpan();
            abstractSpan.setPeer(SpanHelper.tryToGetPeer(context.getRemoteServiceAddress(), context.getAllKeyValues())).setOperationName(MicrometerSenderTracingHandlerInterceptor.getOperationName(context));
            context.getAllKeyValues().forEach(keyValue -> abstractSpan.tag(Tags.ofKey((String)keyValue.getKey()), keyValue.getValue()));
            if (spanLayer != null) {
                abstractSpan.setLayer(spanLayer);
            }
            ContextManager.stopSpan();
        } else if ("onError".equals(methodName)) {
            Observation.Context context = (Observation.Context)allArguments[0];
            ContextManager.activeSpan().log(context.getError());
        }
    }

    private static String getOperationName(SenderContext<Object> context) {
        return StringUtil.isBlank((String)context.getContextualName()) ? context.getName() : context.getContextualName();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

