/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1.server;

import io.grpc.ForwardingServerCallListener;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;

public class TracingServerCallListener<REQUEST>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<REQUEST> {
    private final MethodDescriptor.MethodType methodType;
    private final String operationPrefix;
    private final String operation;
    private final ContextCarrier contextCarrier;
    private AbstractSpan asyncSpan;
    private ContextSnapshot contextSnapshot;

    protected TracingServerCallListener(ServerCall.Listener<REQUEST> delegate, MethodDescriptor<REQUEST, ?> descriptor, ContextCarrier contextCarrier) {
        super(delegate);
        this.methodType = descriptor.getType();
        this.operationPrefix = OperationNameFormatUtil.formatOperationName(descriptor) + "/server";
        this.operation = OperationNameFormatUtil.formatOperationName(descriptor);
        this.contextCarrier = contextCarrier;
    }

    public void onMessage(REQUEST message) {
        if (!this.methodType.clientSendsOneMessage()) {
            AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onMessage"));
            span.setComponent((Component)ComponentsDefine.GRPC);
            span.setLayer(SpanLayer.RPC_FRAMEWORK);
            ContextManager.continued((ContextSnapshot)this.contextSnapshot);
            try {
                super.onMessage(message);
            }
            catch (Throwable t) {
                ContextManager.activeSpan().log(t);
                throw t;
            }
            finally {
                ContextManager.stopSpan();
            }
        } else {
            super.onMessage(message);
        }
    }

    public void onCancel() {
        if (this.contextSnapshot == null) {
            return;
        }
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onCancel"));
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextManager.continued((ContextSnapshot)this.contextSnapshot);
        try {
            super.onCancel();
        }
        catch (Throwable t) {
            ContextManager.activeSpan().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
            this.asyncSpan.asyncFinish();
        }
    }

    public void onHalfClose() {
        AbstractSpan span = ContextManager.createLocalSpan((String)(this.operationPrefix + "/Request/onHalfClose"));
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextManager.continued((ContextSnapshot)this.contextSnapshot);
        try {
            super.onHalfClose();
        }
        catch (Throwable t) {
            ContextManager.activeSpan().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    public void onComplete() {
        super.onComplete();
        this.asyncSpan.asyncFinish();
    }

    public void onReady() {
        AbstractSpan span = ContextManager.createEntrySpan((String)this.operation, (ContextCarrier)this.contextCarrier);
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        this.contextSnapshot = ContextManager.capture();
        this.asyncSpan = span.prepareForAsync();
        ContextManager.stopSpan((AbstractSpan)this.asyncSpan);
        super.onReady();
    }
}

