/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.logging.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.logging.core.AbstractLogger;
import org.apache.skywalking.apm.agent.core.logging.core.Converter;
import org.apache.skywalking.apm.agent.core.logging.core.LogEvent;
import org.apache.skywalking.apm.agent.core.logging.core.LogLevel;
import org.apache.skywalking.apm.agent.core.logging.core.converters.LiteralConverter;
import org.apache.skywalking.apm.dependencies.com.google.gson.Gson;

public class JsonLogger
extends AbstractLogger {
    private final Gson gson;

    public JsonLogger(Class<?> targetClass, Gson gson) {
        this(targetClass.getSimpleName(), gson);
    }

    public JsonLogger(String targetClass, Gson gson) {
        super(targetClass);
        this.gson = gson;
        for (Map.Entry entry : DEFAULT_CONVERTER_MAP.entrySet()) {
            Class converterClass = (Class)entry.getValue();
            try {
                if (this.converters instanceof LiteralConverter) continue;
                this.converters.add(converterClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Create Converter error. Class: " + converterClass, e);
            }
        }
    }

    @Override
    protected String format(LogLevel level, String message, Throwable e) {
        LogEvent logEvent = new LogEvent(level, message, e, this.targetClass);
        HashMap<String, String> log = new HashMap<String, String>(this.converters.size());
        for (Converter converter : this.converters) {
            log.put(converter.getKey(), converter.convert(logEvent));
        }
        return this.gson.toJson(log);
    }
}

