/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.webflux;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import org.springframework.web.server.adapter.DefaultServerWebExchange;
import reactor.util.context.Context;

public class WebFluxSkyWalkingOperatorsInterceptor
implements StaticMethodsAroundInterceptor {
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
        EnhancedInstance instance;
        if (parameterTypes[0] == Context.class) {
            ((Context)allArguments[0]).getOrEmpty((Object)"SKYWALKING_CONTEXT_SNAPSHOT").ifPresent(ctx -> {
                ContextManager.createLocalSpan((String)"WebFluxOperators/onNext").setComponent((Component)ComponentsDefine.SPRING_WEBFLUX);
                ContextManager.continued((ContextSnapshot)((ContextSnapshot)ctx));
            });
        } else if (parameterTypes[0] == ServerWebExchange.class && (instance = WebFluxSkyWalkingOperatorsInterceptor.getInstance(allArguments[0])) != null && instance.getSkyWalkingDynamicField() != null) {
            ContextManager.createLocalSpan((String)"WebFluxOperators/onNext").setComponent((Component)ComponentsDefine.SPRING_WEBFLUX);
            ContextManager.continued((ContextSnapshot)((ContextSnapshot)instance.getSkyWalkingDynamicField()));
        }
    }

    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private static EnhancedInstance getInstance(Object o) {
        EnhancedInstance instance = null;
        if (o instanceof DefaultServerWebExchange && o instanceof EnhancedInstance) {
            instance = (EnhancedInstance)o;
        } else if (o instanceof ServerWebExchangeDecorator) {
            ServerWebExchange delegate = ((ServerWebExchangeDecorator)o).getDelegate();
            return WebFluxSkyWalkingOperatorsInterceptor.getInstance(delegate);
        }
        return instance;
    }
}

