/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.network.trace.component.OfficialComponent;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class ImpalaJdbcURLParser
extends AbstractURLParser {
    private static final int DEFAULT_PORT = 21050;
    private static final String DB_TYPE = "Impala";
    private OfficialComponent component = ComponentsDefine.IMPALA_JDBC_DRIVER;

    public ImpalaJdbcURLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        int hostLabelEndIndex = this.url.length();
        int hostLabelEndIndexWithParameter = this.url.indexOf(";", hostLabelStartIndex);
        if (hostLabelEndIndexWithParameter != -1) {
            String subUrl = this.url.substring(0, hostLabelEndIndexWithParameter);
            int schemaIndex = subUrl.indexOf("/", hostLabelStartIndex + 2);
            hostLabelEndIndex = schemaIndex == -1 ? hostLabelEndIndexWithParameter : schemaIndex;
        }
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    protected String fetchDatabaseNameFromURL(int startSize) {
        URLLocation hostsLocation = this.fetchDatabaseNameIndexRange(startSize);
        if (hostsLocation == null) {
            return "";
        }
        return this.url.substring(hostsLocation.startIndex(), hostsLocation.endIndex());
    }

    protected URLLocation fetchDatabaseNameIndexRange(int startSize) {
        int databaseStartTag = this.url.indexOf("/", startSize);
        int firstParamIndex = this.url.indexOf(";", startSize);
        int databaseEndTag = this.url.length();
        if (databaseStartTag == -1 && firstParamIndex == -1) {
            return null;
        }
        String subUrl = this.url.substring(startSize, firstParamIndex);
        int schemaIndex = subUrl.indexOf("/");
        if (schemaIndex == -1) {
            return null;
        }
        databaseEndTag = firstParamIndex;
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        URLLocation location = this.fetchDatabaseHostsIndexRange();
        return this.fetchDatabaseNameIndexRange(location.endIndex());
    }

    @Override
    public ConnectionInfo parse() {
        URLLocation location = this.fetchDatabaseHostsIndexRange();
        String hosts = this.url.substring(location.startIndex(), location.endIndex());
        String[] hostSegment = hosts.split(",");
        if (hostSegment.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String host : hostSegment) {
                if (host.split(":").length == 1) {
                    sb.append(host).append(":").append(21050).append(",");
                    continue;
                }
                sb.append(host).append(",");
            }
            return new ConnectionInfo(this.component, DB_TYPE, sb.substring(0, sb.length() - 1), this.fetchDatabaseNameFromURL());
        }
        String[] hostAndPort = hostSegment[0].split(":");
        if (hostAndPort.length != 1) {
            return new ConnectionInfo(this.component, DB_TYPE, hostAndPort[0], Integer.valueOf(hostAndPort[1]), this.fetchDatabaseNameFromURL(location.endIndex()));
        }
        return new ConnectionInfo(this.component, DB_TYPE, hostAndPort[0], 21050, this.fetchDatabaseNameFromURL(location.endIndex()));
    }
}

