/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.undertow.worker.thread.pool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;

public class UndertowWorkerThreadPoolConstructorIntercept
implements InstanceConstructorInterceptor {
    private static final String THREAD_POOL_NAME = "undertow_worker_pool";
    private static final Map<String, Function<ThreadPoolExecutor, Supplier<Double>>> METRIC_MAP = new HashMap<String, Function<ThreadPoolExecutor, Supplier<Double>>>(){
        {
            this.put("core_pool_size", threadPoolExecutor -> () -> threadPoolExecutor.getCorePoolSize());
            this.put("max_pool_size", threadPoolExecutor -> () -> threadPoolExecutor.getMaximumPoolSize());
            this.put("pool_size", threadPoolExecutor -> () -> threadPoolExecutor.getPoolSize());
            this.put("queue_size", threadPoolExecutor -> () -> threadPoolExecutor.getQueue().size());
            this.put("active_size", threadPoolExecutor -> () -> threadPoolExecutor.getActiveCount());
        }
    };

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)objInst;
        this.buildThreadPoolMeterMetric(threadPoolExecutor);
    }

    private void buildThreadPoolMeterMetric(ThreadPoolExecutor threadPoolExecutor) {
        String threadPoolMeterName = "thread_pool";
        String poolNameTag = "pool_name";
        String metricTypeTag = "metric_type";
        METRIC_MAP.forEach((key, value) -> {
            Gauge cfr_ignored_0 = (Gauge)((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)threadPoolMeterName, (Supplier)((Supplier)value.apply(threadPoolExecutor))).tag(poolNameTag, THREAD_POOL_NAME)).tag(metricTypeTag, key)).build();
        });
    }
}

