/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.tag;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.IntegerTag;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;

public final class Tags {
    private static final Map<String, StringTag> TAG_PROTOTYPES = new ConcurrentHashMap<String, StringTag>();
    public static final StringTag URL = new StringTag(1, "url");
    public static final IntegerTag HTTP_RESPONSE_STATUS_CODE = new IntegerTag(2, "http.status_code", true);
    public static final StringTag DB_TYPE = new StringTag(3, "db.type");
    public static final StringTag DB_INSTANCE = new StringTag(4, "db.instance");
    public static final StringTag DB_STATEMENT = new StringTag(5, "db.statement");
    public static final StringTag DB_BIND_VARIABLES = new StringTag(6, "db.bind_vars");
    public static final StringTag MQ_QUEUE = new StringTag(7, "mq.queue");
    public static final StringTag MQ_BROKER = new StringTag(8, "mq.broker");
    public static final StringTag MQ_TOPIC = new StringTag(9, "mq.topic");
    public static final StringTag MQ_STATUS = new StringTag(16, "mq_status");
    public static final StringTag MYBATIS_MAPPER = new StringTag(17, "mybatis.mapper");
    public static final StringTag TRANSMISSION_LATENCY = new StringTag(15, "transmission.latency", false);
    public static final StringTag RPC_RESPONSE_STATUS_CODE = new StringTag(18, "rpc.status_code", true);
    public static final StringTag LOGIC_ENDPOINT = new StringTag(12, "x-le");
    public static final StringTag CACHE_TYPE = new StringTag(15, "cache.type");
    public static final StringTag CACHE_OP = new StringTag(16, "cache.op");
    public static final StringTag CACHE_CMD = new StringTag(17, "cache.cmd");
    public static final StringTag CACHE_KEY = new StringTag(18, "cache.key");
    public static final String VAL_LOCAL_SPAN_AS_LOGIC_ENDPOINT = "{\"logic-span\":true}";
    public static final StringTag SQL_PARAMETERS = new StringTag(19, "db.sql.parameters");

    private Tags() {
    }

    public static AbstractTag<String> ofKey(String key) {
        return TAG_PROTOTYPES.computeIfAbsent(key, StringTag::new);
    }

    public static final class HTTP {
        public static final StringTag METHOD = new StringTag(10, "http.method");
        public static final StringTag PARAMS = new StringTag(11, "http.params", true);
        public static final StringTag BODY = new StringTag(13, "http.body");
        public static final StringTag HEADERS = new StringTag(14, "http.headers");
    }
}

