/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx4;

import io.vertx.core.Context;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class SWVertxTracer
implements VertxTracer<AbstractSpan, AbstractSpan> {
    public <R> AbstractSpan receiveRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy)) {
            return null;
        }
        if (request instanceof HttpRequest) {
            HttpRequest serverRequest = (HttpRequest)request;
            ContextCarrier contextCarrier = this.getContextCarrier(headers);
            AbstractSpan span = this.toEntrySpan(String.join((CharSequence)":", serverRequest.method().name(), serverRequest.uri()), contextCarrier, context);
            SpanLayer.asHttp((AbstractSpan)span);
            Tags.HTTP.METHOD.set(span, serverRequest.method().toString());
            Tags.URL.set(span, serverRequest.absoluteURI());
            return this.toAsyncSpan(context, span, false);
        }
        if (request instanceof Message) {
            Message serverRequest = (Message)request;
            ContextCarrier contextCarrier = this.getContextCarrier(headers);
            AbstractSpan span = this.toEntrySpan(serverRequest.address(), contextCarrier, context);
            SpanLayer.asRPCFramework((AbstractSpan)span);
            return this.toAsyncSpan(context, span, false);
        }
        return null;
    }

    public <R> void sendResponse(Context context, R response, AbstractSpan payload, Throwable failure, TagExtractor<R> tagExtractor) {
        if (payload != null) {
            if (failure != null) {
                payload.log(failure);
            }
            if (response instanceof HttpResponse) {
                Tags.HTTP_RESPONSE_STATUS_CODE.set(payload, Integer.valueOf(((HttpResponse)response).statusCode()));
            }
            payload.asyncFinish();
        }
    }

    public <R> AbstractSpan sendRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy) || request == null) {
            return null;
        }
        if (request instanceof HttpRequest) {
            HttpRequest clientRequest = (HttpRequest)request;
            ContextCarrier contextCarrier = new ContextCarrier();
            AbstractSpan span = this.toExitSpan(clientRequest.uri(), clientRequest.remoteAddress().host() + ":" + clientRequest.remoteAddress().port(), contextCarrier, context);
            SpanLayer.asHttp((AbstractSpan)span);
            Tags.HTTP.METHOD.set(span, clientRequest.method().name());
            Tags.URL.set(span, clientRequest.absoluteURI());
            return this.toExitAsyncSpan(context, headers, contextCarrier, span);
        }
        if (request instanceof Message) {
            EnhancedInstance enhancedInstance;
            Message clientRequest = (Message)request;
            String remotePeer = "localhost";
            if (clientRequest instanceof ClusteredMessage && (enhancedInstance = (EnhancedInstance)clientRequest).getSkyWalkingDynamicField() != null) {
                remotePeer = (String)enhancedInstance.getSkyWalkingDynamicField();
            }
            ContextCarrier contextCarrier = new ContextCarrier();
            AbstractSpan span = this.toExitSpan(clientRequest.address(), remotePeer, contextCarrier, context);
            SpanLayer.asRPCFramework((AbstractSpan)span);
            return this.toExitAsyncSpan(context, headers, contextCarrier, span);
        }
        return null;
    }

    public <R> void receiveResponse(Context context, R response, AbstractSpan payload, Throwable failure, TagExtractor<R> tagExtractor) {
        this.sendResponse(context, response, payload, failure, tagExtractor);
    }

    private void continueContextIfNecessary(Context context) {
        ConcurrentMap contextMap = ((ContextInternal)context).localContextData();
        ContextSnapshot contextSnapshot = (ContextSnapshot)contextMap.get("sw.context-snapshot");
        if (contextSnapshot != null) {
            ContextManager.continued((ContextSnapshot)contextSnapshot);
        }
    }

    private ContextCarrier getContextCarrier(Iterable<Map.Entry<String, String>> headers) {
        HashMap headerMap = new HashMap();
        headers.forEach(it -> {
            String cfr_ignored_0 = (String)headerMap.put(it.getKey(), it.getValue());
        });
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue((String)headerMap.get(next.getHeadKey()));
        }
        return contextCarrier;
    }

    private AbstractSpan toAsyncSpan(Context context, AbstractSpan span, boolean isExitSpan) {
        ConcurrentMap contextMap = ((ContextInternal)context).localContextData();
        if (!isExitSpan) {
            contextMap.put("sw.context-snapshot", ContextManager.capture());
        }
        AbstractSpan asyncSpan = span.prepareForAsync();
        ContextManager.stopSpan();
        return asyncSpan;
    }

    private AbstractSpan toExitAsyncSpan(Context context, BiConsumer<String, String> headers, ContextCarrier contextCarrier, AbstractSpan span) {
        ContextManager.inject((ContextCarrier)contextCarrier);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            headers.accept(next.getHeadKey(), next.getHeadValue());
        }
        return this.toAsyncSpan(context, span, true);
    }

    private AbstractSpan toEntrySpan(String operationName, ContextCarrier contextCarrier, Context context) {
        AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
        this.continueContextIfNecessary(context);
        span.setComponent((Component)ComponentsDefine.VERTX);
        return span;
    }

    private AbstractSpan toExitSpan(String operationName, String remotePeer, ContextCarrier contextCarrier, Context context) {
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)remotePeer);
        this.continueContextIfNecessary(context);
        span.setComponent((Component)ComponentsDefine.VERTX);
        return span;
    }
}

