/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2;

import java.lang.reflect.Type;
import org.apache.skywalking.apm.agent.core.plugin.AbstractClassEnhancePluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.EnhanceContext;
import org.apache.skywalking.apm.agent.core.plugin.PluginException;
import org.apache.skywalking.apm.agent.core.plugin.bootstrap.BootstrapInstrumentBoost;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.ConstructorInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.EnhanceException;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.InstanceMethodsInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.StaticMethodsInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.ConstructorInter;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.OverrideCallable;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstMethodsInterV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstMethodsInterV2WithOverrideArgs;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.StaticMethodsInterV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.StaticMethodsInterV2WithOverrideArgs;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.v2.DeclaredInstanceMethodsInterceptV2Point;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.v2.InstanceMethodsInterceptV2Point;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.v2.StaticMethodsInterceptV2Point;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.dynamic.DynamicType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.FieldAccessor;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.MethodDelegation;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.SuperMethodCall;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Morph;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.skywalking.apm.util.StringUtil;

public abstract class ClassEnhancePluginDefineV2
extends AbstractClassEnhancePluginDefine {
    @Override
    protected DynamicType.Builder<?> enhanceClass(TypeDescription typeDescription, DynamicType.Builder<?> newClassBuilder, ClassLoader classLoader) throws PluginException {
        StaticMethodsInterceptV2Point[] staticMethodsInterceptV2Points = this.getStaticMethodsInterceptV2Points();
        String enhanceOriginClassName = typeDescription.getTypeName();
        if (staticMethodsInterceptV2Points == null || staticMethodsInterceptV2Points.length == 0) {
            return newClassBuilder;
        }
        for (StaticMethodsInterceptV2Point staticMethodsInterceptV2Point : staticMethodsInterceptV2Points) {
            String interceptor = staticMethodsInterceptV2Point.getMethodsInterceptorV2();
            if (StringUtil.isEmpty(interceptor)) {
                throw new EnhanceException("no StaticMethodsAroundInterceptorV2 define to enhance class " + enhanceOriginClassName);
            }
            if (staticMethodsInterceptV2Point.isOverrideArgs()) {
                if (this.isBootstrapInstrumentation()) {
                    newClassBuilder = newClassBuilder.method(ElementMatchers.isStatic().and(staticMethodsInterceptV2Point.getMethodsMatcher())).intercept(MethodDelegation.withDefaultConfiguration().withBinders(Morph.Binder.install(OverrideCallable.class)).to(BootstrapInstrumentBoost.forInternalDelegateClass(interceptor)));
                    continue;
                }
                newClassBuilder = newClassBuilder.method(ElementMatchers.isStatic().and(staticMethodsInterceptV2Point.getMethodsMatcher())).intercept(MethodDelegation.withDefaultConfiguration().withBinders(Morph.Binder.install(OverrideCallable.class)).to(new StaticMethodsInterV2WithOverrideArgs(interceptor)));
                continue;
            }
            newClassBuilder = this.isBootstrapInstrumentation() ? newClassBuilder.method(ElementMatchers.isStatic().and(staticMethodsInterceptV2Point.getMethodsMatcher())).intercept(MethodDelegation.withDefaultConfiguration().to(BootstrapInstrumentBoost.forInternalDelegateClass(interceptor))) : newClassBuilder.method(ElementMatchers.isStatic().and(staticMethodsInterceptV2Point.getMethodsMatcher())).intercept(MethodDelegation.withDefaultConfiguration().to(new StaticMethodsInterV2(interceptor)));
        }
        return newClassBuilder;
    }

    @Override
    protected DynamicType.Builder<?> enhanceInstance(TypeDescription typeDescription, DynamicType.Builder<?> newClassBuilder, ClassLoader classLoader, EnhanceContext context) throws PluginException {
        ConstructorInterceptPoint[] constructorInterceptPoints = this.getConstructorsInterceptPoints();
        InstanceMethodsInterceptV2Point[] instanceMethodsInterceptV2Points = this.getInstanceMethodsInterceptV2Points();
        String enhanceOriginClassName = typeDescription.getTypeName();
        boolean existedConstructorInterceptPoint = false;
        if (constructorInterceptPoints != null && constructorInterceptPoints.length > 0) {
            existedConstructorInterceptPoint = true;
        }
        boolean existedMethodsInterceptV2Points = false;
        if (instanceMethodsInterceptV2Points != null && instanceMethodsInterceptV2Points.length > 0) {
            existedMethodsInterceptV2Points = true;
        }
        if (!existedConstructorInterceptPoint && !existedMethodsInterceptV2Points) {
            return newClassBuilder;
        }
        if (!typeDescription.isAssignableTo(EnhancedInstance.class) && !context.isObjectExtended()) {
            newClassBuilder = newClassBuilder.defineField("_$EnhancedClassField_ws", (Type)((Object)Object.class), 66).implement(new Type[]{EnhancedInstance.class}).intercept(FieldAccessor.ofField("_$EnhancedClassField_ws"));
            context.extendObjectCompleted();
        }
        if (existedConstructorInterceptPoint) {
            for (ConstructorInterceptPoint constructorInterceptPoint : constructorInterceptPoints) {
                newClassBuilder = this.isBootstrapInstrumentation() ? newClassBuilder.constructor(constructorInterceptPoint.getConstructorMatcher()).intercept(SuperMethodCall.INSTANCE.andThen(MethodDelegation.withDefaultConfiguration().to(BootstrapInstrumentBoost.forInternalDelegateClass(constructorInterceptPoint.getConstructorInterceptor())))) : newClassBuilder.constructor(constructorInterceptPoint.getConstructorMatcher()).intercept(SuperMethodCall.INSTANCE.andThen(MethodDelegation.withDefaultConfiguration().to(new ConstructorInter(constructorInterceptPoint.getConstructorInterceptor(), classLoader))));
            }
        }
        if (existedMethodsInterceptV2Points) {
            for (InstanceMethodsInterceptV2Point instanceMethodsInterceptV2Point : instanceMethodsInterceptV2Points) {
                String interceptor = instanceMethodsInterceptV2Point.getMethodsInterceptorV2();
                if (StringUtil.isEmpty(interceptor)) {
                    throw new EnhanceException("no InstanceMethodsAroundInterceptorV2 define to enhance class " + enhanceOriginClassName);
                }
                ElementMatcher.Junction<MethodDescription> junction = ElementMatchers.not(ElementMatchers.isStatic()).and(instanceMethodsInterceptV2Point.getMethodsMatcher());
                if (instanceMethodsInterceptV2Point instanceof DeclaredInstanceMethodsInterceptV2Point) {
                    junction = junction.and(ElementMatchers.isDeclaredBy(typeDescription));
                }
                if (instanceMethodsInterceptV2Point.isOverrideArgs()) {
                    if (this.isBootstrapInstrumentation()) {
                        newClassBuilder = newClassBuilder.method(junction).intercept(MethodDelegation.withDefaultConfiguration().withBinders(Morph.Binder.install(OverrideCallable.class)).to(BootstrapInstrumentBoost.forInternalDelegateClass(interceptor)));
                        continue;
                    }
                    newClassBuilder = newClassBuilder.method(junction).intercept(MethodDelegation.withDefaultConfiguration().withBinders(Morph.Binder.install(OverrideCallable.class)).to(new InstMethodsInterV2WithOverrideArgs(interceptor, classLoader)));
                    continue;
                }
                newClassBuilder = this.isBootstrapInstrumentation() ? newClassBuilder.method(junction).intercept(MethodDelegation.withDefaultConfiguration().to(BootstrapInstrumentBoost.forInternalDelegateClass(interceptor))) : newClassBuilder.method(junction).intercept(MethodDelegation.withDefaultConfiguration().to(new InstMethodsInterV2(interceptor, classLoader)));
            }
        }
        return newClassBuilder;
    }

    @Override
    public InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return null;
    }

    @Override
    public StaticMethodsInterceptPoint[] getStaticMethodsInterceptPoints() {
        return null;
    }
}

