/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.dynamic.watcher.SpanLimitWatcher;
import org.apache.skywalking.apm.agent.core.context.AbstractTracerContext;
import org.apache.skywalking.apm.agent.core.context.AsyncSpan;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.CorrelationContext;
import org.apache.skywalking.apm.agent.core.context.ExtensionContext;
import org.apache.skywalking.apm.agent.core.context.TracingContextListener;
import org.apache.skywalking.apm.agent.core.context.TracingThreadListener;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.ids.PropagatedTraceId;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractTracingSpan;
import org.apache.skywalking.apm.agent.core.context.trace.EntrySpan;
import org.apache.skywalking.apm.agent.core.context.trace.ExitSpan;
import org.apache.skywalking.apm.agent.core.context.trace.ExitTypeSpan;
import org.apache.skywalking.apm.agent.core.context.trace.LocalSpan;
import org.apache.skywalking.apm.agent.core.context.trace.NoopExitSpan;
import org.apache.skywalking.apm.agent.core.context.trace.NoopSpan;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegment;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegmentRef;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.profile.ProfileStatusReference;
import org.apache.skywalking.apm.agent.core.profile.ProfileTaskExecutionService;
import org.apache.skywalking.apm.util.StringUtil;

public class TracingContext
implements AbstractTracerContext {
    private static final ILog LOGGER = LogManager.getLogger(TracingContext.class);
    private long lastWarningTimestamp = 0L;
    private static ProfileTaskExecutionService PROFILE_TASK_EXECUTION_SERVICE;
    private TraceSegment segment;
    private LinkedList<AbstractSpan> activeSpanStack = new LinkedList();
    private PrimaryEndpoint primaryEndpoint = null;
    private int spanIdGenerator = 0;
    private volatile int asyncSpanCounter;
    private static final AtomicIntegerFieldUpdater<TracingContext> ASYNC_SPAN_COUNTER_UPDATER;
    private volatile boolean isRunningInAsyncMode = false;
    private volatile ReentrantLock asyncFinishLock;
    private volatile boolean running = true;
    private final long createTime;
    private final ProfileStatusReference profileStatus;
    private final CorrelationContext correlationContext;
    private final ExtensionContext extensionContext;
    private final SpanLimitWatcher spanLimitWatcher;

    TracingContext(String firstOPName, SpanLimitWatcher spanLimitWatcher) {
        this.segment = new TraceSegment();
        this.createTime = System.currentTimeMillis();
        if (PROFILE_TASK_EXECUTION_SERVICE == null) {
            PROFILE_TASK_EXECUTION_SERVICE = ServiceManager.INSTANCE.findService(ProfileTaskExecutionService.class);
        }
        this.profileStatus = PROFILE_TASK_EXECUTION_SERVICE.addProfiling(this, this.segment.getTraceSegmentId(), firstOPName);
        this.correlationContext = new CorrelationContext();
        this.extensionContext = new ExtensionContext();
        this.spanLimitWatcher = spanLimitWatcher;
    }

    @Override
    public void inject(ContextCarrier carrier) {
        this.inject(this.activeSpan(), carrier);
    }

    public void inject(AbstractSpan exitSpan, ContextCarrier carrier) {
        if (!exitSpan.isExit()) {
            throw new IllegalStateException("Inject can be done only in Exit Span");
        }
        ExitTypeSpan spanWithPeer = (ExitTypeSpan)((Object)exitSpan);
        String peer = spanWithPeer.getPeer();
        if (StringUtil.isEmpty(peer)) {
            throw new IllegalStateException("Exit span doesn't include meaningful peer information.");
        }
        carrier.setTraceId(this.getReadablePrimaryTraceId());
        carrier.setTraceSegmentId(this.segment.getTraceSegmentId());
        carrier.setSpanId(exitSpan.getSpanId());
        carrier.setParentService(Config.Agent.SERVICE_NAME);
        carrier.setParentServiceInstance(Config.Agent.INSTANCE_NAME);
        carrier.setParentEndpoint(this.primaryEndpoint.getName());
        carrier.setAddressUsedAtClient(peer);
        this.correlationContext.inject(carrier);
        this.extensionContext.inject(carrier);
    }

    @Override
    public void extract(ContextCarrier carrier) {
        TraceSegmentRef ref = new TraceSegmentRef(carrier);
        this.segment.ref(ref);
        this.segment.relatedGlobalTrace(new PropagatedTraceId(carrier.getTraceId()));
        AbstractSpan span = this.activeSpan();
        if (span instanceof EntrySpan) {
            span.ref(ref);
        }
        carrier.extractExtensionTo(this);
        carrier.extractCorrelationTo(this);
    }

    @Override
    public ContextSnapshot capture() {
        ContextSnapshot snapshot = new ContextSnapshot(this.segment.getTraceSegmentId(), this.activeSpan().getSpanId(), this.getPrimaryTraceId(), this.primaryEndpoint.getName(), this.correlationContext, this.extensionContext);
        return snapshot;
    }

    @Override
    public void continued(ContextSnapshot snapshot) {
        if (snapshot.isValid()) {
            TraceSegmentRef segmentRef = new TraceSegmentRef(snapshot);
            this.segment.ref(segmentRef);
            this.activeSpan().ref(segmentRef);
            this.segment.relatedGlobalTrace(snapshot.getTraceId());
            this.correlationContext.continued(snapshot);
            this.extensionContext.continued(snapshot);
            this.extensionContext.handle(this.activeSpan());
        }
    }

    @Override
    public String getReadablePrimaryTraceId() {
        return this.getPrimaryTraceId().getId();
    }

    private DistributedTraceId getPrimaryTraceId() {
        return this.segment.getRelatedGlobalTrace();
    }

    @Override
    public String getSegmentId() {
        return this.segment.getTraceSegmentId();
    }

    @Override
    public int getSpanId() {
        return this.activeSpan().getSpanId();
    }

    @Override
    public AbstractSpan createEntrySpan(String operationName) {
        int parentSpanId;
        if (this.isLimitMechanismWorking()) {
            NoopSpan span = new NoopSpan();
            return this.push(span);
        }
        TracingContext owner = this;
        AbstractSpan parentSpan = this.peek();
        int n = parentSpanId = parentSpan == null ? -1 : parentSpan.getSpanId();
        if (parentSpan != null && parentSpan.isEntry()) {
            this.profilingRecheck(parentSpan, operationName);
            parentSpan.setOperationName(operationName);
            AbstractSpan entrySpan = parentSpan;
            return entrySpan.start();
        }
        EntrySpan entrySpan = new EntrySpan(this.spanIdGenerator++, parentSpanId, operationName, owner);
        entrySpan.start();
        return this.push(entrySpan);
    }

    @Override
    public AbstractSpan createLocalSpan(String operationName) {
        if (this.isLimitMechanismWorking()) {
            NoopSpan span = new NoopSpan();
            return this.push(span);
        }
        AbstractSpan parentSpan = this.peek();
        int parentSpanId = parentSpan == null ? -1 : parentSpan.getSpanId();
        LocalSpan span = new LocalSpan(this.spanIdGenerator++, parentSpanId, operationName, this);
        span.start();
        return this.push(span);
    }

    @Override
    public AbstractSpan createExitSpan(String operationName, String remotePeer) {
        AbstractSpan exitSpan;
        if (this.isLimitMechanismWorking()) {
            NoopExitSpan span = new NoopExitSpan(remotePeer);
            return this.push(span);
        }
        AbstractSpan parentSpan = this.peek();
        TracingContext owner = this;
        if (parentSpan != null && parentSpan.isExit()) {
            exitSpan = parentSpan;
        } else {
            remotePeer = StringUtil.isEmpty(Config.Agent.CLUSTER) ? remotePeer : Config.Agent.CLUSTER + "/" + remotePeer;
            int parentSpanId = parentSpan == null ? -1 : parentSpan.getSpanId();
            exitSpan = new ExitSpan(this.spanIdGenerator++, parentSpanId, operationName, remotePeer, owner);
            this.push(exitSpan);
        }
        exitSpan.start();
        return exitSpan;
    }

    @Override
    public AbstractSpan activeSpan() {
        AbstractSpan span = this.peek();
        if (span == null) {
            throw new IllegalStateException("No active span.");
        }
        return span;
    }

    @Override
    public boolean stopSpan(AbstractSpan span) {
        AbstractSpan lastSpan = this.peek();
        if (lastSpan == span) {
            if (lastSpan instanceof AbstractTracingSpan) {
                AbstractTracingSpan toFinishSpan = (AbstractTracingSpan)lastSpan;
                if (toFinishSpan.finish(this.segment)) {
                    this.pop();
                }
            } else {
                this.pop();
            }
        } else {
            throw new IllegalStateException("Stopping the unexpected span = " + span);
        }
        this.finish();
        return this.activeSpanStack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractTracerContext awaitFinishAsync() {
        if (!this.isRunningInAsyncMode) {
            TracingContext tracingContext = this;
            synchronized (tracingContext) {
                if (!this.isRunningInAsyncMode) {
                    this.asyncFinishLock = new ReentrantLock();
                    ASYNC_SPAN_COUNTER_UPDATER.set(this, 0);
                    this.isRunningInAsyncMode = true;
                }
            }
        }
        ASYNC_SPAN_COUNTER_UPDATER.incrementAndGet(this);
        return this;
    }

    @Override
    public void asyncStop(AsyncSpan span) {
        ASYNC_SPAN_COUNTER_UPDATER.decrementAndGet(this);
        this.finish();
    }

    @Override
    public CorrelationContext getCorrelationContext() {
        return this.correlationContext;
    }

    @Override
    public String getPrimaryEndpointName() {
        return this.primaryEndpoint.getName();
    }

    public void profilingRecheck(AbstractSpan span, String operationName) {
        if (span.getSpanId() != 0) {
            return;
        }
        PROFILE_TASK_EXECUTION_SERVICE.profilingRecheck(this, this.segment.getTraceSegmentId(), operationName);
    }

    private void finish() {
        if (this.isRunningInAsyncMode) {
            this.asyncFinishLock.lock();
        }
        try {
            boolean isFinishedInMainThread;
            boolean bl = isFinishedInMainThread = this.activeSpanStack.isEmpty() && this.running;
            if (isFinishedInMainThread) {
                TracingThreadListenerManager.notifyFinish(this);
            }
            if (isFinishedInMainThread && (!this.isRunningInAsyncMode || this.asyncSpanCounter == 0)) {
                TraceSegment finishedSegment = this.segment.finish(this.isLimitMechanismWorking());
                ListenerManager.notifyFinish(finishedSegment);
                this.running = false;
            }
        }
        finally {
            if (this.isRunningInAsyncMode) {
                this.asyncFinishLock.unlock();
            }
        }
    }

    private AbstractSpan pop() {
        return this.activeSpanStack.removeLast();
    }

    private AbstractSpan push(AbstractSpan span) {
        if (this.primaryEndpoint == null) {
            this.primaryEndpoint = new PrimaryEndpoint(span);
        } else {
            this.primaryEndpoint.set(span);
        }
        this.activeSpanStack.addLast(span);
        this.extensionContext.handle(span);
        return span;
    }

    private AbstractSpan peek() {
        if (this.activeSpanStack.isEmpty()) {
            return null;
        }
        return this.activeSpanStack.getLast();
    }

    private boolean isLimitMechanismWorking() {
        if (this.spanIdGenerator >= this.spanLimitWatcher.getSpanLimit()) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - this.lastWarningTimestamp > 30000L) {
                LOGGER.warn(new RuntimeException("Shadow tracing context. Thread dump"), "More than {} spans required to create", this.spanLimitWatcher.getSpanLimit());
                this.lastWarningTimestamp = currentTimeMillis;
            }
            return true;
        }
        return false;
    }

    public long createTime() {
        return this.createTime;
    }

    public ProfileStatusReference profileStatus() {
        return this.profileStatus;
    }

    @Generated
    ExtensionContext getExtensionContext() {
        return this.extensionContext;
    }

    static {
        ASYNC_SPAN_COUNTER_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TracingContext.class, "asyncSpanCounter");
    }

    private class PrimaryEndpoint {
        private AbstractSpan span;

        private PrimaryEndpoint(AbstractSpan span) {
            this.span = span;
        }

        private void set(AbstractSpan span) {
            if (!this.span.isEntry() && span.isEntry()) {
                this.span = span;
            }
        }

        private String getName() {
            return this.span.getOperationName();
        }

        @Generated
        public AbstractSpan getSpan() {
            return this.span;
        }
    }

    public static class TracingThreadListenerManager {
        private static List<TracingThreadListener> LISTENERS = new LinkedList<TracingThreadListener>();

        public static synchronized void add(TracingThreadListener listener) {
            LISTENERS.add(listener);
        }

        static void notifyFinish(TracingContext finishedContext) {
            for (TracingThreadListener listener : LISTENERS) {
                listener.afterMainThreadFinish(finishedContext);
            }
        }

        public static synchronized void remove(TracingThreadListener listener) {
            LISTENERS.remove(listener);
        }
    }

    public static class ListenerManager {
        private static List<TracingContextListener> LISTENERS = new LinkedList<TracingContextListener>();

        public static synchronized void add(TracingContextListener listener) {
            LISTENERS.add(listener);
        }

        static void notifyFinish(TraceSegment finishedSegment) {
            for (TracingContextListener listener : LISTENERS) {
                listener.afterFinished(finishedSegment);
            }
        }

        public static synchronized void remove(TracingContextListener listener) {
            LISTENERS.remove(listener);
        }
    }
}

