/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.nats.client;

import io.nats.client.Message;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.nats.client.NatsCommons;

public class WriterQueueInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (NatsCommons.skipTrace(allArguments[0])) {
            return;
        }
        Message message = (Message)allArguments[0];
        EnhancedInstance enhancedMsg = (EnhancedInstance)allArguments[0];
        AbstractSpan span = ContextManager.createLocalSpan((String)("Nats/Pub/Enqueue/" + message.getSubject()));
        NatsCommons.addCommonTag(span, message);
        enhancedMsg.setSkyWalkingDynamicField((Object)ContextManager.capture());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (NatsCommons.skipTrace(allArguments[0])) {
            return ret;
        }
        AbstractSpan span = ContextManager.activeSpan();
        if (!((Boolean)ret).booleanValue()) {
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("enqueue", "failed");
            span.errorOccurred().log(System.currentTimeMillis(), eventMap);
        }
        ContextManager.stopSpan((AbstractSpan)span);
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan().errorOccurred().log(t);
        ContextManager.stopSpan((AbstractSpan)span);
    }
}

