/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.nats.client;

import io.nats.client.Message;
import io.nats.client.MessageHandler;
import java.util.Optional;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.IntegerTag;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.util.StringUtil;

public class NatsCommons {
    private static final String SID = "sid";
    private static final String REPLY_TO = "reply_to";
    private static final String MSG_STATE = "state";
    private static final String MSG = "message";

    static boolean skipTrace(Object msg) {
        if (!(msg instanceof Message)) {
            return true;
        }
        Message natsMsg = (Message)msg;
        return StringUtil.isBlank((String)natsMsg.getSubject()) || natsMsg.isStatusMessage();
    }

    static AbstractSpan createEntrySpan(Message message) {
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            if (!StringUtil.isNotEmpty((String)(next = next.next()).getHeadKey())) continue;
            next.setHeadValue(message.getHeaders().getFirst(next.getHeadKey()));
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)("Nats/Sub/" + message.getSubject()), (ContextCarrier)contextCarrier);
        NatsCommons.addCommonTag(span, message);
        return span;
    }

    static void injectCarrier(Message message) {
        ContextCarrier contextCarrier = new ContextCarrier();
        ContextManager.inject((ContextCarrier)contextCarrier);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            if (!StringUtil.isNotEmpty((String)(next = next.next()).getHeadKey()) || !StringUtil.isNotEmpty((String)next.getHeadValue())) continue;
            message.getHeaders().add(next.getHeadKey(), new String[]{next.getHeadValue()});
        }
    }

    static void addCommonTag(AbstractSpan span, Message message) {
        Optional.ofNullable(message.getReplyTo()).ifPresent(v -> span.tag((AbstractTag)new StringTag(REPLY_TO), v));
        Optional.ofNullable(message.getSID()).ifPresent(v -> span.tag((AbstractTag)new StringTag(SID), v));
        span.setComponent((Component)ComponentsDefine.NATS);
        SpanLayer.asMQ((AbstractSpan)span);
        if (message.getStatus() != null) {
            int code = message.getStatus().getCode();
            String statusMsg = message.getStatus().getMessage();
            span.tag((AbstractTag)new IntegerTag(MSG_STATE), String.valueOf(code));
            if (StringUtil.isNotBlank((String)statusMsg)) {
                span.tag((AbstractTag)new StringTag(MSG), statusMsg);
            }
            if (code != 0) {
                span.errorOccurred();
            }
        }
    }

    static MessageHandler buildTraceMsgHandler(MessageHandler msgHandler) {
        if (msgHandler == null) {
            return null;
        }
        return msg -> {
            if (NatsCommons.skipTrace(msg) || msg.getHeaders() == null) {
                msgHandler.onMessage(msg);
                return;
            }
            AbstractSpan span = NatsCommons.createEntrySpan(msg);
            try {
                msgHandler.onMessage(msg);
            }
            catch (Exception e) {
                span.log((Throwable)e).errorOccurred();
                throw e;
            }
            finally {
                ContextManager.stopSpan((AbstractSpan)span);
            }
        };
    }
}

