/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.shenyu.v24x;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import org.springframework.web.server.adapter.DefaultServerWebExchange;
import reactor.core.publisher.Mono;

public class GlobalPluginExecuteMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String SHENYU_AGENT_TRACE_ID = "shenyu-agent-trace-id";
    public static final String SKYWALKING_SPAN = "SKYWALKING_SPAN";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        ContextCarrier carrier = new ContextCarrier();
        CarrierItem next = carrier.items();
        HttpHeaders headers = exchange.getRequest().getHeaders();
        while (next.hasNext()) {
            List header = headers.get((Object)(next = next.next()).getHeadKey());
            if (header == null || header.size() <= 0) continue;
            next.setHeadValue((String)header.get(0));
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)exchange.getRequest().getURI().getPath(), (ContextCarrier)carrier);
        span.setComponent((Component)ComponentsDefine.APACHE_SHENYU);
        SpanLayer.asHttp((AbstractSpan)span);
        Tags.URL.set(span, exchange.getRequest().getURI().toString());
        Tags.HTTP.METHOD.set(span, exchange.getRequest().getMethodValue());
        ContextSnapshot snapshot = ContextManager.capture();
        exchange.getAttributes().put(SHENYU_AGENT_TRACE_ID, Optional.ofNullable(snapshot.getTraceId()).map(DistributedTraceId::getId).orElse(""));
        EnhancedInstance instance = GlobalPluginExecuteMethodInterceptor.getInstance(allArguments[0]);
        instance.setSkyWalkingDynamicField((Object)snapshot);
        span.prepareForAsync();
        ContextManager.stopSpan((AbstractSpan)span);
        exchange.getAttributes().put(SKYWALKING_SPAN, span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        AbstractSpan span = (AbstractSpan)exchange.getAttributes().get(SKYWALKING_SPAN);
        if (Objects.isNull(span)) {
            return ret;
        }
        Mono monoReturn = (Mono)ret;
        EnhancedInstance instance = GlobalPluginExecuteMethodInterceptor.getInstance(allArguments[0]);
        if (instance != null && instance.getSkyWalkingDynamicField() != null) {
            monoReturn = monoReturn.subscriberContext(c -> c.put((Object)"SKYWALKING_CONTEXT_SNAPSHOT", instance.getSkyWalkingDynamicField()));
        }
        return monoReturn.doOnError(throwable -> span.errorOccurred().log(throwable)).doFinally(s -> {
            try {
                Optional.ofNullable(exchange.getResponse().getStatusCode()).ifPresent(httpStatus -> {
                    Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(httpStatus.value()));
                    if (httpStatus.isError()) {
                        span.errorOccurred();
                    }
                });
            }
            finally {
                span.asyncFinish();
            }
        });
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    public static EnhancedInstance getInstance(Object o) {
        EnhancedInstance instance = null;
        if (o instanceof DefaultServerWebExchange) {
            instance = (EnhancedInstance)o;
        } else if (o instanceof ServerWebExchangeDecorator) {
            ServerWebExchange delegate = ((ServerWebExchangeDecorator)o).getDelegate();
            return GlobalPluginExecuteMethodInterceptor.getInstance(delegate);
        }
        return instance;
    }
}

