/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jedis.v4;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Optional;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jedis.v4.JedisPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.RawableFactory;
import redis.clients.jedis.commands.ProtocolCommand;

public abstract class AbstractConnectionInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String UNKNOWN = "UNKNOWN";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Iterator<Rawable> iterator = this.getCommands(allArguments);
        ProtocolCommand protocolCommand = null;
        if (iterator.hasNext()) {
            protocolCommand = (ProtocolCommand)iterator.next();
        }
        String cmd = protocolCommand == null ? UNKNOWN : protocolCommand.toString();
        String peer = String.valueOf(objInst.getSkyWalkingDynamicField());
        AbstractSpan span = ContextManager.createExitSpan((String)("Jedis/" + cmd), (String)peer);
        String params = this.readParamIfNecessary(iterator).map(arg -> cmd + " " + arg).orElse(cmd);
        Tags.DB_STATEMENT.set(span, params);
        span.setComponent((Component)ComponentsDefine.JEDIS);
        Tags.DB_TYPE.set(span, "Redis");
        SpanLayer.asCache((AbstractSpan)span);
    }

    private Optional<String> readParamIfNecessary(Iterator<Rawable> iterator) {
        Rawable rawable;
        if (JedisPluginConfig.Plugin.Jedis.TRACE_REDIS_PARAMETERS && iterator.hasNext() && (rawable = iterator.next()) instanceof RawableFactory.RawString) {
            String cut = StringUtil.cut((String)new String(rawable.getRaw()), (int)JedisPluginConfig.Plugin.Jedis.REDIS_PARAMETER_MAX_LENGTH);
            return Optional.of(cut);
        }
        return Optional.empty();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan().log(t).errorOccurred();
        ContextManager.stopSpan((AbstractSpan)span);
    }

    protected abstract Iterator<Rawable> getCommands(Object[] var1);
}

