/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.net.bytebuddy.utility;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.ClassFileVersion;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.build.AccessControllerPlugin;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.jar.asm.ClassReader;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenedClassReader {
    public static final String EXPERIMENTAL_PROPERTY = "org.apache.skywalking.apm.dependencies.net.bytebuddy.experimental";
    public static final boolean EXPERIMENTAL;
    public static final int ASM_API;
    private static final boolean ACCESS_CONTROLLER;

    private OpenedClassReader() {
        throw new UnsupportedOperationException("This class is a utility class and not supposed to be instantiated");
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    public static ClassReader of(byte[] binaryRepresentation) {
        if (EXPERIMENTAL) {
            ClassFileVersion latest;
            ClassFileVersion classFileVersion = ClassFileVersion.ofClassFile(binaryRepresentation);
            if (classFileVersion.isGreaterThan(latest = ClassFileVersion.latest())) {
                binaryRepresentation[6] = (byte)(latest.getMajorVersion() >>> 8);
                binaryRepresentation[7] = (byte)latest.getMajorVersion();
                ClassReader classReader = new ClassReader(binaryRepresentation);
                binaryRepresentation[6] = (byte)(classFileVersion.getMajorVersion() >>> 8);
                binaryRepresentation[7] = (byte)classFileVersion.getMajorVersion();
                return classReader;
            }
            return new ClassReader(binaryRepresentation);
        }
        return new ClassReader(binaryRepresentation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        boolean experimental;
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("org.apache.skywalking.apm.dependencies.net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        try {
            experimental = Boolean.parseBoolean(OpenedClassReader.doPrivileged(new GetSystemPropertyAction(EXPERIMENTAL_PROPERTY)));
        }
        catch (Exception ignored) {
            experimental = false;
        }
        EXPERIMENTAL = experimental;
        ASM_API = 589824;
    }
}

