/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdk.http;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.util.StringUtil;
import sun.net.www.MessageHeader;

public class HttpClientParseHttpInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        MessageHeader responseHeader = (MessageHeader)allArguments[0];
        String statusLine = responseHeader.getValue(0);
        Integer responseCode = this.parseResponseCode(statusLine);
        if (responseCode >= 400) {
            AbstractSpan span = ContextManager.activeSpan();
            span.errorOccurred();
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, responseCode);
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    private Integer parseResponseCode(String statusLine) {
        String[] results;
        if (!StringUtil.isEmpty((String)statusLine) && (results = statusLine.split(" ")).length >= 1) {
            try {
                return Integer.valueOf(results[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }
}

