/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.servicecomb.v2;

import java.lang.reflect.Method;
import java.net.URI;
import org.apache.servicecomb.core.Invocation;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class TransportClientHandlerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Invocation invocation = (Invocation)allArguments[0];
        if (!this.checkRegisterStatus(invocation).booleanValue()) {
            return;
        }
        URI uri = new URI(invocation.getEndpoint().toString());
        String peer = uri.getHost() + ":" + uri.getPort();
        String operationName = invocation.getMicroserviceQualifiedName();
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)peer);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            invocation.getContext().put(next.getHeadKey(), next.getHeadValue());
        }
        String url = invocation.getOperationMeta().getOperationPath();
        Tags.URL.set(span, url);
        span.setComponent((Component)ComponentsDefine.SERVICECOMB);
        SpanLayer.asRPCFramework((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Invocation invocation = (Invocation)allArguments[0];
        if (!this.checkRegisterStatus(invocation).booleanValue()) {
            return ret;
        }
        AbstractSpan span = ContextManager.activeSpan();
        int statusCode = invocation.getStatus().getStatusCode();
        if (statusCode >= 400) {
            span.errorOccurred();
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(statusCode));
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        Invocation invocation = (Invocation)allArguments[0];
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    private Boolean checkRegisterStatus(Invocation invocation) {
        return null != invocation.getOperationMeta() && null != invocation.getEndpoint();
    }
}

