/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.zookeeper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jute.Record;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.zookeeper.ZooOpt;
import org.apache.zookeeper.client.StaticHostProvider;
import org.apache.zookeeper.proto.RequestHeader;

public class ClientCnxnInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    private static final ILog LOGGER = LogManager.getLogger(ClientCnxnInterceptor.class);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String peer = (String)objInst.getSkyWalkingDynamicField();
        RequestHeader header = (RequestHeader)allArguments[0];
        String operationName = ZooOpt.getOperationName(header.getType());
        AbstractSpan span = ContextManager.createExitSpan((String)("Zookeeper/" + operationName), (String)peer);
        span.setComponent((Component)ComponentsDefine.ZOOKEEPER);
        Tags.DB_TYPE.set(span, "Zookeeper");
        ZooOpt.setTags(span, (Record)allArguments[2]);
        SpanLayer.asCache((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        StaticHostProvider hostProvider = (StaticHostProvider)allArguments[1];
        try {
            Field field = StaticHostProvider.class.getDeclaredField("serverAddresses");
            field.setAccessible(true);
            List serverAddresses = (List)field.get(hostProvider);
            ArrayList<String> addresses = new ArrayList<String>();
            for (InetSocketAddress address : serverAddresses) {
                addresses.add(address.getHostName() + ":" + address.getPort());
            }
            Collections.sort(addresses);
            StringBuilder peer = new StringBuilder();
            for (String address : addresses) {
                peer.append(address).append(";");
            }
            objInst.setSkyWalkingDynamicField((Object)peer.toString());
        }
        catch (NoSuchFieldException e) {
            LOGGER.warn("NoSuchFieldException, not be compatible with this version of zookeeper", new Object[]{e});
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("IllegalAccessException, not be compatible with this version of zookeeper", new Object[]{e});
        }
    }
}

