/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.trace.ignore;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.apm.agent.core.conf.dynamic.AgentConfigChangeWatcher;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.plugin.trace.ignore.TraceIgnoreExtendService;
import org.apache.skywalking.apm.plugin.trace.ignore.conf.IgnoreConfig;

public class TraceIgnorePatternWatcher
extends AgentConfigChangeWatcher {
    private static final ILog LOGGER = LogManager.getLogger(TraceIgnorePatternWatcher.class);
    private final AtomicReference<String> traceIgnorePathPatterns = new AtomicReference<String>(this.getDefaultValue());
    private final TraceIgnoreExtendService traceIgnoreExtendService;

    public TraceIgnorePatternWatcher(String propertyKey, TraceIgnoreExtendService traceIgnoreExtendService) {
        super(propertyKey);
        this.traceIgnoreExtendService = traceIgnoreExtendService;
    }

    private void activeSetting(String config) {
        if (LOGGER.isDebugEnable()) {
            LOGGER.debug("Updating using new static config: {}", new Object[]{config});
        }
        this.traceIgnorePathPatterns.set(config);
        this.traceIgnoreExtendService.handleTraceIgnorePatternsChanged();
    }

    public void notify(AgentConfigChangeWatcher.ConfigChangeEvent value) {
        if (AgentConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.activeSetting(this.getDefaultValue());
        } else {
            this.activeSetting(value.getNewValue());
        }
    }

    public String value() {
        return this.traceIgnorePathPatterns.get();
    }

    private String getDefaultValue() {
        return IgnoreConfig.Trace.IGNORE_PATH;
    }

    public String getTraceIgnorePathPatterns() {
        return this.traceIgnorePathPatterns.get();
    }
}

