/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.ConfigNotFoundException;
import org.apache.skywalking.apm.agent.core.conf.Constants;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.logging.core.JsonLogResolver;
import org.apache.skywalking.apm.agent.core.logging.core.PatternLogResolver;
import org.apache.skywalking.apm.util.ConfigInitializer;
import org.apache.skywalking.apm.util.PropertyPlaceholderHelper;
import org.apache.skywalking.apm.util.StringUtil;

public class SnifferConfigInitializer {
    private static ILog LOGGER = LogManager.getLogger(SnifferConfigInitializer.class);
    private static final String SPECIFIED_CONFIG_PATH = "skywalking_config";
    private static final String DEFAULT_CONFIG_FILE_NAME = "/config/agent.config";
    private static final String ENV_KEY_PREFIX = "skywalking.";
    private static Properties AGENT_SETTINGS;
    private static boolean IS_INIT_COMPLETED;

    public static void initializeCoreConfig(String agentOptions) {
        AGENT_SETTINGS = new Properties();
        try (InputStreamReader configFileStream = SnifferConfigInitializer.loadConfig();){
            AGENT_SETTINGS.load(configFileStream);
            for (String key : AGENT_SETTINGS.stringPropertyNames()) {
                String value = (String)AGENT_SETTINGS.get(key);
                AGENT_SETTINGS.put(key, PropertyPlaceholderHelper.INSTANCE.replacePlaceholders(value, AGENT_SETTINGS));
            }
        }
        catch (Exception e) {
            LOGGER.error(e, "Failed to read the config file, skywalking is going to run in default config.", new Object[0]);
        }
        try {
            SnifferConfigInitializer.overrideConfigBySystemProp();
        }
        catch (Exception e) {
            LOGGER.error(e, "Failed to read the system properties.", new Object[0]);
        }
        agentOptions = StringUtil.trim(agentOptions, ',');
        if (!StringUtil.isEmpty(agentOptions)) {
            try {
                agentOptions = agentOptions.trim();
                LOGGER.info("Agent options is {}.", agentOptions);
                SnifferConfigInitializer.overrideConfigByAgentOptions(agentOptions);
            }
            catch (Exception e) {
                LOGGER.error(e, "Failed to parse the agent options, val is {}.", agentOptions);
            }
        }
        SnifferConfigInitializer.initializeConfig(Config.class);
        SnifferConfigInitializer.configureLogger();
        LOGGER = LogManager.getLogger(SnifferConfigInitializer.class);
        if (StringUtil.isEmpty(Config.Agent.SERVICE_NAME)) {
            throw new ExceptionInInitializerError("`agent.service_name` is missing.");
        }
        if (StringUtil.isNotEmpty(Config.Agent.NAMESPACE) || StringUtil.isNotEmpty(Config.Agent.CLUSTER)) {
            Config.Agent.SERVICE_NAME = StringUtil.join(Constants.SERVICE_NAME_PART_CONNECTOR, Config.Agent.SERVICE_NAME, Config.Agent.NAMESPACE, Config.Agent.CLUSTER);
        }
        if (StringUtil.isEmpty(Config.Collector.BACKEND_SERVICE)) {
            throw new ExceptionInInitializerError("`collector.backend_service` is missing.");
        }
        if (Config.Plugin.PEER_MAX_LENGTH <= 3) {
            LOGGER.warn("PEER_MAX_LENGTH configuration:{} error, the default value of 200 will be used.", Config.Plugin.PEER_MAX_LENGTH);
            Config.Plugin.PEER_MAX_LENGTH = 200;
        }
        IS_INIT_COMPLETED = true;
    }

    public static void initializeConfig(Class configClass) {
        if (AGENT_SETTINGS == null) {
            LOGGER.error("Plugin configs have to be initialized after core config initialization.");
            return;
        }
        try {
            ConfigInitializer.initialize(AGENT_SETTINGS, configClass);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e, "Failed to set the agent settings {} to Config={} ", AGENT_SETTINGS, configClass);
        }
    }

    private static void overrideConfigByAgentOptions(String agentOptions) throws IllegalArgumentException {
        for (List<String> terms : SnifferConfigInitializer.parseAgentOptions(agentOptions)) {
            if (terms.size() != 2) {
                throw new IllegalArgumentException("[" + terms + "] is not a key-value pair.");
            }
            AGENT_SETTINGS.put(terms.get(0), terms.get(1));
        }
    }

    private static List<List<String>> parseAgentOptions(String agentOptions) {
        ArrayList<List<String>> options = new ArrayList<List<String>>();
        ArrayList<String> terms = new ArrayList<String>();
        boolean isInQuotes = false;
        StringBuilder currentTerm = new StringBuilder();
        for (char c : agentOptions.toCharArray()) {
            if (c == '\'' || c == '\"') {
                isInQuotes = !isInQuotes;
                continue;
            }
            if (c == '=' && !isInQuotes) {
                terms.add(currentTerm.toString());
                currentTerm = new StringBuilder();
                continue;
            }
            if (c == ',' && !isInQuotes) {
                terms.add(currentTerm.toString());
                currentTerm = new StringBuilder();
                options.add(terms);
                terms = new ArrayList();
                continue;
            }
            currentTerm.append(c);
        }
        terms.add(currentTerm.toString());
        options.add(terms);
        return options;
    }

    public static boolean isInitCompleted() {
        return IS_INIT_COMPLETED;
    }

    private static void overrideConfigBySystemProp() throws IllegalAccessException {
        Properties systemProperties = System.getProperties();
        for (Map.Entry<Object, Object> prop : systemProperties.entrySet()) {
            String key = prop.getKey().toString();
            if (!key.startsWith(ENV_KEY_PREFIX)) continue;
            String realKey = key.substring(ENV_KEY_PREFIX.length());
            AGENT_SETTINGS.put(realKey, prop.getValue());
        }
    }

    private static InputStreamReader loadConfig() throws AgentPackageNotFoundException, ConfigNotFoundException {
        File configFile;
        String specifiedConfigPath = System.getProperty(SPECIFIED_CONFIG_PATH);
        File file = configFile = StringUtil.isEmpty(specifiedConfigPath) ? new File(AgentPackagePath.getPath(), DEFAULT_CONFIG_FILE_NAME) : new File(specifiedConfigPath);
        if (configFile.exists() && configFile.isFile()) {
            try {
                LOGGER.info("Config file found in {}.", configFile);
                return new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                throw new ConfigNotFoundException("Failed to load agent.config", e);
            }
        }
        throw new ConfigNotFoundException("Failed to load agent.config.");
    }

    static void configureLogger() {
        switch (Config.Logging.RESOLVER) {
            case JSON: {
                LogManager.setLogResolver(new JsonLogResolver());
                break;
            }
            default: {
                LogManager.setLogResolver(new PatternLogResolver());
            }
        }
    }

    static {
        IS_INIT_COMPLETED = false;
    }
}

