/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.kafka;

import java.util.List;
import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.kafka.KafkaConnectionStatus;
import org.apache.skywalking.apm.agent.core.kafka.KafkaConnectionStatusListener;
import org.apache.skywalking.apm.agent.core.kafka.KafkaProducerManager;
import org.apache.skywalking.apm.agent.core.kafka.KafkaReporterPluginConfig;
import org.apache.skywalking.apm.agent.core.remote.LogReportServiceClient;
import org.apache.skywalking.apm.agent.core.util.CollectionUtil;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.logging.v3.LogData;

@OverrideImplementor(value=LogReportServiceClient.class)
public class KafkaLogReporterServiceClient
extends LogReportServiceClient
implements KafkaConnectionStatusListener {
    private String topic;
    private KafkaProducer<String, Bytes> producer;

    public void prepare() {
        KafkaProducerManager producerManager = (KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class);
        producerManager.addListener(this);
        this.topic = producerManager.formatTopicNameThenRegister(KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_LOGGING);
    }

    public void produce(LogData logData) {
        super.produce(logData);
    }

    public void consume(List<LogData> dataList) {
        if (this.producer == null || CollectionUtil.isEmpty(dataList)) {
            return;
        }
        for (LogData data : dataList) {
            this.producer.send(new ProducerRecord<String, Bytes>(this.topic, data.getService(), Bytes.wrap(data.toByteArray())));
        }
    }

    @Override
    public void onStatusChanged(KafkaConnectionStatus status) {
        if (status == KafkaConnectionStatus.CONNECTED) {
            this.producer = ((KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class)).getProducer();
        }
    }
}

