/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.play.v2x;

import akka.stream.Materializer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import play.api.routing.HandlerDef;
import play.mvc.Filter;
import play.mvc.Http;
import play.mvc.Result;
import play.routing.Router;

@Singleton
public class TracingFilter
extends Filter {
    private final Pattern routePattern = Pattern.compile("\\$(\\w+)\\<\\[\\^/\\]\\+\\>", 32);

    @Inject
    public TracingFilter(Materializer mat) {
        super(mat);
    }

    public CompletionStage<Result> apply(Function<Http.RequestHeader, CompletionStage<Result>> next, Http.RequestHeader request) {
        HandlerDef def = null;
        try {
            def = (HandlerDef)request.attrs().get(Router.Attrs.HANDLER_DEF);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Objects.nonNull(def)) {
            ContextCarrier carrier = new ContextCarrier();
            CarrierItem items = carrier.items();
            while (items.hasNext()) {
                items = items.next();
                Optional value = request.getHeaders().get(items.getHeadKey());
                if (!value.isPresent()) continue;
                items.setHeadValue((String)value.get());
            }
            String operationName = this.routePattern.matcher(def.path()).replaceAll("{$1}");
            AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)carrier);
            String url = request.host() + request.uri();
            Tags.URL.set(span, url);
            Tags.HTTP.METHOD.set(span, request.method());
            span.setComponent((Component)ComponentsDefine.PLAY);
            SpanLayer.asHttp((AbstractSpan)span);
            span.prepareForAsync();
            CompletionStage<Result> stage = next.apply(request).thenApply(result -> {
                if (result.status() >= 400) {
                    span.errorOccurred();
                    Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(result.status()));
                }
                try {
                    span.asyncFinish();
                }
                catch (Throwable t) {
                    ContextManager.activeSpan().log(t);
                }
                return result;
            });
            ContextManager.stopSpan((AbstractSpan)span);
            return stage;
        }
        return next.apply(request);
    }
}

