/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.fastjson;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ToJavaObjectInterceptor
implements StaticMethodsAroundInterceptor {
    public static final String OPERATION_NAME_TO_JSON = "Fastjson/";
    public static final String SPAN_TAG_KEY_OBJECT = "object";

    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
        AbstractSpan span = ContextManager.createLocalSpan((String)(OPERATION_NAME_TO_JSON + method.getName()));
        span.setComponent((Component)ComponentsDefine.FASTJSON);
        if (allArguments.length > 1 && allArguments[1] instanceof Class) {
            span.tag(Tags.ofKey((String)SPAN_TAG_KEY_OBJECT), ((Class)allArguments[1]).getTypeName());
        }
    }

    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

