/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.druid.v1;

import com.alibaba.druid.pool.DruidDataSourceMBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLParser;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class PoolingAddDruidDataSourceInterceptor
implements StaticMethodsAroundInterceptor {
    private static final String METER_NAME = "datasource";

    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
    }

    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        DruidDataSourceMBean druidDataSource = (DruidDataSourceMBean)allArguments[0];
        ConnectionInfo connectionInfo = URLParser.parser((String)druidDataSource.getUrl());
        String tagValue = connectionInfo.getDatabaseName() + "_" + connectionInfo.getDatabasePeer();
        Map<String, Function<DruidDataSourceMBean, Supplier<Double>>> metricMap = this.getMetrics();
        metricMap.forEach((key, value) -> ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, (Supplier)((Supplier)value.apply(druidDataSource))).tag("name", tagValue)).tag("status", key)).build());
        return ret;
    }

    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
    }

    private Map<String, Function<DruidDataSourceMBean, Supplier<Double>>> getMetrics() {
        HashMap<String, Function<DruidDataSourceMBean, Supplier<Double>>> metricMap = new HashMap<String, Function<DruidDataSourceMBean, Supplier<Double>>>();
        metricMap.put("activeCount", druidDataSource -> () -> druidDataSource.getActiveCount());
        metricMap.put("poolingCount", druidDataSource -> () -> druidDataSource.getPoolingCount());
        metricMap.put("idleCount", druidDataSource -> () -> druidDataSource.getPoolingCount() - druidDataSource.getActiveCount());
        metricMap.put("lockQueueLength", druidDataSource -> () -> druidDataSource.getLockQueueLength());
        metricMap.put("maxWaitThreadCount", druidDataSource -> () -> druidDataSource.getMaxWaitThreadCount());
        metricMap.put("commitCount", druidDataSource -> () -> druidDataSource.getCommitCount());
        metricMap.put("connectCount", druidDataSource -> () -> druidDataSource.getConnectCount());
        metricMap.put("connectError", druidDataSource -> () -> druidDataSource.getConnectErrorCount());
        metricMap.put("createError", druidDataSource -> () -> druidDataSource.getCreateErrorCount());
        return metricMap;
    }
}

