# Get Binaries

This page shows how to get binaries of Banyand.

## Prebuilt Released binaries

Get binaries from the [download](https://skywalking.apache.org/downloads/).

## Build From Source

### Requirements

Users who want to build a binary from sources have to set up:

* Go 1.22
* Node 20.12
* Git >= 2.30
* Linux, macOS or Windows+WSL2
* GNU make

### Windows

BanyanDB is built on Linux and macOS that introduced several platform-specific characters to the building system. Therefore, we highly recommend you use [WSL2+Ubuntu](https://ubuntu.com/desktop/wsl) to execute tasks of the Makefile.

### Build Binaries

To issue the below command to get basic binaries of banyand and bydbctl.

```shell
$ make generate
...
$ make build
...
--- banyand: all ---
make[1]: Entering directory '<path_to_project_root>/banyand'
...
chmod +x build/bin/banyand-server
Done building banyand server
make[1]: Leaving directory '<path_to_project_root>/banyand'
...
--- bydbctl: all ---
make[1]: Entering directory '<path_to_project_root>/bydbctl'
...
chmod +x build/bin/bydbctl
Done building bydbctl
make[1]: Leaving directory '<path_to_project_root>/bydbctl'
```

The build system provides a series of binary options as well.

* `make -C banyand banyand-server` generates a basic `banyand-server`.
* `make -C banyand release` or `make -C banyand banyand-server-static` builds out a static binary `banyand-server-static` for releasing.
* `make -C banyand debug` gives a binary for debugging without the complier's optimizations.
* `make -C banyand debug-static` is a static binary for debugging.
* `make -C bydbctl release` cross-builds several binaries for multi-platforms.

Then users get binaries as below

``` shell
$ ls banyand/build/bin
banyand-server  
banyand-server-static
banyand-server-debug  
banyand-server-debug-static  

$ ls bydbctl/build/bin
bydbctl  bydbctl--darwin-amd64  bydbctl--darwin-arm64  bydbctl--linux-386  bydbctl--linux-amd64  bydbctl--linux-arm64  bydbctl--windows-386  bydbctl--windows-amd64
```

> The build script now checks if the binary file exists before rebuilding. If you want to rebuild, please remove the binary file manually.
