# BanyanDB

![](https://github.com/apache/skywalking-banyandb/workflows/Build/badge.svg?branch=main)

![](./assets/banyandb_small.jpg)

BanyanDB, as an observability database, aims to ingest, analyze and store Metrics, Tracing and Logging data.
It's designed to handle observability data generated by observability platform and APM system, like [Apache SkyWalking](https://github.com/apache/skywalking) etc.

## Introduction

BanyanDB, as an observability database, aims to ingest, analyze and store Metrics, Tracing, and Logging data. It's designed to handle observability data generated by Apache SkyWalking. Before BanyanDB emerges, the Databases that SkyWalking adopted are not ideal for the APM data model, especially for saving tracing and logging data. Consequently, There’s room to improve the performance and resource usage based on the nature of SkyWalking data patterns.

The database research community usually uses [RUM conjecture](http://daslab.seas.harvard.edu/rum-conjecture/) to describe how a database access data. BanyanDB combines several access methods to build a comprehensive APM database to balance read cost, update cost, and memory overhead.

## Documents

[Documents](https://skywalking.apache.org/docs/skywalking-banyandb/next/readme/)

## RoadMap

### Client manager

- [x] gRPC server
- [x] HTTP server

### Distributed manager (v1.0.0)

- [ ] Sharding
- [ ] Replication and consistency model
- [ ] Load balance
- [ ] Distributed query optimizer
- [ ] Node discovery
- [ ] Data queue

### Data processor

- [x] Schema management
- [x] Time-series abstract layer
- [x] Stream data processor
- [x] Measure data processor
- [x] Property data processor
- [x] TopNAggregation processor
- [x] Index processor
- [x] TTL
- [x] Cold data processor
- [ ] WAL (v0.5.0)

### Query processor

- [x] Stream query processor
- [x] Measure query processor
- [x] Index reader
- [x] Streaming pipeline processor(OR and nested querying)
- [ ] Parallel executor
- [ ] Cost-based optimizer

### Verification

- [x] E2E with OAP and simulated data
- [x] E2E with showcases, agents and OAP
- [x] Space utilization rate
- [ ] Leading and trailing zero (v0.5.0)
- [ ] Stability (v0.5.0)
- [ ] Crash recovery (v0.5.0)
- [ ] Performance

### Tools

- [x] Command-line
- [x] Webapp

## Contributing

For developers who want to contribute to this project, see the [Contribution Guide](CONTRIBUTING.md).

## License

[Apache 2.0 License.](/LICENSE)
