// Licensed to Apache Software Foundation (ASF) under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Apache Software Foundation (ASF) licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        (unknown)
// source: banyandb/database/v1/schema.proto

package v1

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"

	v1 "github.com/apache/skywalking-banyandb/api/proto/banyandb/common/v1"
	v11 "github.com/apache/skywalking-banyandb/api/proto/banyandb/model/v1"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TagType int32

const (
	TagType_TAG_TYPE_UNSPECIFIED  TagType = 0
	TagType_TAG_TYPE_STRING       TagType = 1
	TagType_TAG_TYPE_INT          TagType = 2
	TagType_TAG_TYPE_STRING_ARRAY TagType = 3
	TagType_TAG_TYPE_INT_ARRAY    TagType = 4
	TagType_TAG_TYPE_DATA_BINARY  TagType = 5
	TagType_TAG_TYPE_ID           TagType = 6
)

// Enum value maps for TagType.
var (
	TagType_name = map[int32]string{
		0: "TAG_TYPE_UNSPECIFIED",
		1: "TAG_TYPE_STRING",
		2: "TAG_TYPE_INT",
		3: "TAG_TYPE_STRING_ARRAY",
		4: "TAG_TYPE_INT_ARRAY",
		5: "TAG_TYPE_DATA_BINARY",
		6: "TAG_TYPE_ID",
	}
	TagType_value = map[string]int32{
		"TAG_TYPE_UNSPECIFIED":  0,
		"TAG_TYPE_STRING":       1,
		"TAG_TYPE_INT":          2,
		"TAG_TYPE_STRING_ARRAY": 3,
		"TAG_TYPE_INT_ARRAY":    4,
		"TAG_TYPE_DATA_BINARY":  5,
		"TAG_TYPE_ID":           6,
	}
)

func (x TagType) Enum() *TagType {
	p := new(TagType)
	*p = x
	return p
}

func (x TagType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TagType) Descriptor() protoreflect.EnumDescriptor {
	return file_banyandb_database_v1_schema_proto_enumTypes[0].Descriptor()
}

func (TagType) Type() protoreflect.EnumType {
	return &file_banyandb_database_v1_schema_proto_enumTypes[0]
}

func (x TagType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TagType.Descriptor instead.
func (TagType) EnumDescriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{0}
}

type FieldType int32

const (
	FieldType_FIELD_TYPE_UNSPECIFIED FieldType = 0
	FieldType_FIELD_TYPE_STRING      FieldType = 1
	FieldType_FIELD_TYPE_INT         FieldType = 2
	FieldType_FIELD_TYPE_DATA_BINARY FieldType = 3
)

// Enum value maps for FieldType.
var (
	FieldType_name = map[int32]string{
		0: "FIELD_TYPE_UNSPECIFIED",
		1: "FIELD_TYPE_STRING",
		2: "FIELD_TYPE_INT",
		3: "FIELD_TYPE_DATA_BINARY",
	}
	FieldType_value = map[string]int32{
		"FIELD_TYPE_UNSPECIFIED": 0,
		"FIELD_TYPE_STRING":      1,
		"FIELD_TYPE_INT":         2,
		"FIELD_TYPE_DATA_BINARY": 3,
	}
)

func (x FieldType) Enum() *FieldType {
	p := new(FieldType)
	*p = x
	return p
}

func (x FieldType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldType) Descriptor() protoreflect.EnumDescriptor {
	return file_banyandb_database_v1_schema_proto_enumTypes[1].Descriptor()
}

func (FieldType) Type() protoreflect.EnumType {
	return &file_banyandb_database_v1_schema_proto_enumTypes[1]
}

func (x FieldType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldType.Descriptor instead.
func (FieldType) EnumDescriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{1}
}

type EncodingMethod int32

const (
	EncodingMethod_ENCODING_METHOD_UNSPECIFIED EncodingMethod = 0
	EncodingMethod_ENCODING_METHOD_GORILLA     EncodingMethod = 1
)

// Enum value maps for EncodingMethod.
var (
	EncodingMethod_name = map[int32]string{
		0: "ENCODING_METHOD_UNSPECIFIED",
		1: "ENCODING_METHOD_GORILLA",
	}
	EncodingMethod_value = map[string]int32{
		"ENCODING_METHOD_UNSPECIFIED": 0,
		"ENCODING_METHOD_GORILLA":     1,
	}
)

func (x EncodingMethod) Enum() *EncodingMethod {
	p := new(EncodingMethod)
	*p = x
	return p
}

func (x EncodingMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncodingMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_banyandb_database_v1_schema_proto_enumTypes[2].Descriptor()
}

func (EncodingMethod) Type() protoreflect.EnumType {
	return &file_banyandb_database_v1_schema_proto_enumTypes[2]
}

func (x EncodingMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncodingMethod.Descriptor instead.
func (EncodingMethod) EnumDescriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{2}
}

type CompressionMethod int32

const (
	CompressionMethod_COMPRESSION_METHOD_UNSPECIFIED CompressionMethod = 0
	CompressionMethod_COMPRESSION_METHOD_ZSTD        CompressionMethod = 1
)

// Enum value maps for CompressionMethod.
var (
	CompressionMethod_name = map[int32]string{
		0: "COMPRESSION_METHOD_UNSPECIFIED",
		1: "COMPRESSION_METHOD_ZSTD",
	}
	CompressionMethod_value = map[string]int32{
		"COMPRESSION_METHOD_UNSPECIFIED": 0,
		"COMPRESSION_METHOD_ZSTD":        1,
	}
)

func (x CompressionMethod) Enum() *CompressionMethod {
	p := new(CompressionMethod)
	*p = x
	return p
}

func (x CompressionMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompressionMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_banyandb_database_v1_schema_proto_enumTypes[3].Descriptor()
}

func (CompressionMethod) Type() protoreflect.EnumType {
	return &file_banyandb_database_v1_schema_proto_enumTypes[3]
}

func (x CompressionMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompressionMethod.Descriptor instead.
func (CompressionMethod) EnumDescriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{3}
}

// Type determine the index structure under the hood
type IndexRule_Type int32

const (
	IndexRule_TYPE_UNSPECIFIED IndexRule_Type = 0
	IndexRule_TYPE_TREE        IndexRule_Type = 1
	IndexRule_TYPE_INVERTED    IndexRule_Type = 2
)

// Enum value maps for IndexRule_Type.
var (
	IndexRule_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TYPE_TREE",
		2: "TYPE_INVERTED",
	}
	IndexRule_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"TYPE_TREE":        1,
		"TYPE_INVERTED":    2,
	}
)

func (x IndexRule_Type) Enum() *IndexRule_Type {
	p := new(IndexRule_Type)
	*p = x
	return p
}

func (x IndexRule_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexRule_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_banyandb_database_v1_schema_proto_enumTypes[4].Descriptor()
}

func (IndexRule_Type) Type() protoreflect.EnumType {
	return &file_banyandb_database_v1_schema_proto_enumTypes[4]
}

func (x IndexRule_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndexRule_Type.Descriptor instead.
func (IndexRule_Type) EnumDescriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{7, 0}
}

type IndexRule_Location int32

const (
	IndexRule_LOCATION_UNSPECIFIED IndexRule_Location = 0
	IndexRule_LOCATION_SERIES      IndexRule_Location = 1
	IndexRule_LOCATION_GLOBAL      IndexRule_Location = 2
)

// Enum value maps for IndexRule_Location.
var (
	IndexRule_Location_name = map[int32]string{
		0: "LOCATION_UNSPECIFIED",
		1: "LOCATION_SERIES",
		2: "LOCATION_GLOBAL",
	}
	IndexRule_Location_value = map[string]int32{
		"LOCATION_UNSPECIFIED": 0,
		"LOCATION_SERIES":      1,
		"LOCATION_GLOBAL":      2,
	}
)

func (x IndexRule_Location) Enum() *IndexRule_Location {
	p := new(IndexRule_Location)
	*p = x
	return p
}

func (x IndexRule_Location) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexRule_Location) Descriptor() protoreflect.EnumDescriptor {
	return file_banyandb_database_v1_schema_proto_enumTypes[5].Descriptor()
}

func (IndexRule_Location) Type() protoreflect.EnumType {
	return &file_banyandb_database_v1_schema_proto_enumTypes[5]
}

func (x IndexRule_Location) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndexRule_Location.Descriptor instead.
func (IndexRule_Location) EnumDescriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{7, 1}
}

type TagFamilySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// tags defines accepted tags
	Tags []*TagSpec `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *TagFamilySpec) Reset() {
	*x = TagFamilySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TagFamilySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TagFamilySpec) ProtoMessage() {}

func (x *TagFamilySpec) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TagFamilySpec.ProtoReflect.Descriptor instead.
func (*TagFamilySpec) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{0}
}

func (x *TagFamilySpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TagFamilySpec) GetTags() []*TagSpec {
	if x != nil {
		return x.Tags
	}
	return nil
}

type TagSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string  `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type TagType `protobuf:"varint,2,opt,name=type,proto3,enum=banyandb.database.v1.TagType" json:"type,omitempty"`
}

func (x *TagSpec) Reset() {
	*x = TagSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TagSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TagSpec) ProtoMessage() {}

func (x *TagSpec) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TagSpec.ProtoReflect.Descriptor instead.
func (*TagSpec) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{1}
}

func (x *TagSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TagSpec) GetType() TagType {
	if x != nil {
		return x.Type
	}
	return TagType_TAG_TYPE_UNSPECIFIED
}

// Stream intends to store streaming data, for example, traces or logs
type Stream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// metadata is the identity of a trace series
	Metadata *v1.Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// tag_families
	TagFamilies []*TagFamilySpec `protobuf:"bytes,2,rep,name=tag_families,json=tagFamilies,proto3" json:"tag_families,omitempty"`
	// entity indicates how to generate a series and shard a stream
	Entity *Entity `protobuf:"bytes,3,opt,name=entity,proto3" json:"entity,omitempty"`
	// updated_at indicates when the stream is updated
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
}

func (x *Stream) Reset() {
	*x = Stream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream) ProtoMessage() {}

func (x *Stream) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream.ProtoReflect.Descriptor instead.
func (*Stream) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{2}
}

func (x *Stream) GetMetadata() *v1.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Stream) GetTagFamilies() []*TagFamilySpec {
	if x != nil {
		return x.TagFamilies
	}
	return nil
}

func (x *Stream) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *Stream) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

type Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TagNames []string `protobuf:"bytes,1,rep,name=tag_names,json=tagNames,proto3" json:"tag_names,omitempty"`
}

func (x *Entity) Reset() {
	*x = Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity) ProtoMessage() {}

func (x *Entity) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity.ProtoReflect.Descriptor instead.
func (*Entity) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{3}
}

func (x *Entity) GetTagNames() []string {
	if x != nil {
		return x.TagNames
	}
	return nil
}

// FieldSpec is the specification of field
type FieldSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is the identity of a field
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// field_type denotes the type of field value
	FieldType FieldType `protobuf:"varint,2,opt,name=field_type,json=fieldType,proto3,enum=banyandb.database.v1.FieldType" json:"field_type,omitempty"`
	// encoding_method indicates how to encode data during writing
	EncodingMethod EncodingMethod `protobuf:"varint,3,opt,name=encoding_method,json=encodingMethod,proto3,enum=banyandb.database.v1.EncodingMethod" json:"encoding_method,omitempty"`
	// compression_method indicates how to compress data during writing
	CompressionMethod CompressionMethod `protobuf:"varint,4,opt,name=compression_method,json=compressionMethod,proto3,enum=banyandb.database.v1.CompressionMethod" json:"compression_method,omitempty"`
}

func (x *FieldSpec) Reset() {
	*x = FieldSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldSpec) ProtoMessage() {}

func (x *FieldSpec) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldSpec.ProtoReflect.Descriptor instead.
func (*FieldSpec) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{4}
}

func (x *FieldSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FieldSpec) GetFieldType() FieldType {
	if x != nil {
		return x.FieldType
	}
	return FieldType_FIELD_TYPE_UNSPECIFIED
}

func (x *FieldSpec) GetEncodingMethod() EncodingMethod {
	if x != nil {
		return x.EncodingMethod
	}
	return EncodingMethod_ENCODING_METHOD_UNSPECIFIED
}

func (x *FieldSpec) GetCompressionMethod() CompressionMethod {
	if x != nil {
		return x.CompressionMethod
	}
	return CompressionMethod_COMPRESSION_METHOD_UNSPECIFIED
}

// Measure intends to store data point
type Measure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// metadata is the identity of a measure
	Metadata *v1.Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// tag_families are for filter measures
	TagFamilies []*TagFamilySpec `protobuf:"bytes,2,rep,name=tag_families,json=tagFamilies,proto3" json:"tag_families,omitempty"`
	// fields denote measure values
	Fields []*FieldSpec `protobuf:"bytes,3,rep,name=fields,proto3" json:"fields,omitempty"`
	// entity indicates which tags will be to generate a series and shard a measure
	Entity *Entity `protobuf:"bytes,4,opt,name=entity,proto3" json:"entity,omitempty"`
	// interval indicates how frequently to send a data point
	// valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h", "d".
	Interval string `protobuf:"bytes,5,opt,name=interval,proto3" json:"interval,omitempty"`
	// updated_at indicates when the measure is updated
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
}

func (x *Measure) Reset() {
	*x = Measure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Measure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Measure) ProtoMessage() {}

func (x *Measure) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Measure.ProtoReflect.Descriptor instead.
func (*Measure) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{5}
}

func (x *Measure) GetMetadata() *v1.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Measure) GetTagFamilies() []*TagFamilySpec {
	if x != nil {
		return x.TagFamilies
	}
	return nil
}

func (x *Measure) GetFields() []*FieldSpec {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Measure) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *Measure) GetInterval() string {
	if x != nil {
		return x.Interval
	}
	return ""
}

func (x *Measure) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

// TopNAggregation generates offline TopN statistics for a measure's TopN approximation
type TopNAggregation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// metadata is the identity of an aggregation
	Metadata *v1.Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// source_measure denotes the data source of this aggregation
	SourceMeasure *v1.Metadata `protobuf:"bytes,2,opt,name=source_measure,json=sourceMeasure,proto3" json:"source_measure,omitempty"`
	// field_name is the name of field used for ranking
	FieldName string `protobuf:"bytes,3,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// field_value_sort indicates how to sort fields
	// ASC: bottomN
	// DESC: topN
	// UNSPECIFIED: topN + bottomN
	FieldValueSort v11.Sort `protobuf:"varint,4,opt,name=field_value_sort,json=fieldValueSort,proto3,enum=banyandb.model.v1.Sort" json:"field_value_sort,omitempty"`
	// group_by_tag_names groups data points into statistical counters
	GroupByTagNames []string `protobuf:"bytes,5,rep,name=group_by_tag_names,json=groupByTagNames,proto3" json:"group_by_tag_names,omitempty"`
	// criteria select partial data points from measure
	Criteria []*v11.Criteria `protobuf:"bytes,6,rep,name=criteria,proto3" json:"criteria,omitempty"`
	// counters_number sets the number of counters to be tracked. The default value is 1000
	CountersNumber int32 `protobuf:"varint,7,opt,name=counters_number,json=countersNumber,proto3" json:"counters_number,omitempty"`
	// updated_at indicates when the measure is updated
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
}

func (x *TopNAggregation) Reset() {
	*x = TopNAggregation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TopNAggregation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopNAggregation) ProtoMessage() {}

func (x *TopNAggregation) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopNAggregation.ProtoReflect.Descriptor instead.
func (*TopNAggregation) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{6}
}

func (x *TopNAggregation) GetMetadata() *v1.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *TopNAggregation) GetSourceMeasure() *v1.Metadata {
	if x != nil {
		return x.SourceMeasure
	}
	return nil
}

func (x *TopNAggregation) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *TopNAggregation) GetFieldValueSort() v11.Sort {
	if x != nil {
		return x.FieldValueSort
	}
	return v11.Sort(0)
}

func (x *TopNAggregation) GetGroupByTagNames() []string {
	if x != nil {
		return x.GroupByTagNames
	}
	return nil
}

func (x *TopNAggregation) GetCriteria() []*v11.Criteria {
	if x != nil {
		return x.Criteria
	}
	return nil
}

func (x *TopNAggregation) GetCountersNumber() int32 {
	if x != nil {
		return x.CountersNumber
	}
	return 0
}

func (x *TopNAggregation) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

// IndexRule defines how to generate indices based on tags and the index type
// IndexRule should bind to a subject through an IndexRuleBinding to generate proper indices.
type IndexRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// metadata define the rule's identity
	Metadata *v1.Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// tags are the combination that refers to an indexed object
	// If the elements in tags are more than 1, the object will generate a multi-tag index
	// Caveat: All tags in a multi-tag MUST have an identical IndexType
	Tags []string `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
	// type is the IndexType of this IndexObject.
	Type IndexRule_Type `protobuf:"varint,3,opt,name=type,proto3,enum=banyandb.database.v1.IndexRule_Type" json:"type,omitempty"`
	// location indicates where to store index.
	Location IndexRule_Location `protobuf:"varint,4,opt,name=location,proto3,enum=banyandb.database.v1.IndexRule_Location" json:"location,omitempty"`
	// updated_at indicates when the IndexRule is updated
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
}

func (x *IndexRule) Reset() {
	*x = IndexRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexRule) ProtoMessage() {}

func (x *IndexRule) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexRule.ProtoReflect.Descriptor instead.
func (*IndexRule) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{7}
}

func (x *IndexRule) GetMetadata() *v1.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *IndexRule) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *IndexRule) GetType() IndexRule_Type {
	if x != nil {
		return x.Type
	}
	return IndexRule_TYPE_UNSPECIFIED
}

func (x *IndexRule) GetLocation() IndexRule_Location {
	if x != nil {
		return x.Location
	}
	return IndexRule_LOCATION_UNSPECIFIED
}

func (x *IndexRule) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

// Subject defines which stream or measure would generate indices
type Subject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// catalog is where the subject belongs to
	Catalog v1.Catalog `protobuf:"varint,1,opt,name=catalog,proto3,enum=banyandb.common.v1.Catalog" json:"catalog,omitempty"`
	// name refers to a stream or measure in a particular catalog
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Subject) Reset() {
	*x = Subject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subject) ProtoMessage() {}

func (x *Subject) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subject.ProtoReflect.Descriptor instead.
func (*Subject) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{8}
}

func (x *Subject) GetCatalog() v1.Catalog {
	if x != nil {
		return x.Catalog
	}
	return v1.Catalog(0)
}

func (x *Subject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// IndexRuleBinding is a bridge to connect severalIndexRules to a subject
// This binding is valid between begin_at_nanoseconds and expire_at_nanoseconds, that provides flexible strategies
// to control how to generate time series indices.
type IndexRuleBinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// metadata is the identity of this binding
	Metadata *v1.Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// rules refers to the IndexRule
	Rules []string `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	// subject indicates the subject of binding action
	Subject *Subject `protobuf:"bytes,3,opt,name=subject,proto3" json:"subject,omitempty"`
	// begin_at_nanoseconds is the timestamp, after which the binding will be active
	BeginAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=begin_at,json=beginAt,proto3" json:"begin_at,omitempty"`
	// expire_at_nanoseconds it the timestamp, after which the binding will be inactive
	// expire_at_nanoseconds must be larger than begin_at_nanoseconds
	ExpireAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_at,json=expireAt,proto3" json:"expire_at,omitempty"`
	// updated_at indicates when the IndexRuleBinding is updated
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
}

func (x *IndexRuleBinding) Reset() {
	*x = IndexRuleBinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_banyandb_database_v1_schema_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexRuleBinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexRuleBinding) ProtoMessage() {}

func (x *IndexRuleBinding) ProtoReflect() protoreflect.Message {
	mi := &file_banyandb_database_v1_schema_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexRuleBinding.ProtoReflect.Descriptor instead.
func (*IndexRuleBinding) Descriptor() ([]byte, []int) {
	return file_banyandb_database_v1_schema_proto_rawDescGZIP(), []int{9}
}

func (x *IndexRuleBinding) GetMetadata() *v1.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *IndexRuleBinding) GetRules() []string {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *IndexRuleBinding) GetSubject() *Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *IndexRuleBinding) GetBeginAt() *timestamppb.Timestamp {
	if x != nil {
		return x.BeginAt
	}
	return nil
}

func (x *IndexRuleBinding) GetExpireAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireAt
	}
	return nil
}

func (x *IndexRuleBinding) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

var File_banyandb_database_v1_schema_proto protoreflect.FileDescriptor

var file_banyandb_database_v1_schema_proto_rawDesc = []byte{
	0x0a, 0x21, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x14, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x62, 0x61, 0x6e, 0x79,
	0x61, 0x6e, 0x64, 0x62, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x62, 0x61, 0x6e,
	0x79, 0x61, 0x6e, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x56, 0x0a, 0x0d, 0x54, 0x61,
	0x67, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x31, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x22, 0x50, 0x0a, 0x07, 0x54, 0x61, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x31, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1d, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x22, 0xfb, 0x01, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x38, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x0c, 0x74, 0x61, 0x67,
	0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x0b, 0x74, 0x61, 0x67, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65,
	0x73, 0x12, 0x34, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52,
	0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x74, 0x22, 0x25, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x09,
	0x74, 0x61, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x74, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x86, 0x02, 0x0a, 0x09, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1f, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x56, 0x0a, 0x12, 0x63, 0x6f,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64,
	0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52,
	0x11, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x22, 0xd1, 0x02, 0x0a, 0x07, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x12, 0x38,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x0c, 0x74, 0x61, 0x67, 0x5f,
	0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x0b, 0x74, 0x61, 0x67, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73,
	0x12, 0x37, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x34, 0x0a, 0x06, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x62, 0x61, 0x6e, 0x79,
	0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x39, 0x0a, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x22, 0xbc, 0x03, 0x0a, 0x0f, 0x54, 0x6f, 0x70, 0x4e, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x62,
	0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x43, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x62,
	0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x10, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x17, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x52, 0x0e, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x6f, 0x72, 0x74, 0x12, 0x2b, 0x0a, 0x12, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x79,
	0x54, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x61, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x62, 0x61, 0x6e,
	0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x65, 0x72, 0x73, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x41, 0x74, 0x22, 0xa4, 0x03, 0x0a, 0x09, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x38, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x12, 0x38, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x24, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x75, 0x6c, 0x65,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x22, 0x3e, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x49, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x45, 0x44, 0x10, 0x02, 0x22, 0x4e, 0x0a, 0x08,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x4f, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53,
	0x45, 0x52, 0x49, 0x45, 0x53, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x54, 0x0a, 0x07,
	0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x35, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61,
	0x6e, 0x64, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xc6, 0x02, 0x0a, 0x10, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x75, 0x6c, 0x65,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x38, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x62, 0x61, 0x6e, 0x79,
	0x61, 0x6e, 0x64, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61,
	0x6e, 0x64, 0x62, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x35, 0x0a, 0x08, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x62, 0x65, 0x67, 0x69, 0x6e, 0x41, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x41, 0x74,
	0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x2a, 0xa8, 0x01, 0x0a, 0x07,
	0x54, 0x61, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x41, 0x47, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x41, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x41, 0x47, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x41, 0x47, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x52, 0x52, 0x41,
	0x59, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x41, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x49, 0x4e, 0x54, 0x5f, 0x41, 0x52, 0x52, 0x41, 0x59, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x54,
	0x41, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x42, 0x49, 0x4e,
	0x41, 0x52, 0x59, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x41, 0x47, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x49, 0x44, 0x10, 0x06, 0x2a, 0x6e, 0x0a, 0x09, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x15, 0x0a, 0x11, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x49,
	0x45, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x42, 0x49,
	0x4e, 0x41, 0x52, 0x59, 0x10, 0x03, 0x2a, 0x4e, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x4e, 0x43, 0x4f,
	0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x43,
	0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x47, 0x4f, 0x52,
	0x49, 0x4c, 0x4c, 0x41, 0x10, 0x01, 0x2a, 0x54, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x22, 0x0a, 0x1e, 0x43,
	0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f,
	0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d,
	0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x5a, 0x53, 0x54, 0x44, 0x10, 0x01, 0x42, 0x72, 0x0a, 0x2a,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x73, 0x6b, 0x79, 0x77, 0x61,
	0x6c, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64, 0x62, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x5a, 0x44, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x73, 0x6b,
	0x79, 0x77, 0x61, 0x6c, 0x6b, 0x69, 0x6e, 0x67, 0x2d, 0x62, 0x61, 0x6e, 0x79, 0x61, 0x6e, 0x64,
	0x62, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x62, 0x61, 0x6e, 0x79,
	0x61, 0x6e, 0x64, 0x62, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_banyandb_database_v1_schema_proto_rawDescOnce sync.Once
	file_banyandb_database_v1_schema_proto_rawDescData = file_banyandb_database_v1_schema_proto_rawDesc
)

func file_banyandb_database_v1_schema_proto_rawDescGZIP() []byte {
	file_banyandb_database_v1_schema_proto_rawDescOnce.Do(func() {
		file_banyandb_database_v1_schema_proto_rawDescData = protoimpl.X.CompressGZIP(file_banyandb_database_v1_schema_proto_rawDescData)
	})
	return file_banyandb_database_v1_schema_proto_rawDescData
}

var file_banyandb_database_v1_schema_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_banyandb_database_v1_schema_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_banyandb_database_v1_schema_proto_goTypes = []interface{}{
	(TagType)(0),                  // 0: banyandb.database.v1.TagType
	(FieldType)(0),                // 1: banyandb.database.v1.FieldType
	(EncodingMethod)(0),           // 2: banyandb.database.v1.EncodingMethod
	(CompressionMethod)(0),        // 3: banyandb.database.v1.CompressionMethod
	(IndexRule_Type)(0),           // 4: banyandb.database.v1.IndexRule.Type
	(IndexRule_Location)(0),       // 5: banyandb.database.v1.IndexRule.Location
	(*TagFamilySpec)(nil),         // 6: banyandb.database.v1.TagFamilySpec
	(*TagSpec)(nil),               // 7: banyandb.database.v1.TagSpec
	(*Stream)(nil),                // 8: banyandb.database.v1.Stream
	(*Entity)(nil),                // 9: banyandb.database.v1.Entity
	(*FieldSpec)(nil),             // 10: banyandb.database.v1.FieldSpec
	(*Measure)(nil),               // 11: banyandb.database.v1.Measure
	(*TopNAggregation)(nil),       // 12: banyandb.database.v1.TopNAggregation
	(*IndexRule)(nil),             // 13: banyandb.database.v1.IndexRule
	(*Subject)(nil),               // 14: banyandb.database.v1.Subject
	(*IndexRuleBinding)(nil),      // 15: banyandb.database.v1.IndexRuleBinding
	(*v1.Metadata)(nil),           // 16: banyandb.common.v1.Metadata
	(*timestamppb.Timestamp)(nil), // 17: google.protobuf.Timestamp
	(v11.Sort)(0),                 // 18: banyandb.model.v1.Sort
	(*v11.Criteria)(nil),          // 19: banyandb.model.v1.Criteria
	(v1.Catalog)(0),               // 20: banyandb.common.v1.Catalog
}
var file_banyandb_database_v1_schema_proto_depIdxs = []int32{
	7,  // 0: banyandb.database.v1.TagFamilySpec.tags:type_name -> banyandb.database.v1.TagSpec
	0,  // 1: banyandb.database.v1.TagSpec.type:type_name -> banyandb.database.v1.TagType
	16, // 2: banyandb.database.v1.Stream.metadata:type_name -> banyandb.common.v1.Metadata
	6,  // 3: banyandb.database.v1.Stream.tag_families:type_name -> banyandb.database.v1.TagFamilySpec
	9,  // 4: banyandb.database.v1.Stream.entity:type_name -> banyandb.database.v1.Entity
	17, // 5: banyandb.database.v1.Stream.updated_at:type_name -> google.protobuf.Timestamp
	1,  // 6: banyandb.database.v1.FieldSpec.field_type:type_name -> banyandb.database.v1.FieldType
	2,  // 7: banyandb.database.v1.FieldSpec.encoding_method:type_name -> banyandb.database.v1.EncodingMethod
	3,  // 8: banyandb.database.v1.FieldSpec.compression_method:type_name -> banyandb.database.v1.CompressionMethod
	16, // 9: banyandb.database.v1.Measure.metadata:type_name -> banyandb.common.v1.Metadata
	6,  // 10: banyandb.database.v1.Measure.tag_families:type_name -> banyandb.database.v1.TagFamilySpec
	10, // 11: banyandb.database.v1.Measure.fields:type_name -> banyandb.database.v1.FieldSpec
	9,  // 12: banyandb.database.v1.Measure.entity:type_name -> banyandb.database.v1.Entity
	17, // 13: banyandb.database.v1.Measure.updated_at:type_name -> google.protobuf.Timestamp
	16, // 14: banyandb.database.v1.TopNAggregation.metadata:type_name -> banyandb.common.v1.Metadata
	16, // 15: banyandb.database.v1.TopNAggregation.source_measure:type_name -> banyandb.common.v1.Metadata
	18, // 16: banyandb.database.v1.TopNAggregation.field_value_sort:type_name -> banyandb.model.v1.Sort
	19, // 17: banyandb.database.v1.TopNAggregation.criteria:type_name -> banyandb.model.v1.Criteria
	17, // 18: banyandb.database.v1.TopNAggregation.updated_at:type_name -> google.protobuf.Timestamp
	16, // 19: banyandb.database.v1.IndexRule.metadata:type_name -> banyandb.common.v1.Metadata
	4,  // 20: banyandb.database.v1.IndexRule.type:type_name -> banyandb.database.v1.IndexRule.Type
	5,  // 21: banyandb.database.v1.IndexRule.location:type_name -> banyandb.database.v1.IndexRule.Location
	17, // 22: banyandb.database.v1.IndexRule.updated_at:type_name -> google.protobuf.Timestamp
	20, // 23: banyandb.database.v1.Subject.catalog:type_name -> banyandb.common.v1.Catalog
	16, // 24: banyandb.database.v1.IndexRuleBinding.metadata:type_name -> banyandb.common.v1.Metadata
	14, // 25: banyandb.database.v1.IndexRuleBinding.subject:type_name -> banyandb.database.v1.Subject
	17, // 26: banyandb.database.v1.IndexRuleBinding.begin_at:type_name -> google.protobuf.Timestamp
	17, // 27: banyandb.database.v1.IndexRuleBinding.expire_at:type_name -> google.protobuf.Timestamp
	17, // 28: banyandb.database.v1.IndexRuleBinding.updated_at:type_name -> google.protobuf.Timestamp
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_banyandb_database_v1_schema_proto_init() }
func file_banyandb_database_v1_schema_proto_init() {
	if File_banyandb_database_v1_schema_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_banyandb_database_v1_schema_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TagFamilySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TagSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Measure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TopNAggregation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_banyandb_database_v1_schema_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexRuleBinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_banyandb_database_v1_schema_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_banyandb_database_v1_schema_proto_goTypes,
		DependencyIndexes: file_banyandb_database_v1_schema_proto_depIdxs,
		EnumInfos:         file_banyandb_database_v1_schema_proto_enumTypes,
		MessageInfos:      file_banyandb_database_v1_schema_proto_msgTypes,
	}.Build()
	File_banyandb_database_v1_schema_proto = out.File
	file_banyandb_database_v1_schema_proto_rawDesc = nil
	file_banyandb_database_v1_schema_proto_goTypes = nil
	file_banyandb_database_v1_schema_proto_depIdxs = nil
}
