/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.Http1HeaderNaming;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.TlsSetters;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.common.util.DomainSocketAddress;
import com.linecorp.armeria.common.util.EventLoopGroups;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.armeria.internal.common.BuiltInDependencyInjector;
import com.linecorp.armeria.internal.common.ReflectiveDependencyInjector;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.server.RouteDecoratingService;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectArrayMap;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.internal.shaded.guava.net.HostAndPort;
import com.linecorp.armeria.server.AnnotatedServiceBindingBuilder;
import com.linecorp.armeria.server.ClientAddressSource;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.DecoratingServiceBindingBuilder;
import com.linecorp.armeria.server.DefaultServerConfig;
import com.linecorp.armeria.server.DomainMappingBuilder;
import com.linecorp.armeria.server.FunctionalDecoratingHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.RejectedRouteHandler;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerErrorHandler;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.ServiceBindingBuilder;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.ServiceWithRoutes;
import com.linecorp.armeria.server.ShutdownSupport;
import com.linecorp.armeria.server.UnhandledExceptionsReporter;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.VirtualHostBuilder;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.Mapping;
import io.netty.util.NetUtil;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerBuilder
implements TlsSetters {
    private static final Logger logger = LoggerFactory.getLogger(ServerBuilder.class);
    private static final Duration DEFAULT_GRACEFUL_SHUTDOWN_QUIET_PERIOD = Duration.ZERO;
    private static final Duration DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT = Duration.ZERO;
    private static final int PROXY_PROTOCOL_DEFAULT_MAX_TLV_SIZE = 65319;
    private static final String DEFAULT_ACCESS_LOGGER_PREFIX = "com.linecorp.armeria.logging.access";
    private static final Consumer<ChannelPipeline> DEFAULT_CHILD_CHANNEL_PIPELINE_CUSTOMIZER = v -> {};
    static final long MIN_PING_INTERVAL_MILLIS = 1000L;
    private static final long MIN_MAX_CONNECTION_AGE_MILLIS = 1000L;
    private static final ExecutorService START_STOP_EXECUTOR = Executors.newSingleThreadExecutor(ThreadFactories.newThreadFactory("startstop-support", true));
    private final List<ServerPort> ports = new ArrayList<ServerPort>();
    private final List<ServerListener> serverListeners = new ArrayList<ServerListener>();
    final VirtualHostBuilder virtualHostTemplate = new VirtualHostBuilder(this, false);
    private final VirtualHostBuilder defaultVirtualHostBuilder = new VirtualHostBuilder(this, true);
    private final List<VirtualHostBuilder> virtualHostBuilders = new ArrayList<VirtualHostBuilder>();
    private EventLoopGroup workerGroup = CommonPools.workerGroup();
    private boolean shutdownWorkerGroupOnStop;
    private Executor startStopExecutor = START_STOP_EXECUTOR;
    private final Map<ChannelOption<?>, Object> channelOptions = new Object2ObjectArrayMap();
    private final Map<ChannelOption<?>, Object> childChannelOptions = new Object2ObjectArrayMap();
    private Consumer<ChannelPipeline> childChannelPipelineCustomizer = DEFAULT_CHILD_CHANNEL_PIPELINE_CUSTOMIZER;
    private int maxNumConnections = Flags.maxNumConnections();
    private long idleTimeoutMillis = Flags.defaultServerIdleTimeoutMillis();
    private boolean keepAliveOnPing = Flags.defaultServerKeepAliveOnPing();
    private long pingIntervalMillis = Flags.defaultPingIntervalMillis();
    private long maxConnectionAgeMillis = Flags.defaultMaxServerConnectionAgeMillis();
    private long connectionDrainDurationMicros = Flags.defaultServerConnectionDrainDurationMicros();
    private int maxNumRequestsPerConnection = Flags.defaultMaxServerNumRequestsPerConnection();
    private int http2InitialConnectionWindowSize = Flags.defaultHttp2InitialConnectionWindowSize();
    private int http2InitialStreamWindowSize = Flags.defaultHttp2InitialStreamWindowSize();
    private long http2MaxStreamsPerConnection = Flags.defaultHttp2MaxStreamsPerConnection();
    private int http2MaxFrameSize = Flags.defaultHttp2MaxFrameSize();
    private long http2MaxHeaderListSize = Flags.defaultHttp2MaxHeaderListSize();
    private int http1MaxInitialLineLength = Flags.defaultHttp1MaxInitialLineLength();
    private int http1MaxHeaderSize = Flags.defaultHttp1MaxHeaderSize();
    private int http1MaxChunkSize = Flags.defaultHttp1MaxChunkSize();
    private int proxyProtocolMaxTlvSize = 65319;
    private Duration gracefulShutdownQuietPeriod = DEFAULT_GRACEFUL_SHUTDOWN_QUIET_PERIOD;
    private Duration gracefulShutdownTimeout = DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;
    private MeterRegistry meterRegistry = Flags.meterRegistry();
    private ServerErrorHandler errorHandler = ServerErrorHandler.ofDefault();
    private List<ClientAddressSource> clientAddressSources = ClientAddressSource.DEFAULT_SOURCES;
    private Predicate<? super InetAddress> clientAddressTrustedProxyFilter = address -> false;
    private Predicate<? super InetAddress> clientAddressFilter = address -> true;
    private Function<? super ProxiedAddresses, ? extends InetSocketAddress> clientAddressMapper = ProxiedAddresses::sourceAddress;
    private boolean enableServerHeader = true;
    private boolean enableDateHeader = true;
    private Http1HeaderNaming http1HeaderNaming = Http1HeaderNaming.ofDefault();
    @Nullable
    private DependencyInjector dependencyInjector;
    private Function<? super String, String> absoluteUriTransformer = Function.identity();
    private long unhandledExceptionsReportIntervalMillis = Flags.defaultUnhandledExceptionsReportIntervalMillis();
    private final List<ShutdownSupport> shutdownSupports = new ArrayList<ShutdownSupport>();

    ServerBuilder() {
        this.virtualHostTemplate.rejectedRouteHandler(RejectedRouteHandler.WARN);
        this.virtualHostTemplate.defaultServiceNaming(ServiceNaming.fullTypeName());
        this.virtualHostTemplate.requestTimeoutMillis(Flags.defaultRequestTimeoutMillis());
        this.virtualHostTemplate.maxRequestLength(Flags.defaultMaxRequestLength());
        this.virtualHostTemplate.verboseResponses(Flags.verboseResponses());
        this.virtualHostTemplate.accessLogger((? super VirtualHost host) -> LoggerFactory.getLogger((String)ServerBuilder.defaultAccessLoggerName(host.hostnamePattern())));
        this.virtualHostTemplate.tlsSelfSigned(false);
        this.virtualHostTemplate.tlsAllowUnsafeCiphers(false);
        this.virtualHostTemplate.annotatedServiceExtensions(ImmutableList.of(), ImmutableList.of(), ImmutableList.of());
        this.virtualHostTemplate.blockingTaskExecutor(CommonPools.blockingTaskExecutor(), false);
        this.virtualHostTemplate.successFunction(SuccessFunction.ofDefault());
        this.virtualHostTemplate.requestAutoAbortDelayMillis(0L);
        this.virtualHostTemplate.multipartUploadsLocation(Flags.defaultMultipartUploadsLocation());
        this.virtualHostTemplate.requestIdGenerator((? super RoutingContext routingContext) -> RequestId.random());
    }

    private static String defaultAccessLoggerName(String hostnamePattern) {
        Objects.requireNonNull(hostnamePattern, "hostnamePattern");
        HostAndPort hostAndPort = HostAndPort.fromString(hostnamePattern);
        hostnamePattern = hostAndPort.getHost();
        String[] elements = hostnamePattern.split("\\.");
        StringBuilder name = new StringBuilder(DEFAULT_ACCESS_LOGGER_PREFIX.length() + hostnamePattern.length() + 1);
        name.append(DEFAULT_ACCESS_LOGGER_PREFIX);
        for (int i = elements.length - 1; i >= 0; --i) {
            String element = elements[i];
            if (element.isEmpty() || "*".equals(element)) continue;
            name.append('.');
            name.append(element);
        }
        if (hostAndPort.hasPort()) {
            name.append(':');
            name.append(hostAndPort.getPort());
        }
        return name.toString();
    }

    public ServerBuilder http(int port) {
        return this.port(new ServerPort(port, SessionProtocol.HTTP));
    }

    public ServerBuilder http(InetSocketAddress localAddress) {
        return this.port(new ServerPort(Objects.requireNonNull(localAddress, "localAddress"), SessionProtocol.HTTP));
    }

    public ServerBuilder https(int port) {
        return this.port(new ServerPort(port, SessionProtocol.HTTPS));
    }

    public ServerBuilder https(InetSocketAddress localAddress) {
        return this.port(new ServerPort(Objects.requireNonNull(localAddress, "localAddress"), SessionProtocol.HTTPS));
    }

    public ServerBuilder port(int port, SessionProtocol ... protocols) {
        return this.port(new ServerPort(port, protocols));
    }

    public ServerBuilder port(int port, Iterable<SessionProtocol> protocols) {
        return this.port(new ServerPort(port, protocols));
    }

    public ServerBuilder port(InetSocketAddress localAddress, SessionProtocol ... protocols) {
        return this.port(new ServerPort(localAddress, protocols));
    }

    public ServerBuilder port(InetSocketAddress localAddress, Iterable<SessionProtocol> protocols) {
        return this.port(new ServerPort(localAddress, protocols));
    }

    public ServerBuilder port(ServerPort port) {
        this.ports.add(Objects.requireNonNull(port, "port"));
        return this;
    }

    public ServerBuilder localPort(int port, SessionProtocol ... protocols) {
        Objects.requireNonNull(protocols, "protocols");
        return this.localPort(port, ImmutableList.copyOf(protocols));
    }

    public ServerBuilder localPort(int port, Iterable<SessionProtocol> protocols) {
        long portGroup = ServerPort.nextPortGroup();
        this.port(new ServerPort(new InetSocketAddress(NetUtil.LOCALHOST4, port), protocols, portGroup));
        if (SystemInfo.hasIpV6()) {
            this.port(new ServerPort(new InetSocketAddress(NetUtil.LOCALHOST6, port), protocols, portGroup));
        }
        return this;
    }

    public <T> ServerBuilder channelOption(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Preconditions.checkArgument(!ChannelUtil.prohibitedOptions().contains(option), "prohibited socket option: %s", option);
        option.validate(value);
        this.channelOptions.put(option, value);
        return this;
    }

    public <T> ServerBuilder childChannelOption(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Preconditions.checkArgument(!ChannelUtil.prohibitedOptions().contains(option), "prohibited socket option: %s", option);
        option.validate(value);
        this.childChannelOptions.put(option, value);
        return this;
    }

    @UnstableApi
    public ServerBuilder childChannelPipelineCustomizer(Consumer<? super ChannelPipeline> childChannelPipelineCustomizer) {
        Objects.requireNonNull(childChannelPipelineCustomizer, "childChannelPipelineCustomizer");
        this.childChannelPipelineCustomizer = this.childChannelPipelineCustomizer.andThen(childChannelPipelineCustomizer);
        return this;
    }

    public ServerBuilder workerGroup(EventLoopGroup workerGroup, boolean shutdownOnStop) {
        this.workerGroup = Objects.requireNonNull(workerGroup, "workerGroup");
        this.shutdownWorkerGroupOnStop = shutdownOnStop;
        return this;
    }

    public ServerBuilder workerGroup(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        this.workerGroup(EventLoopGroups.newEventLoopGroup(numThreads), true);
        return this;
    }

    public ServerBuilder startStopExecutor(Executor startStopExecutor) {
        this.startStopExecutor = Objects.requireNonNull(startStopExecutor, "startStopExecutor");
        return this;
    }

    public ServerBuilder maxNumConnections(int maxNumConnections) {
        this.maxNumConnections = DefaultServerConfig.validateMaxNumConnections(maxNumConnections);
        return this;
    }

    int maxNumConnections() {
        return this.maxNumConnections;
    }

    public ServerBuilder idleTimeoutMillis(long idleTimeoutMillis) {
        return this.idleTimeout(Duration.ofMillis(idleTimeoutMillis));
    }

    @UnstableApi
    public ServerBuilder idleTimeoutMillis(long idleTimeoutMillis, boolean keepAliveOnPing) {
        return this.idleTimeout(Duration.ofMillis(idleTimeoutMillis), keepAliveOnPing);
    }

    public ServerBuilder idleTimeout(Duration idleTimeout) {
        Objects.requireNonNull(idleTimeout, "idleTimeout");
        this.idleTimeoutMillis = DefaultServerConfig.validateIdleTimeoutMillis(idleTimeout.toMillis());
        return this;
    }

    @UnstableApi
    public ServerBuilder idleTimeout(Duration idleTimeout, boolean keepAliveOnPing) {
        Objects.requireNonNull(idleTimeout, "idleTimeout");
        this.idleTimeoutMillis = DefaultServerConfig.validateIdleTimeoutMillis(idleTimeout.toMillis());
        this.keepAliveOnPing = keepAliveOnPing;
        return this;
    }

    public ServerBuilder pingIntervalMillis(long pingIntervalMillis) {
        Preconditions.checkArgument(pingIntervalMillis == 0L || pingIntervalMillis >= 1000L, "pingIntervalMillis: %s (expected: >= %s or == 0)", pingIntervalMillis, 1000L);
        this.pingIntervalMillis = pingIntervalMillis;
        return this;
    }

    public ServerBuilder pingInterval(Duration pingInterval) {
        this.pingIntervalMillis(Objects.requireNonNull(pingInterval, "pingInterval").toMillis());
        return this;
    }

    public ServerBuilder maxConnectionAgeMillis(long maxConnectionAgeMillis) {
        Preconditions.checkArgument(maxConnectionAgeMillis >= 1000L || maxConnectionAgeMillis == 0L, "maxConnectionAgeMillis: %s (expected: >= %s or == 0)", maxConnectionAgeMillis, 1000L);
        this.maxConnectionAgeMillis = maxConnectionAgeMillis;
        return this;
    }

    public ServerBuilder maxConnectionAge(Duration maxConnectionAge) {
        return this.maxConnectionAgeMillis(Objects.requireNonNull(maxConnectionAge, "maxConnectionAge").toMillis());
    }

    public ServerBuilder connectionDrainDurationMicros(long durationMicros) {
        Preconditions.checkArgument(this.connectionDrainDurationMicros >= 0L, "connectionDrainDurationMicros: %s (expected: >= 0)", this.connectionDrainDurationMicros);
        this.connectionDrainDurationMicros = durationMicros;
        return this;
    }

    public ServerBuilder connectionDrainDuration(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        return this.connectionDrainDurationMicros(TimeUnit.NANOSECONDS.toMicros(duration.toNanos()));
    }

    public ServerBuilder maxNumRequestsPerConnection(int maxNumRequestsPerConnection) {
        this.maxNumRequestsPerConnection = DefaultServerConfig.validateNonNegative(maxNumRequestsPerConnection, "maxNumRequestsPerConnection");
        return this;
    }

    public ServerBuilder http2InitialConnectionWindowSize(int http2InitialConnectionWindowSize) {
        Preconditions.checkArgument(http2InitialConnectionWindowSize > 0, "http2InitialConnectionWindowSize: %s (expected: > 0)", http2InitialConnectionWindowSize);
        this.http2InitialConnectionWindowSize = http2InitialConnectionWindowSize;
        return this;
    }

    public ServerBuilder http2InitialStreamWindowSize(int http2InitialStreamWindowSize) {
        Preconditions.checkArgument(http2InitialStreamWindowSize > 0, "http2InitialStreamWindowSize: %s (expected: > 0)", http2InitialStreamWindowSize);
        this.http2InitialStreamWindowSize = http2InitialStreamWindowSize;
        return this;
    }

    public ServerBuilder http2MaxStreamsPerConnection(long http2MaxStreamsPerConnection) {
        Preconditions.checkArgument(http2MaxStreamsPerConnection > 0L && http2MaxStreamsPerConnection <= 0xFFFFFFFFL, "http2MaxStreamsPerConnection: %s (expected: a positive 32-bit unsigned integer)", http2MaxStreamsPerConnection);
        this.http2MaxStreamsPerConnection = http2MaxStreamsPerConnection;
        return this;
    }

    public ServerBuilder http2MaxFrameSize(int http2MaxFrameSize) {
        Preconditions.checkArgument(http2MaxFrameSize >= 16384 && http2MaxFrameSize <= 0xFFFFFF, "http2MaxFrameSize: %s (expected: >= %s and <= %s)", (Object)http2MaxFrameSize, (Object)16384, (Object)0xFFFFFF);
        this.http2MaxFrameSize = http2MaxFrameSize;
        return this;
    }

    public ServerBuilder http2MaxHeaderListSize(long http2MaxHeaderListSize) {
        Preconditions.checkArgument(http2MaxHeaderListSize > 0L && http2MaxHeaderListSize <= 0xFFFFFFFFL, "http2MaxHeaderListSize: %s (expected: a positive 32-bit unsigned integer)", http2MaxHeaderListSize);
        this.http2MaxHeaderListSize = http2MaxHeaderListSize;
        return this;
    }

    public ServerBuilder http1MaxInitialLineLength(int http1MaxInitialLineLength) {
        this.http1MaxInitialLineLength = DefaultServerConfig.validateNonNegative(http1MaxInitialLineLength, "http1MaxInitialLineLength");
        return this;
    }

    public ServerBuilder http1MaxHeaderSize(int http1MaxHeaderSize) {
        this.http1MaxHeaderSize = DefaultServerConfig.validateNonNegative(http1MaxHeaderSize, "http1MaxHeaderSize");
        return this;
    }

    public ServerBuilder http1MaxChunkSize(int http1MaxChunkSize) {
        this.http1MaxChunkSize = DefaultServerConfig.validateNonNegative(http1MaxChunkSize, "http1MaxChunkSize");
        return this;
    }

    public ServerBuilder gracefulShutdownTimeoutMillis(long quietPeriodMillis, long timeoutMillis) {
        return this.gracefulShutdownTimeout(Duration.ofMillis(quietPeriodMillis), Duration.ofMillis(timeoutMillis));
    }

    public ServerBuilder gracefulShutdownTimeout(Duration quietPeriod, Duration timeout) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout, "timeout");
        this.gracefulShutdownQuietPeriod = DefaultServerConfig.validateNonNegative(quietPeriod, "quietPeriod");
        this.gracefulShutdownTimeout = DefaultServerConfig.validateNonNegative(timeout, "timeout");
        DefaultServerConfig.validateGreaterThanOrEqual(this.gracefulShutdownTimeout, "quietPeriod", this.gracefulShutdownQuietPeriod, "timeout");
        return this;
    }

    @UnstableApi
    public ServerBuilder requestAutoAbortDelay(Duration delay) {
        return this.requestAutoAbortDelayMillis(Objects.requireNonNull(delay, "delay").toMillis());
    }

    @UnstableApi
    public ServerBuilder requestAutoAbortDelayMillis(long delayMillis) {
        this.virtualHostTemplate.requestAutoAbortDelayMillis(delayMillis);
        return this;
    }

    @UnstableApi
    public ServerBuilder multipartUploadsLocation(Path path) {
        Objects.requireNonNull(path, "path");
        this.virtualHostTemplate.multipartUploadsLocation(path);
        return this;
    }

    public ServerBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.virtualHostTemplate.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    public ServerBuilder blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.virtualHostTemplate.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    public ServerBuilder blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    @UnstableApi
    public ServerBuilder successFunction(SuccessFunction successFunction) {
        this.virtualHostTemplate.successFunction(Objects.requireNonNull(successFunction, "successFunction"));
        return this;
    }

    public ServerBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        return this;
    }

    public ServerBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.virtualHostTemplate.defaultServiceNaming(defaultServiceNaming);
        return this;
    }

    public ServerBuilder accessLogFormat(String accessLogFormat) {
        return this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), false);
    }

    public ServerBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.virtualHostTemplate.accessLogWriter(accessLogWriter, shutdownOnStop);
        return this;
    }

    public ServerBuilder proxyProtocolMaxTlvSize(int proxyProtocolMaxTlvSize) {
        Preconditions.checkArgument(proxyProtocolMaxTlvSize >= 0, "proxyProtocolMaxTlvSize: %s (expected: >= 0)", proxyProtocolMaxTlvSize);
        this.proxyProtocolMaxTlvSize = proxyProtocolMaxTlvSize;
        return this;
    }

    @Override
    public ServerBuilder tls(File keyCertChainFile, File keyFile) {
        return (ServerBuilder)TlsSetters.super.tls(keyCertChainFile, keyFile);
    }

    @Override
    public ServerBuilder tls(File keyCertChainFile, File keyFile, @Nullable String keyPassword) {
        this.virtualHostTemplate.tls(keyCertChainFile, keyFile, keyPassword);
        return this;
    }

    @Override
    public ServerBuilder tls(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return (ServerBuilder)TlsSetters.super.tls(keyCertChainInputStream, keyInputStream);
    }

    @Override
    public ServerBuilder tls(InputStream keyCertChainInputStream, InputStream keyInputStream, @Nullable String keyPassword) {
        this.virtualHostTemplate.tls(keyCertChainInputStream, keyInputStream, keyPassword);
        return this;
    }

    @Override
    public ServerBuilder tls(PrivateKey key, X509Certificate ... keyCertChain) {
        return (ServerBuilder)TlsSetters.super.tls(key, keyCertChain);
    }

    @Override
    public ServerBuilder tls(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return (ServerBuilder)TlsSetters.super.tls(key, keyCertChain);
    }

    @Override
    public ServerBuilder tls(PrivateKey key, @Nullable String keyPassword, X509Certificate ... keyCertChain) {
        return (ServerBuilder)TlsSetters.super.tls(key, keyPassword, keyCertChain);
    }

    @Override
    public ServerBuilder tls(PrivateKey key, @Nullable String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        this.virtualHostTemplate.tls(key, keyPassword, (Iterable)keyCertChain);
        return this;
    }

    @Override
    public ServerBuilder tls(KeyManagerFactory keyManagerFactory) {
        this.virtualHostTemplate.tls(keyManagerFactory);
        return this;
    }

    public ServerBuilder tlsSelfSigned() {
        this.virtualHostTemplate.tlsSelfSigned();
        return this;
    }

    public ServerBuilder tlsSelfSigned(boolean tlsSelfSigned) {
        this.virtualHostTemplate.tlsSelfSigned(tlsSelfSigned);
        return this;
    }

    @Override
    public ServerBuilder tlsCustomizer(Consumer<? super SslContextBuilder> tlsCustomizer) {
        this.virtualHostTemplate.tlsCustomizer((Consumer)tlsCustomizer);
        return this;
    }

    @Deprecated
    public ServerBuilder tlsAllowUnsafeCiphers() {
        this.virtualHostTemplate.tlsAllowUnsafeCiphers();
        return this;
    }

    @Deprecated
    public ServerBuilder tlsAllowUnsafeCiphers(boolean tlsAllowUnsafeCiphers) {
        this.virtualHostTemplate.tlsAllowUnsafeCiphers(tlsAllowUnsafeCiphers);
        return this;
    }

    public ServerBuilder withRoute(Consumer<? super ServiceBindingBuilder> customizer) {
        ServiceBindingBuilder serviceBindingBuilder = new ServiceBindingBuilder(this);
        customizer.accept(serviceBindingBuilder);
        return this;
    }

    public ServiceBindingBuilder route() {
        return new ServiceBindingBuilder(this);
    }

    public DecoratingServiceBindingBuilder routeDecorator() {
        return new DecoratingServiceBindingBuilder(this);
    }

    public ServerBuilder serviceUnder(String pathPrefix, HttpService service) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        HttpServiceWithRoutes serviceWithRoutes = service.as(HttpServiceWithRoutes.class);
        if (serviceWithRoutes != null) {
            serviceWithRoutes.routes().forEach(route -> this.route().addRoute(route.withPrefix(pathPrefix)).mappedRoute((Route)route).build(service));
            return this;
        }
        return this.route().addRoute(Route.builder().pathPrefix(pathPrefix).build()).build(service);
    }

    public ServerBuilder service(String pathPattern, HttpService service) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(service, "service");
        ServerBuilder.warnIfServiceHasMultipleRoutes(pathPattern, service);
        return this.route().path(pathPattern).build(service);
    }

    public ServerBuilder service(Route route, HttpService service) {
        Objects.requireNonNull(route, "route");
        Objects.requireNonNull(service, "service");
        ServerBuilder.warnIfServiceHasMultipleRoutes(route.patternString(), service);
        return this.route().addRoute(route).build(service);
    }

    public ServerBuilder service(HttpServiceWithRoutes serviceWithRoutes, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        Objects.requireNonNull(serviceWithRoutes, "serviceWithRoutes");
        Objects.requireNonNull(serviceWithRoutes.routes(), "serviceWithRoutes.routes()");
        Objects.requireNonNull(decorators, "decorators");
        HttpService decorated = ServerBuilder.decorate(serviceWithRoutes, decorators);
        serviceWithRoutes.routes().forEach(route -> this.route().addRoute((Route)route).build(decorated));
        return this;
    }

    @SafeVarargs
    public final ServerBuilder service(HttpServiceWithRoutes serviceWithRoutes, Function<? super HttpService, ? extends HttpService> ... decorators) {
        return this.service(serviceWithRoutes, ImmutableList.copyOf(Objects.requireNonNull(decorators, "decorators")));
    }

    static HttpService decorate(HttpServiceWithRoutes serviceWithRoutes, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        HttpService decorated = serviceWithRoutes;
        for (Function<? super HttpService, ? extends HttpService> function : decorators) {
            Preconditions.checkNotNull(function, "decorators contains null: %s", decorators);
            decorated = function.apply(decorated);
            Preconditions.checkNotNull(decorated, "A decorator returned null: %s", function);
        }
        return decorated;
    }

    public ServerBuilder annotatedService(Object service) {
        return this.annotatedService("/", service, Function.identity(), ImmutableList.of());
    }

    public ServerBuilder annotatedService(Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public ServerBuilder annotatedService(Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service) {
        return this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.of());
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service, Iterable<?> exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, Function.identity(), exceptionHandlersAndConverters);
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Iterable<?> exceptionHandlersAndConverters) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        Objects.requireNonNull(decorator, "decorator");
        Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters");
        AnnotatedServiceExtensions configurator = AnnotatedServiceExtensions.ofExceptionHandlersAndConverters(exceptionHandlersAndConverters);
        return this.annotatedService(pathPrefix, service, decorator, configurator.exceptionHandlers(), configurator.requestConverters(), configurator.responseConverters());
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions, Iterable<? extends RequestConverterFunction> requestConverterFunctions, Iterable<? extends ResponseConverterFunction> responseConverterFunctions) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        Objects.requireNonNull(decorator, "decorator");
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        return ((AnnotatedServiceBindingBuilder)((AnnotatedServiceBindingBuilder)((AnnotatedServiceBindingBuilder)((AnnotatedServiceBindingBuilder)this.annotatedService().pathPrefix(pathPrefix).decorator((Function)decorator)).exceptionHandlers((Iterable)exceptionHandlerFunctions)).requestConverters((Iterable)requestConverterFunctions)).responseConverters((Iterable)responseConverterFunctions)).build(service);
    }

    public AnnotatedServiceBindingBuilder annotatedService() {
        return new AnnotatedServiceBindingBuilder(this);
    }

    ServerBuilder serviceConfigBuilder(ServiceConfigBuilder serviceConfigBuilder) {
        this.virtualHostTemplate.addServiceConfigSetters(serviceConfigBuilder);
        return this;
    }

    ServerBuilder annotatedServiceBindingBuilder(AnnotatedServiceBindingBuilder annotatedServiceBindingBuilder) {
        this.virtualHostTemplate.addServiceConfigSetters(annotatedServiceBindingBuilder);
        return this;
    }

    ServerBuilder routingDecorator(RouteDecoratingService routeDecoratingService) {
        this.virtualHostTemplate.addRouteDecoratingService(routeDecoratingService);
        return this;
    }

    public ServerBuilder serverListener(ServerListener serverListener) {
        Objects.requireNonNull(serverListener, "serverListener");
        this.serverListeners.add(serverListener);
        return this;
    }

    public ServerBuilder defaultHostname(String defaultHostname) {
        this.defaultVirtualHostBuilder.defaultHostname(defaultHostname);
        return this;
    }

    public ServerBuilder withDefaultVirtualHost(Consumer<? super VirtualHostBuilder> customizer) {
        customizer.accept(this.defaultVirtualHostBuilder);
        return this;
    }

    public VirtualHostBuilder defaultVirtualHost() {
        return this.defaultVirtualHostBuilder;
    }

    public ServerBuilder withVirtualHost(Consumer<? super VirtualHostBuilder> customizer) {
        VirtualHostBuilder virtualHostBuilder = new VirtualHostBuilder(this, false);
        customizer.accept(virtualHostBuilder);
        this.virtualHostBuilders.add(virtualHostBuilder);
        return this;
    }

    public VirtualHostBuilder virtualHost(String hostnamePattern) {
        VirtualHostBuilder virtualHostBuilder = new VirtualHostBuilder(this, false).hostnamePattern(hostnamePattern);
        this.virtualHostBuilders.add(virtualHostBuilder);
        return virtualHostBuilder;
    }

    public VirtualHostBuilder virtualHost(String defaultHostname, String hostnamePattern) {
        VirtualHostBuilder virtualHostBuilder = new VirtualHostBuilder(this, false).defaultHostname(defaultHostname).hostnamePattern(hostnamePattern);
        this.virtualHostBuilders.add(virtualHostBuilder);
        return virtualHostBuilder;
    }

    public VirtualHostBuilder virtualHost(int port) {
        Preconditions.checkArgument(port >= 1 && port <= 65535, "port: %s (expected: 1-65535)", port);
        Optional<VirtualHostBuilder> vhost = this.virtualHostBuilders.stream().filter(v -> v.port() == port && v.defaultVirtualHost()).findFirst();
        if (vhost.isPresent()) {
            return vhost.get();
        }
        VirtualHostBuilder virtualHostBuilder = new VirtualHostBuilder(this, port);
        this.virtualHostBuilders.add(virtualHostBuilder);
        return virtualHostBuilder;
    }

    public ServerBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.ofCatchAll(), decorator);
    }

    public ServerBuilder decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.ofCatchAll(), decoratingHttpServiceFunction);
    }

    public ServerBuilder decorator(String pathPattern, Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.builder().path(pathPattern).build(), decorator);
    }

    public ServerBuilder decorator(String pathPattern, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.builder().path(pathPattern).build(), decoratingHttpServiceFunction);
    }

    public ServerBuilder decorator(Route route, Function<? super HttpService, ? extends HttpService> decorator) {
        Objects.requireNonNull(route, "route");
        Objects.requireNonNull(decorator, "decorator");
        return this.routingDecorator(new RouteDecoratingService(route, decorator));
    }

    public ServerBuilder decorator(Route route, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        Objects.requireNonNull(decoratingHttpServiceFunction, "decoratingHttpServiceFunction");
        return this.decorator(route, (? super HttpService delegate) -> new FunctionalDecoratingHttpService((HttpService)delegate, decoratingHttpServiceFunction));
    }

    public ServerBuilder decoratorUnder(String prefix, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.builder().pathPrefix(prefix).build(), decoratingHttpServiceFunction);
    }

    public ServerBuilder decoratorUnder(String prefix, Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.builder().pathPrefix(prefix).build(), decorator);
    }

    @UnstableApi
    public ServerBuilder errorHandler(ServerErrorHandler errorHandler) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        if (errorHandler != ServerErrorHandler.ofDefault()) {
            errorHandler = errorHandler.orElse(ServerErrorHandler.ofDefault());
        }
        this.errorHandler = errorHandler;
        return this;
    }

    ServerErrorHandler errorHandler() {
        return this.errorHandler;
    }

    public ServerBuilder clientAddressSources(ClientAddressSource ... clientAddressSources) {
        this.clientAddressSources = ImmutableList.copyOf(Objects.requireNonNull(clientAddressSources, "clientAddressSources"));
        return this;
    }

    public ServerBuilder clientAddressSources(Iterable<ClientAddressSource> clientAddressSources) {
        this.clientAddressSources = ImmutableList.copyOf(Objects.requireNonNull(clientAddressSources, "clientAddressSources"));
        return this;
    }

    public ServerBuilder clientAddressTrustedProxyFilter(Predicate<? super InetAddress> clientAddressTrustedProxyFilter) {
        this.clientAddressTrustedProxyFilter = Objects.requireNonNull(clientAddressTrustedProxyFilter, "clientAddressTrustedProxyFilter");
        return this;
    }

    public ServerBuilder clientAddressFilter(Predicate<? super InetAddress> clientAddressFilter) {
        this.clientAddressFilter = Objects.requireNonNull(clientAddressFilter, "clientAddressFilter");
        return this;
    }

    public ServerBuilder clientAddressMapper(Function<? super ProxiedAddresses, ? extends InetSocketAddress> clientAddressMapper) {
        this.clientAddressMapper = Objects.requireNonNull(clientAddressMapper, "clientAddressMapper");
        return this;
    }

    public ServerBuilder accessLogger(String loggerName) {
        Objects.requireNonNull(loggerName, "loggerName");
        return this.accessLogger(LoggerFactory.getLogger((String)loggerName));
    }

    public ServerBuilder accessLogger(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        return this.accessLogger((? super VirtualHost host) -> logger);
    }

    public ServerBuilder accessLogger(Function<? super VirtualHost, ? extends Logger> mapper) {
        this.virtualHostTemplate.accessLogger(mapper);
        return this;
    }

    public ServerBuilder rejectedRouteHandler(RejectedRouteHandler handler) {
        this.virtualHostTemplate.rejectedRouteHandler(handler);
        return this;
    }

    public ServerBuilder disableServerHeader() {
        this.enableServerHeader = false;
        return this;
    }

    public ServerBuilder disableDateHeader() {
        this.enableDateHeader = false;
        return this;
    }

    @UnstableApi
    public ServerBuilder addHeader(CharSequence name, Object value) {
        this.virtualHostTemplate.addHeader(name, value);
        return this;
    }

    @UnstableApi
    public ServerBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.virtualHostTemplate.addHeaders(defaultHeaders);
        return this;
    }

    @UnstableApi
    public ServerBuilder setHeader(CharSequence name, Object value) {
        this.virtualHostTemplate.setHeader(name, value);
        return this;
    }

    @UnstableApi
    public ServerBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.virtualHostTemplate.setHeaders(defaultHeaders);
        return this;
    }

    @Deprecated
    public ServerBuilder requestIdGenerator(Supplier<? extends RequestId> requestIdSupplier) {
        Objects.requireNonNull(requestIdSupplier, "requestIdSupplier");
        return this.requestIdGenerator((? super RoutingContext routingContext) -> (RequestId)requestIdSupplier.get());
    }

    public ServerBuilder requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.virtualHostTemplate.requestIdGenerator(requestIdGenerator);
        return this;
    }

    public ServerBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    public ServerBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.virtualHostTemplate.requestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    public ServerBuilder maxRequestLength(long maxRequestLength) {
        this.virtualHostTemplate.maxRequestLength(maxRequestLength);
        return this;
    }

    public ServerBuilder verboseResponses(boolean verboseResponses) {
        this.virtualHostTemplate.verboseResponses(verboseResponses);
        return this;
    }

    public ServerBuilder annotatedServiceExtensions(Iterable<? extends RequestConverterFunction> requestConverterFunctions, Iterable<? extends ResponseConverterFunction> responseConverterFunctions, Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions) {
        this.virtualHostTemplate.annotatedServiceExtensions(requestConverterFunctions, responseConverterFunctions, exceptionHandlerFunctions);
        return this;
    }

    @UnstableApi
    public ServerBuilder dependencyInjector(DependencyInjector dependencyInjector, boolean shutdownOnStop) {
        Objects.requireNonNull(dependencyInjector, "dependencyInjector");
        if (this.dependencyInjector == null) {
            this.dependencyInjector = BuiltInDependencyInjector.INSTANCE;
        }
        this.dependencyInjector = this.dependencyInjector.orElse(dependencyInjector);
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(dependencyInjector));
        }
        return this;
    }

    @UnstableApi
    public ServerBuilder absoluteUriTransformer(Function<? super String, String> absoluteUriTransformer) {
        this.absoluteUriTransformer = Objects.requireNonNull(absoluteUriTransformer, "absoluteUriTransformer");
        return this;
    }

    public ServerBuilder http1HeaderNaming(Http1HeaderNaming http1HeaderNaming) {
        Objects.requireNonNull(http1HeaderNaming, "http1HeaderNaming");
        this.http1HeaderNaming = http1HeaderNaming;
        return this;
    }

    @UnstableApi
    public ServerBuilder unhandledExceptionsReportInterval(Duration unhandledExceptionsReportInterval) {
        Objects.requireNonNull(unhandledExceptionsReportInterval, "unhandledExceptionsReportInterval");
        Preconditions.checkArgument(!unhandledExceptionsReportInterval.isNegative());
        return this.unhandledExceptionsReportIntervalMillis(unhandledExceptionsReportInterval.toMillis());
    }

    @UnstableApi
    public ServerBuilder unhandledExceptionsReportIntervalMillis(long unhandledExceptionsReportIntervalMillis) {
        Preconditions.checkArgument(unhandledExceptionsReportIntervalMillis >= 0L, "unhandledExceptionsReportIntervalMillis: %s (expected: >= 0)", unhandledExceptionsReportIntervalMillis);
        this.unhandledExceptionsReportIntervalMillis = unhandledExceptionsReportIntervalMillis;
        return this;
    }

    public Server build() {
        Server server = new Server(this.buildServerConfig(this.ports));
        this.serverListeners.forEach(server::addListener);
        return server;
    }

    DefaultServerConfig buildServerConfig(ServerConfig existingConfig) {
        return this.buildServerConfig(existingConfig.ports());
    }

    private DefaultServerConfig buildServerConfig(List<ServerPort> serverPorts) {
        List<ServerPort> ports;
        Mapping sslContexts;
        UnhandledExceptionsReporter unhandledExceptionsReporter;
        AnnotatedServiceExtensions extensions = this.virtualHostTemplate.annotatedServiceExtensions();
        assert (extensions != null);
        DependencyInjector dependencyInjector = this.dependencyInjectorOrReflective();
        if (this.unhandledExceptionsReportIntervalMillis > 0L) {
            unhandledExceptionsReporter = UnhandledExceptionsReporter.of(this.meterRegistry, this.unhandledExceptionsReportIntervalMillis);
            this.serverListeners.add(unhandledExceptionsReporter);
        } else {
            unhandledExceptionsReporter = null;
        }
        VirtualHost defaultVirtualHost = this.defaultVirtualHostBuilder.build(this.virtualHostTemplate, dependencyInjector, unhandledExceptionsReporter);
        List virtualHosts = this.virtualHostBuilders.stream().map(vhb -> vhb.build(this.virtualHostTemplate, dependencyInjector, unhandledExceptionsReporter)).collect(ImmutableList.toImmutableList());
        SslContext defaultSslContext = ServerBuilder.findDefaultSslContext(defaultVirtualHost, virtualHosts);
        for (ServerPort port2 : this.ports) {
            Preconditions.checkState(port2.protocols().stream().anyMatch(p -> p != SessionProtocol.PROXY), "protocols: %s (expected: at least one %s or %s)", port2.protocols(), (Object)SessionProtocol.HTTP, (Object)SessionProtocol.HTTPS);
        }
        List portBasedVirtualHosts = virtualHosts.stream().filter(v -> v.port() > 0).collect(ImmutableList.toImmutableList());
        List portNumbers = this.ports.stream().map(port -> port.localAddress().getPort()).filter(port -> port > 0).collect(ImmutableList.toImmutableList());
        for (VirtualHost virtualHost : portBasedVirtualHosts) {
            int virtualHostPort = virtualHost.port();
            boolean portMatched = portNumbers.stream().anyMatch(port -> port == virtualHostPort);
            Preconditions.checkState(portMatched, "virtual host port: %s (expected: one of %s)", virtualHostPort, (Object)portNumbers);
        }
        if (defaultSslContext == null) {
            sslContexts = null;
            if (!serverPorts.isEmpty()) {
                ports = ServerBuilder.resolveDistinctPorts(serverPorts);
                for (ServerPort serverPort : ports) {
                    if (!serverPort.hasTls()) continue;
                    throw new IllegalArgumentException("TLS not configured; cannot serve HTTPS");
                }
            } else {
                ports = ImmutableList.of(new ServerPort(0, SessionProtocol.HTTP));
            }
        } else {
            if (!Flags.useOpenSsl() && !SystemInfo.jettyAlpnOptionalOrAvailable()) {
                throw new IllegalStateException("TLS configured but this is Java 8 and neither OpenSSL nor Jetty ALPN could be detected. To use TLS with Armeria, you must either use Java 9+, enable OpenSSL, usually by adding a build dependency on the io.netty:netty-tcnative-boringssl-static artifact or enable Jetty ALPN as described at https://www.eclipse.org/jetty/documentation/9.4.x/alpn-chapter.html");
            }
            ports = !serverPorts.isEmpty() ? ServerBuilder.resolveDistinctPorts(serverPorts) : ImmutableList.of(new ServerPort(0, SessionProtocol.HTTPS));
            DomainMappingBuilder<SslContext> mappingBuilder = new DomainMappingBuilder<SslContext>(defaultSslContext);
            for (VirtualHost h : virtualHosts) {
                String originalHostnamePattern;
                SslContext sslCtx = h.sslContext();
                if (sslCtx == null || "*".equals(originalHostnamePattern = h.originalHostnamePattern())) continue;
                mappingBuilder.add(originalHostnamePattern, sslCtx);
            }
            sslContexts = mappingBuilder.build();
        }
        if (this.pingIntervalMillis > 0L) {
            this.pingIntervalMillis = Math.max(this.pingIntervalMillis, 1000L);
            if (this.idleTimeoutMillis > 0L && this.pingIntervalMillis >= this.idleTimeoutMillis) {
                this.pingIntervalMillis = 0L;
            }
        }
        if (this.maxConnectionAgeMillis > 0L) {
            this.maxConnectionAgeMillis = Math.max(this.maxConnectionAgeMillis, 1000L);
            if (this.idleTimeoutMillis == 0L || this.idleTimeoutMillis > this.maxConnectionAgeMillis) {
                this.idleTimeoutMillis = this.maxConnectionAgeMillis;
            }
        }
        Map<ChannelOption<?>, Object> newChildChannelOptions = ChannelUtil.applyDefaultChannelOptions(this.childChannelOptions, this.idleTimeoutMillis, this.pingIntervalMillis);
        BlockingTaskExecutor blockingTaskExecutor = defaultVirtualHost.blockingTaskExecutor();
        return new DefaultServerConfig(ports, ServerBuilder.setSslContextIfAbsent(defaultVirtualHost, defaultSslContext), virtualHosts, this.workerGroup, this.shutdownWorkerGroupOnStop, this.startStopExecutor, this.maxNumConnections, this.idleTimeoutMillis, this.keepAliveOnPing, this.pingIntervalMillis, this.maxConnectionAgeMillis, this.maxNumRequestsPerConnection, this.connectionDrainDurationMicros, this.http2InitialConnectionWindowSize, this.http2InitialStreamWindowSize, this.http2MaxStreamsPerConnection, this.http2MaxFrameSize, this.http2MaxHeaderListSize, this.http1MaxInitialLineLength, this.http1MaxHeaderSize, this.http1MaxChunkSize, this.gracefulShutdownQuietPeriod, this.gracefulShutdownTimeout, blockingTaskExecutor, this.meterRegistry, this.proxyProtocolMaxTlvSize, this.channelOptions, newChildChannelOptions, this.childChannelPipelineCustomizer, this.clientAddressSources, this.clientAddressTrustedProxyFilter, this.clientAddressFilter, this.clientAddressMapper, this.enableServerHeader, this.enableDateHeader, this.errorHandler, (Mapping<String, SslContext>)sslContexts, this.http1HeaderNaming, dependencyInjector, this.absoluteUriTransformer, this.unhandledExceptionsReportIntervalMillis, ImmutableList.copyOf(this.shutdownSupports));
    }

    private static List<ServerPort> resolveDistinctPorts(List<ServerPort> ports) {
        ArrayList<ServerPort> distinctPorts = new ArrayList<ServerPort>();
        for (ServerPort port : ports) {
            boolean found = false;
            InetSocketAddress portAddress = port.localAddress();
            if (portAddress.getPort() > 0) {
                for (int i = 0; i < distinctPorts.size(); ++i) {
                    ServerPort distinctPort = (ServerPort)distinctPorts.get(i);
                    InetSocketAddress distinctPortAddress = distinctPort.localAddress();
                    boolean hasSameAddress = portAddress instanceof DomainSocketAddress ? (distinctPortAddress instanceof DomainSocketAddress ? ((DomainSocketAddress)portAddress).path().equals(((DomainSocketAddress)distinctPortAddress).path()) : false) : portAddress.equals(distinctPortAddress);
                    if (!hasSameAddress) continue;
                    ServerPort merged = new ServerPort(distinctPort.localAddress(), Sets.union(distinctPort.protocols(), port.protocols()));
                    distinctPorts.set(i, merged);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            distinctPorts.add(port);
        }
        return Collections.unmodifiableList(distinctPorts);
    }

    private DependencyInjector dependencyInjectorOrReflective() {
        if (this.dependencyInjector != null) {
            return this.dependencyInjector;
        }
        ReflectiveDependencyInjector reflectiveDependencyInjector = new ReflectiveDependencyInjector();
        this.shutdownSupports.add(ShutdownSupport.of(reflectiveDependencyInjector));
        return reflectiveDependencyInjector;
    }

    private static VirtualHost setSslContextIfAbsent(VirtualHost h, @Nullable SslContext defaultSslContext) {
        if (h.sslContext() != null || defaultSslContext == null) {
            return h;
        }
        return h.withNewSslContext(defaultSslContext);
    }

    @Nullable
    private static SslContext findDefaultSslContext(VirtualHost defaultVirtualHost, List<VirtualHost> virtualHosts) {
        SslContext defaultSslContext = defaultVirtualHost.sslContext();
        if (defaultSslContext != null) {
            return defaultSslContext;
        }
        for (int i = virtualHosts.size() - 1; i >= 0; --i) {
            SslContext sslContext = virtualHosts.get(i).sslContext();
            if (sslContext == null) continue;
            return sslContext;
        }
        return null;
    }

    private static void warnIfServiceHasMultipleRoutes(String path, HttpService service) {
        if (service instanceof ServiceWithRoutes) {
            if (!Flags.reportMaskedRoutes()) {
                return;
            }
            if (((ServiceWithRoutes)((Object)service)).routes().size() > 0) {
                logger.warn("The service has self-defined routes but the routes will be ignored. It will be served at the route you specified: path={}, service={}. If this is intended behavior, you can disable this log message by specifying the -Dcom.linecorp.armeria.reportMaskedRoutes=false JVM option.", (Object)path, (Object)service);
            }
        }
    }

    static {
        RequestContextUtil.init();
    }
}

