/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import com.linecorp.armeria.server.AbstractHttpResponseSubscriber;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;

final class HttpResponseSubscriber
extends AbstractHttpResponseSubscriber {
    HttpResponseSubscriber(ChannelHandlerContext ctx, ServerHttpObjectEncoder responseEncoder, DefaultServiceRequestContext reqCtx, DecodedHttpRequest req, CompletableFuture<Void> completionFuture) {
        super(ctx, responseEncoder, reqCtx, req, completionFuture);
    }

    @Override
    void onResponseHeaders(ResponseHeaders headers) {
        ResponseHeaders merged;
        boolean endOfStream = headers.isEndOfStream();
        HttpStatus status = headers.status();
        if (status.isInformational()) {
            if (endOfStream) {
                this.req.abortResponse(new IllegalStateException("published an informational headers whose endOfStream is true: " + headers + " (service: " + this.service() + ')'), true);
                return;
            }
            merged = headers;
        } else {
            if (this.req.method() == HttpMethod.HEAD) {
                endOfStream = true;
            } else if (status.isContentAlwaysEmpty()) {
                this.setState(AbstractHttpResponseSubscriber.State.NEEDS_TRAILERS);
            } else {
                this.setState(AbstractHttpResponseSubscriber.State.NEEDS_DATA_OR_TRAILERS);
            }
            if (endOfStream) {
                this.setDone(true);
            }
            ServerConfig config = this.reqCtx.config().server().config();
            merged = HttpHeadersUtil.mergeResponseHeaders(headers, this.reqCtx.additionalResponseHeaders(), this.reqCtx.config().defaultHeaders(), config.isServerHeaderEnabled(), config.isDateHeaderEnabled());
            String connectionOption = merged.get((CharSequence)HttpHeaderNames.CONNECTION);
            if (HttpHeadersUtil.CLOSE_STRING.equalsIgnoreCase(connectionOption)) {
                this.disconnectWhenFinished();
            }
            this.logBuilder().responseHeaders(merged);
        }
        this.responseEncoder.writeHeaders(this.req.id(), this.req.streamId(), merged, endOfStream, this.reqCtx.additionalResponseTrailers().isEmpty()).addListener((GenericFutureListener)this.writeHeadersFutureListener(endOfStream));
    }
}

