/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.VirtualHost;
import java.util.List;
import java.util.Objects;

final class DefaultRoutingContext
implements RoutingContext {
    private final VirtualHost virtualHost;
    private final String hostname;
    private final HttpMethod method;
    private final RequestHeaders headers;
    private final RequestTarget reqTarget;
    @Nullable
    private final MediaType contentType;
    private final List<MediaType> acceptTypes;
    private final RoutingStatus routingStatus;
    @Nullable
    private volatile QueryParams queryParams;
    @Nullable
    private HttpStatusException deferredCause;
    @Nullable
    private Routed<ServiceConfig> result;
    private final int hashCode;

    static RoutingContext of(VirtualHost virtualHost, String hostname, RequestTarget reqTarget, RequestHeaders headers, RoutingStatus routingStatus) {
        return new DefaultRoutingContext(virtualHost, hostname, headers, reqTarget, routingStatus);
    }

    DefaultRoutingContext(VirtualHost virtualHost, String hostname, RequestHeaders headers, RequestTarget reqTarget, RoutingStatus routingStatus) {
        this.virtualHost = Objects.requireNonNull(virtualHost, "virtualHost");
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        this.headers = Objects.requireNonNull(headers, "headers");
        this.reqTarget = Objects.requireNonNull(reqTarget, "reqTarget");
        this.routingStatus = routingStatus;
        this.method = headers.method();
        this.contentType = headers.contentType();
        this.acceptTypes = headers.accept();
        this.hashCode = DefaultRoutingContext.hashCode(this);
    }

    @Override
    public VirtualHost virtualHost() {
        return this.virtualHost;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public RequestTarget requestTarget() {
        return this.reqTarget;
    }

    @Override
    public String path() {
        return this.reqTarget.path();
    }

    @Override
    @Nullable
    public String query() {
        return this.reqTarget.query();
    }

    @Override
    public QueryParams params() {
        QueryParams queryParams = this.queryParams;
        if (queryParams == null) {
            String query = this.reqTarget.query();
            queryParams = query == null ? QueryParams.of() : QueryParams.fromQueryString(query);
            this.queryParams = queryParams;
        }
        return queryParams;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public List<MediaType> acceptTypes() {
        return this.acceptTypes;
    }

    @Override
    public boolean isCorsPreflight() {
        return this.status() == RoutingStatus.CORS_PREFLIGHT;
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public RoutingStatus status() {
        return this.routingStatus;
    }

    @Override
    public void deferStatusException(HttpStatusException deferredCause) {
        this.deferredCause = Objects.requireNonNull(deferredCause, "deferredCause");
    }

    @Override
    public HttpStatusException deferredStatusException() {
        return this.deferredCause;
    }

    @Override
    public boolean hasResult() {
        return this.result != null;
    }

    @Override
    public void setResult(Routed<ServiceConfig> result) {
        Objects.requireNonNull(result, "result");
        Preconditions.checkState(this.result == null, "result is set already.");
        this.result = result;
    }

    @Override
    public Routed<ServiceConfig> result() {
        Preconditions.checkState(this.result != null, "result has not set yet.");
        return this.result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    static int hashCode(RoutingContext routingCtx) {
        int result = routingCtx.virtualHost().hashCode();
        result *= 31;
        result += routingCtx.method().hashCode();
        result *= 31;
        result += routingCtx.path().hashCode();
        result *= 31;
        result += Objects.hashCode(routingCtx.contentType());
        for (MediaType mediaType : routingCtx.acceptTypes()) {
            result *= 31;
            result += mediaType.hashCode();
        }
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        return DefaultRoutingContext.equals(this, obj);
    }

    static boolean equals(RoutingContext self, @Nullable Object obj) {
        if (self == obj) {
            return true;
        }
        if (!(obj instanceof RoutingContext)) {
            return false;
        }
        RoutingContext other = (RoutingContext)obj;
        return self.virtualHost().equals(other.virtualHost()) && self.method() == other.method() && self.path().equals(other.path()) && Objects.equals(self.contentType(), other.contentType()) && self.acceptTypes().equals(other.acceptTypes());
    }

    public String toString() {
        return DefaultRoutingContext.toString(this);
    }

    static String toString(RoutingContext routingCtx) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(routingCtx).omitNullValues().add("virtualHost", routingCtx.virtualHost()).add("method", (Object)routingCtx.method()).add("path", routingCtx.path()).add("query", routingCtx.query()).add("contentType", routingCtx.contentType()).add("status", (Object)routingCtx.status());
        if (routingCtx.hasResult()) {
            helper.add("result", routingCtx.result());
        }
        if (!routingCtx.acceptTypes().isEmpty()) {
            helper.add("acceptTypes", routingCtx.acceptTypes());
        }
        helper.add("requiresMatchingParamsPredicates", routingCtx.requiresMatchingParamsPredicates()).add("requiresMatchingHeadersPredicates", routingCtx.requiresMatchingHeadersPredicates());
        return helper.toString();
    }
}

