/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.RDN;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.style.BCStyle;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.style.IETFUtils;
import com.linecorp.armeria.internal.shaded.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.caffeine.cache.LoadingCache;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CertificateUtil {
    private static final Logger logger = LoggerFactory.getLogger(CertificateUtil.class);
    private static final LoadingCache<X509Certificate, String> commonNameCache = Caffeine.newBuilder().weakKeys().build(cert -> {
        try {
            X500Name x500Name = new JcaX509CertificateHolder((X509Certificate)cert).getSubject();
            RDN cn = x500Name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString(cn.getFirst().getValue());
        }
        catch (Exception e) {
            logger.warn("Failed to get the common name from a certificate: {}", cert, (Object)e);
            return null;
        }
    });

    @Nullable
    static String getCommonName(SSLSession session) {
        Certificate[] certs = session.getLocalCertificates();
        if (certs == null || certs.length == 0) {
            return null;
        }
        return CertificateUtil.getCommonName(certs[0]);
    }

    @Nullable
    static String getCommonName(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        return commonNameCache.get((X509Certificate)certificate);
    }

    private CertificateUtil() {
    }
}

