/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.CompositeException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NonOverridableStreamMessageWrapper;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FuseableStreamMessage<T, U>
implements StreamMessage<U> {
    private final StreamMessage<Object> source;
    @Nullable
    private final MapperFunction<Object, U> function;
    @Nullable
    private final Function<Throwable, Throwable> errorFunction;

    static <T> FuseableStreamMessage<T, T> of(StreamMessage<? extends T> source, Predicate<? super T> predicate) {
        return new FuseableStreamMessage<T, T>(source, MapperFunction.of(predicate), null);
    }

    static <T, R> FuseableStreamMessage<T, R> of(StreamMessage<? extends T> source, Function<? super T, ? extends R> function) {
        return new FuseableStreamMessage<T, R>(source, MapperFunction.of(function), null);
    }

    static <T> FuseableStreamMessage<T, T> error(StreamMessage<? extends T> source, Function<? super Throwable, ? extends Throwable> errorFunction) {
        return new FuseableStreamMessage(source, null, errorFunction);
    }

    private FuseableStreamMessage(StreamMessage<? extends T> source, @Nullable MapperFunction<T, U> function, @Nullable Function<? super Throwable, ? extends Throwable> errorFunction) {
        Objects.requireNonNull(source, "source");
        assert (function != null && errorFunction == null || function == null && errorFunction != null) : "function and errorFunction should be mutually exclusive";
        if ((source = this.peel(source)) instanceof FuseableStreamMessage) {
            FuseableStreamMessage cast = (FuseableStreamMessage)source;
            this.source = cast.source;
            if (function != null) {
                this.function = cast.function != null ? cast.function.and(function) : function;
                this.errorFunction = cast.errorFunction;
            } else {
                this.errorFunction = cast.errorFunction != null ? cast.errorFunction.andThen(errorFunction) : errorFunction;
                this.function = cast.function;
            }
        } else {
            this.source = source;
            this.function = function;
            this.errorFunction = errorFunction;
        }
    }

    private StreamMessage<? extends T> peel(StreamMessage<? extends T> source) {
        if (!(source instanceof NonOverridableStreamMessageWrapper)) {
            return source;
        }
        while ((source = ((NonOverridableStreamMessageWrapper)source).delegate()) instanceof NonOverridableStreamMessageWrapper) {
        }
        return source;
    }

    StreamMessage<Object> upstream() {
        return this.source;
    }

    @Override
    public boolean isOpen() {
        return this.source.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public long demand() {
        return this.source.demand();
    }

    @Override
    public CompletableFuture<List<U>> collect(EventExecutor executor, SubscriptionOption ... options) {
        return this.source.collect(executor, options).handle((objs, cause) -> {
            if (cause != null) {
                if (this.errorFunction != null) {
                    try {
                        cause = this.errorFunction.apply((Throwable)cause);
                        Objects.requireNonNull(cause, "errorFunction.apply() returned null");
                    }
                    catch (Throwable t) {
                        cause = new CompositeException(t, (Throwable)cause);
                    }
                }
                return (List)Exceptions.throwUnsafely(cause);
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(objs.size());
            Throwable cause0 = null;
            boolean withPooledObjects = InternalStreamMessageUtil.containsWithPooledObjects(options);
            for (Object obj : objs) {
                if (cause0 != null) {
                    StreamMessageUtil.closeOrAbort(obj, cause0);
                    continue;
                }
                try {
                    Object result = this.function == null ? obj : this.function.apply(obj);
                    if (result != null) {
                        result = StreamMessageUtil.touchOrCopyAndClose(result, withPooledObjects);
                        builder.add(result);
                        continue;
                    }
                    StreamMessageUtil.closeOrAbort(obj);
                }
                catch (Throwable ex) {
                    if (this.errorFunction != null) {
                        try {
                            ex = this.errorFunction.apply(ex);
                            Objects.requireNonNull(ex, "errorFunction.apply() returned null");
                        }
                        catch (Throwable t) {
                            ex = new CompositeException(t, ex);
                        }
                    }
                    StreamMessageUtil.closeOrAbort(obj, ex);
                    cause0 = ex;
                }
            }
            ImmutableCollection elements = builder.build();
            if (cause0 != null) {
                for (Object element : elements) {
                    StreamMessageUtil.closeOrAbort(element, cause0);
                }
                return (List)Exceptions.throwUnsafely(cause0);
            }
            return elements;
        });
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.source.whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        this.source.subscribe(new FuseableSubscriber<U>(subscriber, this.function, this.errorFunction, InternalStreamMessageUtil.containsWithPooledObjects(options)), executor, options);
    }

    @Override
    public void abort() {
        this.source.abort();
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.source.abort(cause);
    }

    @FunctionalInterface
    static interface MapperFunction<T, R>
    extends Function<T, R> {
        public static <T, R> MapperFunction<T, R> of(Function<? super T, ? extends R> function) {
            Objects.requireNonNull(function, "function");
            return o -> {
                Object result = function.apply(o);
                Objects.requireNonNull(result, "function.apply() returned null");
                return result;
            };
        }

        public static <T> MapperFunction<T, T> of(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate");
            return o -> {
                boolean result = predicate.test(o);
                if (result) {
                    return o;
                }
                return null;
            };
        }

        default public <V> MapperFunction<T, V> and(MapperFunction<? super R, ? extends V> after) {
            return in -> {
                R out = this.apply(in);
                if (out != null) {
                    return after.apply((R)out);
                }
                return null;
            };
        }

        @Override
        default public <V> Function<T, V> andThen(Function<? super R, ? extends V> after) {
            throw new UnsupportedOperationException("Must use and(MapperFunction) instead.");
        }

        @Override
        default public <V> Function<V, R> compose(Function<? super V, ? extends T> before) {
            throw new UnsupportedOperationException("compose is not allowed for " + MapperFunction.class.getName());
        }

        @Override
        @Nullable
        public R apply(T var1);
    }

    private static final class FuseableSubscriber<U>
    implements Subscriber<Object>,
    Subscription {
        private final Subscriber<? super U> downstream;
        @Nullable
        private final MapperFunction<Object, U> function;
        @Nullable
        private final Function<Throwable, Throwable> errorFunction;
        private final boolean withPooledObjects;
        @Nullable
        private volatile Subscription upstream;
        private volatile boolean canceled;

        FuseableSubscriber(Subscriber<? super U> downstream, @Nullable MapperFunction<Object, U> function, @Nullable Function<Throwable, Throwable> errorFunction, boolean withPooledObjects) {
            Objects.requireNonNull(downstream, "downstream");
            this.downstream = downstream;
            this.function = function;
            this.errorFunction = errorFunction;
            this.withPooledObjects = withPooledObjects;
        }

        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            this.upstream = subscription;
            this.downstream.onSubscribe((Subscription)this);
        }

        public void onNext(Object item) {
            Objects.requireNonNull(item, "item");
            if (this.canceled) {
                StreamMessageUtil.closeOrAbort(item);
                return;
            }
            Object result = null;
            try {
                result = this.function != null ? this.function.apply(item) : item;
                if (result != null) {
                    result = StreamMessageUtil.touchOrCopyAndClose(result, this.withPooledObjects);
                    this.downstream.onNext(result);
                } else {
                    StreamMessageUtil.closeOrAbort(item);
                    this.upstream.request(1L);
                }
            }
            catch (Throwable ex) {
                StreamMessageUtil.closeOrAbort(item, ex);
                if (result != null && item != result) {
                    StreamMessageUtil.closeOrAbort(result, ex);
                }
                this.upstream.cancel();
                this.onError(ex);
            }
        }

        public void onError(Throwable cause) {
            Objects.requireNonNull(cause, "cause");
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            if (this.errorFunction != null) {
                Throwable transformed;
                try {
                    transformed = this.errorFunction.apply(cause);
                    Objects.requireNonNull(transformed, "errorFunction.apply() returned null");
                }
                catch (Throwable t) {
                    transformed = new CompositeException(t, cause);
                }
                this.downstream.onError(transformed);
            } else {
                this.downstream.onError(cause);
            }
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        public void request(long n) {
            if (this.canceled) {
                return;
            }
            this.upstream.request(n);
        }

        public void cancel() {
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            this.upstream.cancel();
        }
    }
}

